/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.yml;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.slipcor.pvpstats.core.ConfigEntry;
import net.slipcor.pvpstats.core.CoreConfig;
import net.slipcor.pvpstats.core.CorePlugin;

public class Config
extends CoreConfig {
    public Config(CorePlugin plugin) {
        super(plugin, "PVP Stats Config", new File(plugin.getDataFolder(), "config.yml"));
        this.emptyNodes = new String[]{"MySQL", "SQLite", "YML", "statistics", "other", "eloscore", "eloscore.k-factor", "msg", "update", "bStats", "general"};
    }

    @Override
    public ConfigEntry getByNode(String node) {
        for (Entry e : Entry.values()) {
            if (!e.node.equals(node)) continue;
            return e;
        }
        return null;
    }

    @Override
    public boolean load() {
        try {
            this.cfg.load(this.configFile);
            this.reloadMaps();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected boolean checkMaterials(String s) {
        return false;
    }

    @Override
    protected void loadMaterials() {
    }

    public static enum Entry implements ConfigEntry
    {
        GENERAL(ConfigEntry.Type.COMMENT, "General", null, "=== [ General Settings ] ==="),
        GENERAL_SHORTHAND_COMMANDS(ConfigEntry.Type.BOOLEAN, "general.shortHandCommands", true, "Allow command shorthands"),
        GENERAL_SHOW_COMMANDS(ConfigEntry.Type.BOOLEAN, "general.showCommands", true, "Show available commands instead of looking for a player"),
        MYSQL(ConfigEntry.Type.COMMENT, "MySQL", null, "=== [ MySQL Settings ] ==="),
        MYSQL_ACTIVE(ConfigEntry.Type.BOOLEAN, "MySQL.active", false, "activate MySQL"),
        MYSQL_HOST(ConfigEntry.Type.STRING, "MySQL.hostname", "host", "hostname to use to connect to the database, in most cases 'localhost'"),
        MYSQL_USERNAME(ConfigEntry.Type.STRING, "MySQL.username", "user", "username to use to connect to the database"),
        MYSQL_PASSWORD(ConfigEntry.Type.STRING, "MySQL.password", "pw", "password to use to connect to the database"),
        MYSQL_DATABASE(ConfigEntry.Type.STRING, "MySQL.database", "db", "database name to connect to"),
        MYSQL_PORT(ConfigEntry.Type.INT, "MySQL.port", 3306, "database port to connect to"),
        MYSQL_TABLE(ConfigEntry.Type.STRING, "MySQL.table", "pvpstats", "general statistic table name"),
        MYSQL_KILLTABLE(ConfigEntry.Type.STRING, "MySQL.killtable", "pvpkillstats", "kill statistic table name"),
        MYSQL_OPTIONS(ConfigEntry.Type.STRING, "MySQL.options", "?autoReconnect=true", "connection options"),
        SQLITE(ConfigEntry.Type.COMMENT, "SQLite", null, "=== [ SQLite Settings ] ==="),
        SQLITE_ACTIVE(ConfigEntry.Type.BOOLEAN, "SQLite.active", false, "activate SQLite"),
        SQLITE_FILENAME(ConfigEntry.Type.STRING, "SQLite.filename", "database", "database file name, plugin will append extension '.db'"),
        SQLITE_TABLE(ConfigEntry.Type.STRING, "SQLite.table", "pvpstats", "general statistic table name"),
        SQLITE_KILLTABLE(ConfigEntry.Type.STRING, "SQLite.killtable", "pvpkillstats", "kill statistic table name"),
        YML(ConfigEntry.Type.COMMENT, "YML", null, "=== [ YML Database Emulation Settings ] ==="),
        YML_TABLE(ConfigEntry.Type.STRING, "YML.table", "pvpstats", "general statistic file name, plugin will append extension '.yml'"),
        YML_KILLTABLE(ConfigEntry.Type.STRING, "YML.killtable", "pvpkillstats", "kill statistic file name, plugin will append extension '.yml'"),
        YML_COLLECT_PRECISE(ConfigEntry.Type.BOOLEAN, "YML.collectPreciseOverride", false, "really save every kill? This is not advised for YML!"),
        STATISTICS(ConfigEntry.Type.COMMENT, "statistics", null, "=== [ Statistic Settings ] ==="),
        STATISTICS_ASSIST_SECONDS(ConfigEntry.Type.INT, "statistics.assistSeconds", 60, "time in seconds to consider a former kill an assist"),
        STATISTICS_LIST_LENGTH(ConfigEntry.Type.INT, "statistics.maxListLength", 10, "amount of players to be stored in cached top and flop lists"),
        STATISTICS_CLEAR_ON_START(ConfigEntry.Type.BOOLEAN, "statistics.clearOnStart", true, "clear (duplicated) statistics on every start"),
        STATISTICS_CREATE_ON_JOIN(ConfigEntry.Type.BOOLEAN, "statistics.createOnJoin", true, "create empty player entry when they join"),
        STATISTICS_COLLECT_PRECISE(ConfigEntry.Type.BOOLEAN, "statistics.collectPrecise", true, "save every kill - is never read internally, so only for web stats or alike"),
        STATISTICS_COUNT_REGULAR_DEATHS(ConfigEntry.Type.BOOLEAN, "statistics.countRegularDeaths", false, "count dying from other sources than players (and their tamed pets) towards death count and resetting of streaks"),
        STATISTICS_COUNT_PET_DEATHS(ConfigEntry.Type.BOOLEAN, "statistics.countPetDeaths", false, "count dying from other player's tamed pets for death count and resetting of streaks"),
        STATISTICS_CHECK_ABUSE(ConfigEntry.Type.BOOLEAN, "statistics.checkAbuse", true, "prevent players from getting kills from the same victim"),
        STATISTICS_CHECK_ALT_ABUSE(ConfigEntry.Type.BOOLEAN, "statistics.checkAltAbuse", false, "prevent players from getting kills from the same ip address (alts)"),
        STATISTICS_ABUSE_COMPLEX(ConfigEntry.Type.BOOLEAN, "statistics.abuseComplex", false, "prevent players from getting kills from the same victim, remembering more than one kill"),
        STATISTICS_CHECK_NEWBIES(ConfigEntry.Type.BOOLEAN, "statistics.checkNewbies", true, "prevent stats for players with the permission 'pvpstats.newbie'"),
        STATISTICS_ABUSE_SECONDS(ConfigEntry.Type.INT, "statistics.abuseSeconds", -1, "seconds to wait before allowing to kill the same player again to count (-1 will never reset)"),
        STATISTICS_DEATHS_DESCENDING(ConfigEntry.Type.BOOLEAN, "statistics.deathsDescending", false, "order deaths descending by default (rather than TOP deaths being LESS deaths)"),
        STATISTICS_KD_CALCULATION(ConfigEntry.Type.STRING, "statistics.killDeathCalculation", "&k/&d", "mathematical formula to calculate kill/death ratio"),
        STATISTICS_KD_SIMPLE(ConfigEntry.Type.BOOLEAN, "statistics.killDeathSimple", false, "simplify kill/death ratio calculation to just kills per deaths"),
        STATISTICS_PREVENTING_PLAYER_META(ConfigEntry.Type.LIST, "statistics.preventingPlayerMeta", Collections.singletonList("NPC"), "player meta that marks players as not counting, for example 'NPC' for most plugins that add them"),
        STATISTICS_RESET_KILLSTREAK_ON_QUIT(ConfigEntry.Type.BOOLEAN, "statistics.resetKillstreakOnQuit", false, "always reset a streak when a player disconnects"),
        STATISTICS_LEADERBOARD_REFRESH(ConfigEntry.Type.INT, "statistics.leaderboardRefresh", 60, "seconds to wait before the top/flop leaderboard values will query the database again"),
        STATISTICS_SHORT_PLACEHOLDERS(ConfigEntry.Type.BOOLEAN, "statistics.shortPlaceholders", false, "try using super short placeholders"),
        STATISTICS_STREAK_ANNOUNCEMENTS(ConfigEntry.Type.BOOLEAN, "statistics.streakAnnouncements", false, "announce lines from streak_announcements.yml on specific streak values"),
        STATISTICS_STREAK_INTERVAL_ANNOUNCEMENTS(ConfigEntry.Type.BOOLEAN, "statistics.streakIntervalAnnouncements", false, "announce lines from streak_announcements.yml after a set amount of streak levels"),
        STATISTICS_STREAK_COMMANDS(ConfigEntry.Type.BOOLEAN, "statistics.streakCommands", false, "issue commands from streak_commands.yml on specific streak values"),
        STATISTICS_STREAK_BROKEN_THRESHOLD(ConfigEntry.Type.INT, "statistics.streakBrokenThreshold", 0, "the minimum streak required to announce it has been broken (0=announce all)"),
        STATISTICS_STREAK_INTERVAL_COMMANDS(ConfigEntry.Type.BOOLEAN, "statistics.streakIntervalCommands", false, "issue commands from streak_commands.yml after a set amount of streak levels"),
        STATISTICS_FORCE_RELOAD_INTERVAL(ConfigEntry.Type.INT, "statistics.forceReloadInterval", -1, "force reload the database from outside changes after how many seconds"),
        ELO(ConfigEntry.Type.COMMENT, "eloscore", null, "=== [ ELO Score Settings ] ==="),
        ELO_ACTIVE(ConfigEntry.Type.BOOLEAN, "eloscore.active", false, null),
        ELO_ANNOUNCE_PUBLIC(ConfigEntry.Type.BOOLEAN, "eloscore.announce-public", false, "should we announce ELO point changes publicly?"),
        ELO_MINIMUM(ConfigEntry.Type.INT, "eloscore.minimum", 18, "min possible ELO score"),
        ELO_DEFAULT(ConfigEntry.Type.INT, "eloscore.default", 1500, "starting ELO score"),
        ELO_MAXIMUM(ConfigEntry.Type.INT, "eloscore.maximum", 3000, "max possible ELO score"),
        ELO_KFACTOR(ConfigEntry.Type.COMMENT, "eloscore.k-factor", null, "K-Factor settings"),
        ELO_K_BELOW(ConfigEntry.Type.INT, "eloscore.k-factor.below", 32, "K-Factor below threshold"),
        ELO_K_ABOVE(ConfigEntry.Type.INT, "eloscore.k-factor.above", 16, "K-Factor above threshold"),
        ELO_K_THRESHOLD(ConfigEntry.Type.INT, "eloscore.k-factor.threshold", 2000, "K-Factor threshold"),
        MESSAGES(ConfigEntry.Type.COMMENT, "msg", null, "=== [ Message Settings ] ==="),
        MESSAGES_OVERRIDES(ConfigEntry.Type.BOOLEAN, "msg.overrides", false, "activate the following overrides"),
        MESSAGES_OVERRIDE_LIST(ConfigEntry.Type.LIST, "msg.main", Arrays.asList("&cName: &7%n", "&cKills: &7%k", "&cDeaths: &7%d", "&cRatio: &7%r", "&cStreak: &7%s", "&cMax Streak: &7%m"), null),
        UPDATE(ConfigEntry.Type.COMMENT, "update", null, "=== [ Updater Settings ] ==="),
        UPDATE_MODE(ConfigEntry.Type.STRING, "update.mode", "both", "what to do? Valid values: disable, announce, download, both"),
        UPDATE_TYPE(ConfigEntry.Type.STRING, "update.type", "beta", "which type of branch to get updates? Valid values: dev, alpha, beta, release"),
        OTHER(ConfigEntry.Type.COMMENT, "other", null, "=== [ Other Features ] ==="),
        OTHER_DISPLAYNAMES(ConfigEntry.Type.BOOLEAN, "other.displayNames", false, "use players' display names"),
        OTHER_AVOID_PLAYER_LOOKUP(ConfigEntry.Type.BOOLEAN, "other.avoidPlayerLookup", false, "avoid possibly costly Mojang API lookup for unknown player names"),
        OTHER_PVPARENA(ConfigEntry.Type.BOOLEAN, "other.PVPArena", false, "count PVP Arena deaths"),
        OTHER_OP_MESSAGES(ConfigEntry.Type.BOOLEAN, "other.OPMessages", true, "provide helpful debug messages for new installations"),
        BSTATS(ConfigEntry.Type.COMMENT, "bStats", null, "=== [ bStats Metrics Settings ] ==="),
        BSTATS_ENABLED(ConfigEntry.Type.BOOLEAN, "bStats.enabled", true, "Should we send stats at all? Please keep this in so we have an overview of spread of versions <3"),
        BSTATS_FULL(ConfigEntry.Type.BOOLEAN, "bStats.full", true, "This setting sends a bit more detailed information about which features are used at all. Thank you for supporting me!"),
        IGNORE_WORLDS(ConfigEntry.Type.LIST, "ignoreworlds", Collections.singletonList("doNotTrack"), "world names where not to count statistics"),
        LEADERBOARDS(ConfigEntry.Type.MAP, "leaderboards", null, "Leaderboards go here. Do not change these unless you know what you are doing!"),
        VERSION(ConfigEntry.Type.INT, "ver", null, "Version for automatic config updating"),
        DEBUG(ConfigEntry.Type.STRING, "debug", null, "Debug - only change this when you know what you are doing"),
        DISPLAYS(ConfigEntry.Type.LIST, "leaderboards", new ArrayList<E>(), "locations of leaderboards");

        final ConfigEntry.Type type;
        final String node;
        final Object value;
        final String comment;
        public boolean secret;

        private Entry(ConfigEntry.Type type, String node, Object def, String comment) {
            this.type = type;
            this.node = node;
            this.value = def;
            this.comment = comment;
        }

        public static Entry getByNode(String node) {
            for (Entry c : Entry.values()) {
                if (!c.getNode().equals(node)) continue;
                return c;
            }
            return null;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public String getNode() {
            return this.node;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public ConfigEntry.Type getType() {
            return this.type;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        static {
            Entry.MYSQL_USERNAME.secret = true;
            Entry.MYSQL_PASSWORD.secret = true;
            Entry.MYSQL_PORT.secret = true;
            Entry.MYSQL_DATABASE.secret = true;
            Entry.MYSQL_HOST.secret = true;
        }
    }
}

