/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.text;

import org.bukkit.ChatColor;

public class TextComponent {
    private final String text;
    private boolean underline;
    private boolean bold;
    private boolean italic;
    private boolean striked;
    private ChatColor color = ChatColor.WHITE;
    private String command;
    private TextComponent hoverText;

    public TextComponent(String text) {
        if (text == null || text.isEmpty()) {
            throw new IllegalArgumentException("Text cannot be empty!");
        }
        this.text = text;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public String getCommand() {
        return this.command;
    }

    public TextComponent getHoverText() {
        return this.hoverText;
    }

    public String getText() {
        return this.text;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isStriked() {
        return this.striked;
    }

    public boolean isUnderlined() {
        return this.underline;
    }

    public TextComponent setBold(boolean bold) {
        this.bold = bold;
        return this;
    }

    public TextComponent setCommand(String command) {
        this.command = command;
        return this;
    }

    public TextComponent setColor(ChatColor color) {
        this.color = color;
        return this;
    }

    public TextComponent setHoverText(TextComponent hoverText) {
        if (this.equals(hoverText)) {
            throw new IllegalArgumentException("Cannot set hover to itself!");
        }
        if (hoverText.hoverText != null) {
            throw new IllegalArgumentException("Hover cannot have hover!");
        }
        this.hoverText = hoverText;
        return this;
    }

    public TextComponent setItalic(boolean italic) {
        this.italic = italic;
        return this;
    }

    public TextComponent setStriked(boolean striked) {
        this.striked = striked;
        return this;
    }

    public TextComponent setUnderlined(boolean underline) {
        this.underline = underline;
        return this;
    }

    public String toString() {
        if (this.hoverText != null && this.hoverText.hoverText != null) {
            throw new IllegalArgumentException("Hover cannot have hover!");
        }
        StringBuffer result = new StringBuffer("{\"text\":\"");
        result.append(this.text);
        result.append('\"');
        if (this.isBold()) {
            result.append(",\"bold\":true");
        }
        if (this.isItalic()) {
            result.append(",\"italic\":true");
        }
        if (this.isStriked()) {
            result.append(",\"strikethrough\":true");
        }
        if (this.isUnderlined()) {
            result.append(",\"underlined\":true");
        }
        if (this.getColor() != ChatColor.WHITE) {
            result.append(",\"color\":\"");
            result.append(this.getColor().name().toLowerCase());
            result.append('\"');
        }
        if (this.command != null) {
            result.append(",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"");
            result.append(this.command);
            result.append("\"}");
        }
        if (this.hoverText != null) {
            result.append(",\"hoverEvent\":{\"action\":\"show_text\",\"contents\":");
            result.append(this.hoverText.toString());
            result.append('}');
        }
        result.append('}');
        return result.toString();
    }
}

