/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.runnables;

import java.util.HashMap;
import java.util.Map;
import net.slipcor.pvpstats.api.LeaderboardBuffer;
import net.slipcor.pvpstats.core.LanguageEntry;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class SendPlayerTopWorld
implements Runnable {
    final CommandSender sender;
    final String type;
    final int amount;
    final int days;
    final String displayAmount;
    final World world;
    static Map<String, LanguageEntry> stringToEntry = new HashMap<String, LanguageEntry>();

    public SendPlayerTopWorld(CommandSender sender, String type, World world, int amount, int days) {
        this(sender, type, world, amount, days, String.valueOf(amount));
    }

    public SendPlayerTopWorld(CommandSender sender, String type, World world, int amount, int days, String displayAmount) {
        this.sender = sender;
        this.type = type;
        this.world = world;
        this.amount = amount;
        this.days = days;
        this.displayAmount = displayAmount;
    }

    @Override
    public void run() {
        String[] top = LeaderboardBuffer.topWorld(this.amount, this.type, this.world.getName(), this.days);
        this.sender.sendMessage(Language.MSG.STATISTIC_SEPARATOR.parse());
        this.sender.sendMessage(Language.MSG.STATISTIC_HEADLINE_TOPWORLD.parse(this.displayAmount, stringToEntry.get(this.type).parse(), this.world.getName()));
        this.sender.sendMessage(Language.MSG.STATISTIC_SEPARATOR.parse());
        int pos = 1;
        for (String stat : top) {
            this.sender.sendMessage(Language.MSG.STATISTIC_FORMAT_NUMBER.parse(String.valueOf(pos++), stat));
        }
    }

    static {
        stringToEntry.put("LINE", Language.MSG.STATISTIC_SEPARATOR);
        stringToEntry.put("KILLS", Language.MSG.STATISTIC_HEADLINE_KILLS);
        stringToEntry.put("DEATHS", Language.MSG.STATISTIC_HEADLINE_DEATHS);
        stringToEntry.put("RATIO", Language.MSG.STATISTIC_HEADLINE_RATIO);
        stringToEntry.put("K-D", Language.MSG.STATISTIC_HEADLINE_RATIO);
    }
}

