/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.runnables;

import java.util.HashMap;
import java.util.Map;
import net.slipcor.pvpstats.api.LeaderboardBuffer;
import net.slipcor.pvpstats.core.LanguageEntry;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.command.CommandSender;

public class SendPlayerTop
implements Runnable {
    final CommandSender sender;
    final String name;
    final int amount;
    final String displayAmount;
    final int offset;
    static Map<String, LanguageEntry> stringToEntry = new HashMap<String, LanguageEntry>();

    public SendPlayerTop(CommandSender sender, String name, int amount, int offset) {
        this(sender, name, amount, String.valueOf(amount), offset);
    }

    public SendPlayerTop(CommandSender sender, String name, int amount, String displayAmount, int offset) {
        this.sender = sender;
        this.name = name;
        this.amount = amount;
        this.displayAmount = displayAmount;
        this.offset = offset;
    }

    @Override
    public void run() {
        String[] top = LeaderboardBuffer.top(this.amount, this.name, this.offset);
        this.sender.sendMessage(Language.MSG.STATISTIC_SEPARATOR.parse());
        this.sender.sendMessage(Language.MSG.STATISTIC_HEADLINE_TOP.parse(this.displayAmount, stringToEntry.get(this.name).parse()));
        this.sender.sendMessage(Language.MSG.STATISTIC_SEPARATOR.parse());
        int pos = 1;
        for (String stat : top) {
            this.sender.sendMessage(Language.MSG.STATISTIC_FORMAT_NUMBER.parse(String.valueOf(pos++ + this.offset), stat));
        }
    }

    static {
        stringToEntry.put("LINE", Language.MSG.STATISTIC_SEPARATOR);
        stringToEntry.put("KILLS", Language.MSG.STATISTIC_HEADLINE_KILLS);
        stringToEntry.put("DEATHS", Language.MSG.STATISTIC_HEADLINE_DEATHS);
        stringToEntry.put("STREAK", Language.MSG.STATISTIC_HEADLINE_STREAK);
        stringToEntry.put("RATIO", Language.MSG.STATISTIC_HEADLINE_RATIO);
        stringToEntry.put("K-D", Language.MSG.STATISTIC_HEADLINE_RATIO);
        stringToEntry.put("ELO", Language.MSG.STATISTIC_HEADLINE_ELO);
    }
}

