/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.math;

import java.util.EnumMap;
import java.util.Map;
import net.slipcor.pvpstats.api.InformationType;
import net.slipcor.pvpstats.classes.PlayerStatistic;
import net.slipcor.pvpstats.math.Formula;

public class StatisticFormula
implements Formula {
    private static final Map<InformationType, Formula> formulas = new EnumMap<InformationType, Formula>(InformationType.class);
    private final InformationType type;

    private StatisticFormula(InformationType type) {
        this.type = type;
    }

    @Override
    public double evaluate(PlayerStatistic stats) {
        switch (this.type) {
            case DEATHS: {
                return stats.getDeaths();
            }
            case KILLS: {
                return stats.getKills();
            }
            case ELO: {
                return stats.getELO();
            }
            case CURRENTSTREAK: {
                return stats.getCurrentStreak();
            }
            case STREAK: {
                return stats.getMaxStreak();
            }
        }
        throw new IllegalArgumentException("not a valid number stat: " + (Object)((Object)this.type));
    }

    public String toString() {
        return this.type.name();
    }

    public static Formula from(InformationType key) {
        return formulas.get((Object)key);
    }

    static {
        formulas.put(InformationType.DEATHS, new StatisticFormula(InformationType.DEATHS));
        formulas.put(InformationType.KILLS, new StatisticFormula(InformationType.KILLS));
        formulas.put(InformationType.ELO, new StatisticFormula(InformationType.ELO));
        formulas.put(InformationType.CURRENTSTREAK, new StatisticFormula(InformationType.CURRENTSTREAK));
        formulas.put(InformationType.STREAK, new StatisticFormula(InformationType.STREAK));
    }
}

