/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.math;

import java.util.List;
import net.slipcor.pvpstats.math.Formula;
import net.slipcor.pvpstats.math.Lexer;
import net.slipcor.pvpstats.math.Parser;
import net.slipcor.pvpstats.math.StackException;
import net.slipcor.pvpstats.math.Token;
import net.slipcor.pvpstats.math.UnexpectedStackSizeException;

public class MathFormulaManager {
    private final Lexer lexer;
    private final Parser parser;
    private static MathFormulaManager instance;

    private MathFormulaManager(Lexer lexer, Parser parser) {
        this.lexer = lexer;
        this.parser = parser;
    }

    public static MathFormulaManager getInstance() {
        if (instance == null) {
            Lexer lexer = new Lexer();
            Parser parser = new Parser();
            instance = new MathFormulaManager(lexer, parser);
        }
        return instance;
    }

    public Formula parse(String input) {
        List<Token> tokens = this.lexer.tokenize(input);
        try {
            return this.parser.parse(tokens);
        }
        catch (UnexpectedStackSizeException exception) {
            throw new StackException(input, exception.getMessage());
        }
    }

    @Deprecated
    public void setDebug(boolean value) {
        this.parser.setDebug(value);
    }
}

