/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.math;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.slipcor.pvpstats.math.Environment;
import net.slipcor.pvpstats.math.InfixOperatorToken;
import net.slipcor.pvpstats.math.InvalidNumberException;
import net.slipcor.pvpstats.math.NumberToken;
import net.slipcor.pvpstats.math.ParenthesisToken;
import net.slipcor.pvpstats.math.StatisticToken;
import net.slipcor.pvpstats.math.Token;
import net.slipcor.pvpstats.math.UnexpectedOperatorException;
import net.slipcor.pvpstats.math.UnexpectedSymbolException;
import net.slipcor.pvpstats.math.UnknownInfixOperatorException;
import net.slipcor.pvpstats.math.UnknownPrefixOperatorException;
import net.slipcor.pvpstats.math.UnknownStatisticException;
import net.slipcor.pvpstats.math.UnmatchedLeftParenthesisException;
import net.slipcor.pvpstats.math.UnmatchedRightParenthesisException;

public class Lexer {
    private final Environment env = new Environment();

    List<Token> tokenize(String input) {
        this.validate(input);
        return this.tokenize(input, 0, new ArrayList<Token>());
    }

    private List<Token> tokenize(String input, int offset, List<Token> result) {
        if (offset >= input.length()) {
            return result;
        }
        char c = input.charAt(offset);
        if (Character.isWhitespace(c)) {
            return this.tokenize(input, offset + 1, result);
        }
        if (c == '(') {
            return this.eatLeftParenthesis(input, offset, result);
        }
        if (c == ')') {
            return this.eatRightParenthesis(input, offset, result);
        }
        if (c == '&') {
            return this.eatStatistic(input, offset, result);
        }
        if (Character.isDigit(c)) {
            return this.eatNumber(input, offset, result);
        }
        if (this.env.isValidOperatorSymbol(c)) {
            return this.eatOperator(input, offset, result);
        }
        throw new UnexpectedSymbolException(input, offset);
    }

    private void validate(String input) {
        int i;
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>(input.length());
        char last = '(';
        for (i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '(') {
                stack.push(i);
            } else if (c == ')') {
                if (stack.isEmpty()) {
                    throw new UnmatchedRightParenthesisException(input, i);
                }
                if (this.env.isValidOperatorSymbol(last)) {
                    throw new UnexpectedOperatorException(input, i - 1, false);
                }
                stack.pop();
            } else if (this.env.isValidOperatorSymbol(c) && last == '(' && c != '+' && c != '-') {
                throw new UnexpectedOperatorException(input, i, true);
            }
            last = c;
        }
        if (this.env.isValidOperatorSymbol(last)) {
            throw new UnexpectedOperatorException(input, input.length() - 1, false);
        }
        if (!stack.isEmpty()) {
            i = (Integer)stack.pop();
            throw new UnmatchedLeftParenthesisException(input, i);
        }
    }

    private List<Token> eatLeftParenthesis(String input, int pos, List<Token> result) {
        result.add(ParenthesisToken.left());
        return this.tokenize(input, pos + 1, result);
    }

    private List<Token> eatRightParenthesis(String input, int pos, List<Token> result) {
        result.add(ParenthesisToken.right());
        return this.tokenize(input, pos + 1, result);
    }

    private List<Token> eatNumber(String input, int pos, List<Token> result) {
        char c;
        int i;
        boolean eatingExponent = false;
        boolean eatingDecimals = false;
        boolean exponentSign = false;
        for (i = pos + 1; i < input.length() && (Character.isDigit(c = input.charAt(i)) || c == '.' || c == 'e' || c == '-'); ++i) {
            if (c == 'e') {
                if (eatingExponent) {
                    throw new UnexpectedSymbolException(input, pos + i);
                }
                eatingExponent = true;
                continue;
            }
            if (c == '-') {
                if (!eatingExponent || exponentSign) break;
                exponentSign = true;
                continue;
            }
            if (c != '.') continue;
            if (eatingExponent || eatingDecimals) {
                throw new UnexpectedSymbolException(input, pos + i);
            }
            eatingDecimals = true;
        }
        String part = input.substring(pos, i);
        try {
            double value = Double.parseDouble(part);
            NumberToken token = new NumberToken(value);
            result.add(token);
        }
        catch (NumberFormatException e) {
            throw new InvalidNumberException(input, pos, part);
        }
        return this.tokenize(input, i, result);
    }

    private List<Token> eatOperator(String input, int pos, List<Token> result) {
        char c;
        int i;
        for (i = pos + 1; i < input.length() && this.env.isValidOperatorSymbol(c = input.charAt(i)); ++i) {
        }
        boolean prefix = this.isPrefixOperatorExpected(result);
        for (int j = i; j > pos; --j) {
            Token token;
            String symbol = input.substring(pos, j);
            Token token2 = token = prefix ? this.env.getPrefixOperator(symbol) : this.env.getInfixOperator(symbol);
            if (token == null) continue;
            result.add(token);
            return this.tokenize(input, j, result);
        }
        throw prefix ? new UnknownPrefixOperatorException(input, pos, i) : new UnknownInfixOperatorException(input, pos, i);
    }

    private boolean isPrefixOperatorExpected(List<Token> result) {
        if (result.isEmpty()) {
            return true;
        }
        Token previous = result.get(result.size() - 1);
        if (previous instanceof InfixOperatorToken) {
            return true;
        }
        if (previous instanceof ParenthesisToken) {
            ParenthesisToken parenthesis = (ParenthesisToken)previous;
            return parenthesis.left;
        }
        return false;
    }

    private List<Token> eatStatistic(String input, int pos, List<Token> result) {
        StatisticToken token;
        try {
            char symbol = input.charAt(pos + 1);
            if (!Character.isAlphabetic(symbol)) {
                throw new UnexpectedSymbolException(input, pos + 1);
            }
            String prefix = input.substring(pos, pos + 2);
            token = this.env.getStatic(prefix);
        }
        catch (StringIndexOutOfBoundsException exception) {
            throw new UnexpectedSymbolException(input, pos);
        }
        if (token == null) {
            throw new UnknownStatisticException(input, pos);
        }
        result.add(token);
        return this.tokenize(input, pos + 2, result);
    }
}

