/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.math;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.slipcor.pvpstats.math.InfixOperatorToken;
import net.slipcor.pvpstats.math.NumberToken;
import net.slipcor.pvpstats.math.ParenthesisToken;
import net.slipcor.pvpstats.math.PrefixOperatorToken;
import net.slipcor.pvpstats.math.StatisticToken;
import net.slipcor.pvpstats.math.Token;
import net.slipcor.pvpstats.math.UnexpectedStackContentException;

public class InfixToPostfix {
    private final List<Token> output = new ArrayList<Token>();
    private final Deque<Token> stack = new ArrayDeque<Token>();
    static boolean debug = false;

    InfixToPostfix() {
    }

    List<Token> convert(List<Token> tokens) {
        this.output.clear();
        this.stack.clear();
        if (debug) {
            System.out.println("converting: " + tokens);
        }
        for (Token token : tokens) {
            if (debug) {
                System.out.println("token: " + token);
            }
            if (token instanceof NumberToken) {
                this.number((NumberToken)token);
                continue;
            }
            if (token instanceof StatisticToken) {
                this.statistic((StatisticToken)token);
                continue;
            }
            if (token instanceof PrefixOperatorToken) {
                this.prefix((PrefixOperatorToken)token);
                continue;
            }
            if (token instanceof InfixOperatorToken) {
                this.infix((InfixOperatorToken)token);
                continue;
            }
            if (token instanceof ParenthesisToken) {
                this.parenthesis((ParenthesisToken)token);
                continue;
            }
            throw new UnexpectedStackContentException(token);
        }
        while (!this.stack.isEmpty()) {
            Token top = this.stack.peek();
            if (debug) {
                System.out.println("top: " + top);
            }
            if (this.popIfOperator(top)) continue;
            throw new UnexpectedStackContentException(top);
        }
        return this.output;
    }

    private void number(NumberToken token) {
        this.output.add(token);
    }

    private void statistic(StatisticToken token) {
        this.output.add(token);
    }

    private void infix(InfixOperatorToken token) {
        while (!this.stack.isEmpty()) {
            Token top;
            Token peek = this.stack.peek();
            if (peek instanceof PrefixOperatorToken) {
                top = (PrefixOperatorToken)peek;
                if (top.precedence <= token.precedence) break;
                this.output.add(this.stack.pop());
                continue;
            }
            if (peek instanceof InfixOperatorToken) {
                top = (InfixOperatorToken)peek;
                if (((InfixOperatorToken)top).precedence > token.precedence) {
                    this.output.add(this.stack.pop());
                    continue;
                }
                if (((InfixOperatorToken)top).precedence != token.precedence || !token.left) break;
                this.output.add(this.stack.pop());
                continue;
            }
            if (!(peek instanceof ParenthesisToken)) continue;
            break;
        }
        this.stack.push(token);
    }

    private void prefix(PrefixOperatorToken token) {
        this.stack.push(token);
    }

    private void parenthesis(ParenthesisToken token) {
        if (token.left) {
            this.stack.push(token);
        } else {
            while (!this.stack.isEmpty()) {
                Token peek = this.stack.peek();
                if (this.popIfOperator(peek)) continue;
                if (peek instanceof ParenthesisToken) {
                    ParenthesisToken parenthesis = (ParenthesisToken)peek;
                    if (!parenthesis.left) {
                        throw new IllegalArgumentException("Mismatched Parenthesis: " + token);
                    }
                    this.stack.pop();
                    break;
                }
                throw new UnexpectedStackContentException(token);
            }
        }
    }

    private boolean popIfOperator(Token token) {
        if (token instanceof InfixOperatorToken || token instanceof PrefixOperatorToken) {
            this.stack.pop();
            this.output.add(token);
            return true;
        }
        return false;
    }
}

