/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.math;

import net.slipcor.pvpstats.classes.PlayerStatistic;
import net.slipcor.pvpstats.math.Formula;

public class InfixFormula
implements Formula {
    final String symbol;
    final Formula left;
    final Formula right;

    public InfixFormula(String symbol, Formula left, Formula right) {
        this.symbol = symbol;
        this.left = left;
        this.right = right;
    }

    @Override
    public double evaluate(PlayerStatistic stats) {
        double leftValue = this.left.evaluate(stats);
        double rightValue = this.right.evaluate(stats);
        if (this.symbol.equals("*")) {
            return leftValue * rightValue;
        }
        if (this.symbol.equals("/")) {
            if (rightValue == 0.0) {
                return leftValue;
            }
            return leftValue / rightValue;
        }
        if (this.symbol.equals("+")) {
            return leftValue + rightValue;
        }
        if (this.symbol.equals("-")) {
            return leftValue - rightValue;
        }
        if (this.symbol.equals("^")) {
            return Math.pow(leftValue, rightValue);
        }
        throw new IllegalArgumentException("InfixFormula not implemented yet: " + this.symbol);
    }
}

