/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.DatabaseAPI;
import net.slipcor.pvpstats.api.PlayerStatisticsBuffer;
import net.slipcor.pvpstats.classes.PlayerDamageHistory;
import net.slipcor.pvpstats.core.CoreDebugger;
import net.slipcor.pvpstats.display.SignDisplay;
import net.slipcor.pvpstats.text.TextFormatter;
import net.slipcor.pvpstats.yml.Config;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final PVPStats plugin;
    public static CoreDebugger Debugger;
    private int assistSeconds = 60;
    private final Map<UUID, PlayerDamageHistory> lastDamage = new HashMap<UUID, PlayerDamageHistory>();

    public PlayerListener(PVPStats instance) {
        this.plugin = instance;
        this.assistSeconds = this.plugin.config().getInt(Config.Entry.STATISTICS_ASSIST_SECONDS);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        PlayerDamageHistory history;
        AnimalTamer tamer;
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player attacked = (Player)event.getEntity();
        Player attacker = null;
        if (event.getDamager() instanceof Player && !event.getDamager().equals(attacked)) {
            attacker = (Player)event.getDamager();
        } else if (event.getDamager() instanceof Projectile) {
            Projectile projectile = (Projectile)event.getDamager();
            if (projectile.getShooter() instanceof Player && !projectile.getShooter().equals(attacked)) {
                attacker = (Player)projectile.getShooter();
            }
        } else if (event.getDamager() instanceof Tameable && this.plugin.config().getBoolean(Config.Entry.STATISTICS_COUNT_PET_DEATHS) && (tamer = ((Tameable)event.getDamager()).getOwner()) instanceof Player) {
            attacker = (Player)tamer;
        }
        if (attacker == null) {
            return;
        }
        if (this.lastDamage.containsKey(attacked.getUniqueId())) {
            history = this.lastDamage.get(attacked.getUniqueId());
            history.commitPlayerDamage(attacker);
        } else {
            history = new PlayerDamageHistory();
            history.commitPlayerDamage(attacker);
            this.lastDamage.put(attacked.getUniqueId(), history);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (event.getPlayer().isOp() && this.plugin.getUpdater() != null) {
            this.plugin.getUpdater().message((CommandSender)event.getPlayer());
        }
        DatabaseAPI.initiatePlayer((OfflinePlayer)event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.config().getBoolean(Config.Entry.STATISTICS_RESET_KILLSTREAK_ON_QUIT)) {
            PlayerStatisticsBuffer.setStreak(event.getPlayer().getUniqueId(), 0);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (this.plugin.ignoresWorld(event.getEntity().getWorld().getName())) {
            TextFormatter.explainIgnoredWorld(event.getEntity());
            return;
        }
        Player player = event.getEntity();
        Debugger.i("Player killed!", (CommandSender)player);
        if (this.notCountingEntity(player)) {
            Debugger.i("not counting this one!");
            return;
        }
        Player attacker = event.getEntity().getKiller();
        if (attacker == null || attacker.equals(event.getEntity())) {
            Debugger.i("Killer is null or self", (CommandSender)player);
            if (this.lastDamage.containsKey(player.getUniqueId())) {
                PlayerDamageHistory history = this.lastDamage.get(player.getUniqueId());
                List<UUID> damagers = history.getLastDamage(this.assistSeconds);
                if (damagers.size() > 0) {
                    attacker = Bukkit.getPlayer((UUID)damagers.get(0));
                }
                this.lastDamage.remove(player.getUniqueId());
            }
            if (attacker == null) {
                Debugger.i("Killer is still null", (CommandSender)player);
                if (this.plugin.config().getBoolean(Config.Entry.STATISTICS_COUNT_REGULAR_DEATHS)) {
                    Debugger.i("Kill should be counted", (CommandSender)event.getEntity());
                    DatabaseAPI.AkilledB(null, (OfflinePlayer)event.getEntity());
                }
                return;
            }
            if (attacker.equals(event.getEntity())) {
                Debugger.i("Killer is the player themselves!", (CommandSender)player);
                return;
            }
        }
        this.lastDamage.remove(player.getUniqueId());
        if (this.notCountingEntity(attacker)) {
            Debugger.i("not counting this one!");
            return;
        }
        DatabaseAPI.AkilledB((OfflinePlayer)attacker, (OfflinePlayer)player);
    }

    private boolean notCountingEntity(Player player) {
        if (player == null) {
            return false;
        }
        List<String> tags = this.plugin.config().getStringList(Config.Entry.STATISTICS_PREVENTING_PLAYER_META, new ArrayList<String>());
        for (String tag : tags) {
            if (!player.hasMetadata(tag)) continue;
            Debugger.i("Tag found: " + tag);
            return true;
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true)
    public void playerInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block != null) {
            if (block.getState() instanceof Sign) {
                SignDisplay display = SignDisplay.byLocation(block.getLocation());
                if (display == null) {
                    display = SignDisplay.init(block.getLocation());
                    if (display != null) {
                        if (!display.isValid()) {
                            PVPStats.getInstance().sendPrefixed((CommandSender)event.getPlayer(), Language.MSG.DISPLAY_SETUP_INVALID.parse());
                        } else {
                            PVPStats.getInstance().sendPrefixed((CommandSender)event.getPlayer(), Language.MSG.DISPLAY_SUCCESSFUL.parse(event.getClickedBlock().getLocation().toString()));
                            SignDisplay.saveAllDisplays();
                        }
                    }
                    return;
                }
                event.setCancelled(!event.getPlayer().isOp());
                if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                    return;
                }
                display.cycleSortColumn();
                PVPStats.getInstance().sendPrefixed((CommandSender)event.getPlayer(), Language.MSG.DISPLAY_SORTED_BY.parse(display.getSortColumn().name()));
            } else if (SignDisplay.needsProtection(event.getPlayer().getLocation())) {
                event.setCancelled(!event.getPlayer().isOp());
            }
        }
    }
}

