/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.slipcor.pvpstats.core.CoreConfig;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class CorePlugin
extends JavaPlugin {
    boolean debugEverything;
    private Logger debugLogger;
    final Set<Integer> debugFilterIDs = new HashSet<Integer>();
    final Set<String> debugFilterNames = new HashSet<String>();

    public void destroyDebugger() {
        if (this.debugLogger != null) {
            Handler[] handlers;
            for (Handler handler : handlers = (Handler[])this.debugLogger.getHandlers().clone()) {
                this.debugLogger.removeHandler(handler);
                handler.close();
            }
            this.debugLogger = null;
        }
    }

    Logger getDebugger() {
        if (this.debugLogger == null) {
            this.debugLogger = Logger.getAnonymousLogger();
            this.debugLogger.setLevel(Level.ALL);
            this.debugLogger.setUseParentHandlers(false);
            for (Handler handler : this.debugLogger.getHandlers()) {
                this.debugLogger.removeHandler(handler);
                handler.close();
            }
            try {
                Handler handler;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
                File debugFolder = new File(this.getDataFolder(), "debug");
                debugFolder.mkdirs();
                File logFile = new File(debugFolder, dateFormat.format(new Date()) + "general.log");
                logFile.createNewFile();
                handler = new FileHandler(logFile.getAbsolutePath());
                handler.setFormatter(LogFileFormatter.newInstance());
                this.debugLogger.addHandler(handler);
            }
            catch (IOException | SecurityException ex) {
                this.getLogger().log(Level.SEVERE, null, ex);
            }
        }
        return this.debugLogger;
    }

    public void loadDebugger(String node, CommandSender sender) {
        this.debugFilterIDs.clear();
        this.debugFilterNames.clear();
        this.debugEverything = false;
        String debugs = this.getConfig().getString(node, "off");
        if ("off".equalsIgnoreCase(debugs) || "none".equalsIgnoreCase(debugs) || "false".equalsIgnoreCase(debugs)) {
            this.sendPrefixed(sender, "debugging: off");
        } else if ("on".equalsIgnoreCase(debugs) || "all".equalsIgnoreCase(debugs) || "true".equalsIgnoreCase(debugs)) {
            this.debugEverything = true;
            this.sendPrefixed(sender, "debugging on!");
        } else {
            String[] sIds = debugs.split(",");
            this.sendPrefixed(sender, "debugging: " + debugs);
            for (String s : sIds) {
                try {
                    this.debugFilterIDs.add(Integer.valueOf(s));
                }
                catch (Exception e) {
                    this.debugFilterNames.add(s);
                }
            }
        }
    }

    public void sendPrefixed(CommandSender sender, String message) {
        if ("".equals(message)) {
            return;
        }
        if (sender instanceof Player) {
            sender.sendMessage(this.getMessagePrefix() + message);
            return;
        }
        this.getLogger().info(message);
    }

    public abstract CoreConfig config();

    protected abstract String getMessagePrefix();

    protected abstract String getDebugPrefix();

    private static class LogFileFormatter
    extends Formatter {
        private final SimpleDateFormat date = new SimpleDateFormat("yy.MM.dd HH:mm:ss");

        public static LogFileFormatter newInstance() {
            return new LogFileFormatter();
        }

        private LogFileFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder builder = new StringBuilder();
            Throwable exception = record.getThrown();
            builder.append(this.date.format(record.getMillis()));
            builder.append(" [");
            builder.append(record.getLevel().getLocalizedName().toUpperCase());
            builder.append("] ");
            builder.append(record.getMessage());
            builder.append('\n');
            if (exception != null) {
                StringWriter writer = new StringWriter();
                exception.printStackTrace(new PrintWriter(writer));
                builder.append(writer);
            }
            return builder.toString();
        }
    }
}

