/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.core;

import net.slipcor.pvpstats.core.CorePlugin;
import org.bukkit.command.CommandSender;

public class CoreDebugger {
    private final int debugID;
    private final CorePlugin plugin;
    private final String prefix;

    public CoreDebugger(CorePlugin plugin, int debugID) {
        this.debugID = debugID;
        this.plugin = plugin;
        this.prefix = plugin.getDebugPrefix();
    }

    private boolean debugs() {
        return this.plugin.debugEverything || this.plugin.debugFilterIDs.contains(this.debugID);
    }

    private boolean debugs(String player) {
        return this.plugin.debugEverything || this.plugin.debugFilterNames.contains(player);
    }

    public void i(String string) {
        if (!this.debugs()) {
            return;
        }
        this.plugin.getDebugger().info(this.prefix + System.currentTimeMillis() % 1000L + ' ' + string);
    }

    public void i(String string, CommandSender sender) {
        if (sender == null) {
            this.i(string, "null");
            return;
        }
        if (!this.debugs(sender.getName())) {
            return;
        }
        this.plugin.getDebugger().info(this.prefix + "[p:" + sender.getName() + ']' + System.currentTimeMillis() % 1000L + ' ' + string);
    }

    public void i(String string, String player) {
        if (!this.debugs(player)) {
            return;
        }
        this.plugin.getDebugger().info(this.prefix + System.currentTimeMillis() % 1000L + ' ' + string);
    }
}

