/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.core.CoreCommand;
import net.slipcor.pvpstats.core.CorePlugin;
import net.slipcor.pvpstats.runnables.SendPlayerTopWorld;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandTopWorld
extends CoreCommand {
    public CommandTopWorld(CorePlugin plugin) {
        super(plugin, "pvpstats.topworld", Language.MSG.COMMAND_ARGUMENT_COUNT_INVALID);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.NO_PERMISSION_TOPPLUS.parse());
            return;
        }
        if (args.length > 3) {
            int days;
            try {
                days = Integer.parseInt(args[3]);
            }
            catch (Exception e) {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_ARGUMENT_INVALID_NUMBER.parse(args[2]));
                return;
            }
            World world = sender instanceof Player ? ((Player)sender).getWorld() : null;
            for (World w : Bukkit.getServer().getWorlds()) {
                if (!w.getName().equalsIgnoreCase(args[2])) continue;
                world = w;
                break;
            }
            if (world == null) {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_TOPWORLD_INVALID_WORLD.parse(args[2]));
                return;
            }
            int amount = 10;
            if (args.length > 4) {
                try {
                    amount = Integer.parseInt(args[4]);
                }
                catch (Exception e2) {
                    PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_ARGUMENT_INVALID_NUMBER.parse(args[4]));
                    amount = 10;
                }
            }
            if (args[1].equalsIgnoreCase("kills")) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new SendPlayerTopWorld(sender, "KILLS", world, amount, days));
            } else if (args[1].equalsIgnoreCase("deaths")) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new SendPlayerTopWorld(sender, "DEATHS", world, amount, days));
            } else if (args[1].equalsIgnoreCase("ratio")) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new SendPlayerTopWorld(sender, "K-D", world, amount, days));
            } else {
                return;
            }
        }
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            results.add("kills");
            results.add("deaths");
            results.add("ratio");
            return results;
        }
        if (args.length > 2) {
            if (args.length > 3) {
                return results;
            }
            for (World world : Bukkit.getServer().getWorlds()) {
                this.addIfMatches(results, world.getName(), args[2].toLowerCase());
            }
            return results;
        }
        this.addIfMatches(results, "kills", args[1]);
        this.addIfMatches(results, "deaths", args[1]);
        this.addIfMatches(results, "ratio", args[1]);
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("topworld");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!tw");
    }

    @Override
    public String getShortInfo() {
        return "/pvpstats topworld [type] [world] [days] - show the top 10 players of given type, in the last [days] days\n/pvpstats topworld [type] [world] [days] [amount] - show the top [amount] players of the given type, in the last [days] days";
    }
}

