/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.core.CoreCommand;
import net.slipcor.pvpstats.core.CorePlugin;
import net.slipcor.pvpstats.runnables.SendPlayerTop;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class CommandTop
extends CoreCommand {
    public CommandTop(CorePlugin plugin) {
        super(plugin, "pvpstats.top", Language.MSG.COMMAND_ARGUMENT_COUNT_INVALID);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.NO_PERMISSION_TOP.parse());
            return;
        }
        int legacyTop = 0;
        try {
            legacyTop = Integer.parseInt(args[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (args[0].equals("top") || legacyTop > 0) {
            if (args.length > 1) {
                int amount = -1;
                try {
                    amount = Integer.parseInt(args[1]);
                }
                catch (Exception e) {
                    if (args.length > 2) {
                        try {
                            amount = Integer.parseInt(args[2]);
                        }
                        catch (Exception e2) {
                            amount = 10;
                        }
                    }
                    if (amount == -1) {
                        amount = 10;
                    }
                    int offset = 0;
                    if (args.length > 3) {
                        try {
                            offset = 10 * (Integer.parseInt(args[3]) - 1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    offset = Math.max(0, offset);
                    if (args[1].equalsIgnoreCase("kills")) {
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new SendPlayerTop(sender, "KILLS", amount, offset));
                    } else if (args[1].equalsIgnoreCase("deaths")) {
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new SendPlayerTop(sender, "DEATHS", amount, offset));
                    } else if (args[1].equalsIgnoreCase("streak")) {
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new SendPlayerTop(sender, "STREAK", amount, offset));
                    } else if (args[1].equalsIgnoreCase("elo")) {
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new SendPlayerTop(sender, "ELO", amount, offset));
                    } else if (args[1].equalsIgnoreCase("ratio")) {
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new SendPlayerTop(sender, "K-D", amount, offset));
                    } else {
                        return;
                    }
                    return;
                }
                args[0] = args[1];
                legacyTop = 1;
            }
            try {
                int count;
                int n = count = legacyTop == 0 ? 10 : Integer.parseInt(args[0]);
                if (legacyTop == 0) {
                    args[0] = String.valueOf(count);
                }
                int offset = 0;
                if (args.length > 2) {
                    offset = 10 * (Integer.parseInt(args[2]) - 1);
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new SendPlayerTop(sender, "K-D", count, args[0], offset));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            results.add("kills");
            results.add("deaths");
            results.add("streak");
            results.add("elo");
            results.add("ratio");
            return results;
        }
        if (args.length > 2) {
            return results;
        }
        this.addIfMatches(results, "kills", args[1].toLowerCase());
        this.addIfMatches(results, "deaths", args[1].toLowerCase());
        this.addIfMatches(results, "streak", args[1].toLowerCase());
        this.addIfMatches(results, "elo", args[1].toLowerCase());
        this.addIfMatches(results, "ratio", args[1].toLowerCase());
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("top");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!t");
    }

    @Override
    public String getShortInfo() {
        return "/pvpstats top [amount] - show the top [amount] players (K-D)\n/pvpstats top [type] - show the top 10 players of the type\n/pvpstats top [type] [amount] - show the top [amount] players of the type";
    }
}

