/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.DatabaseAPI;
import net.slipcor.pvpstats.api.PlayerStatisticsBuffer;
import net.slipcor.pvpstats.classes.PlayerHandler;
import net.slipcor.pvpstats.core.CoreCommand;
import net.slipcor.pvpstats.core.CorePlugin;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandSet
extends CoreCommand {
    public CommandSet(CorePlugin plugin) {
        super(plugin, "pvpstats.set", Language.MSG.COMMAND_ARGUMENT_COUNT_INVALID);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.NO_PERMISSION_SET.parse());
            return;
        }
        if (!this.argCountValid(sender, args, new Integer[]{4})) {
            return;
        }
        try {
            int amount = Integer.parseInt(args[3]);
            OfflinePlayer player = PlayerHandler.findPlayer(args[1]);
            if (player != null && DatabaseAPI.hasEntry(player.getUniqueId())) {
                if (args[2].toLowerCase().equals("kills")) {
                    PlayerStatisticsBuffer.setKills(player.getUniqueId(), amount);
                    DatabaseAPI.setSpecificStat(player, "kills", amount);
                } else if (args[2].toLowerCase().equals("deaths")) {
                    PlayerStatisticsBuffer.setDeaths(player.getUniqueId(), amount);
                    DatabaseAPI.setSpecificStat(player, "deaths", amount);
                } else if (args[2].toLowerCase().equals("streak")) {
                    PlayerStatisticsBuffer.setStreak(player.getUniqueId(), amount);
                    DatabaseAPI.setSpecificStat(player, "streak", amount);
                } else if (args[2].toLowerCase().equals("currentstreak")) {
                    PlayerStatisticsBuffer.setMaxStreak(player.getUniqueId(), amount);
                    DatabaseAPI.setSpecificStat(player, "currentstreak", amount);
                } else if (args[2].toLowerCase().equalsIgnoreCase("elo")) {
                    PlayerStatisticsBuffer.setEloScore(player.getUniqueId(), amount);
                    DatabaseAPI.setSpecificStat(player, "elo", amount);
                } else {
                    PVPStats.getInstance().sendPrefixed(sender, this.getShortInfo());
                    return;
                }
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_SET_SUCCESS.parse(args[2], args[1], String.valueOf(amount)));
                DatabaseAPI.refresh();
            } else {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_PLAYER_NOT_FOUND.parse(args[1]));
            }
        }
        catch (Exception e) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_ARGUMENT_INVALID_NUMBER.parse(args[3]));
        }
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                results.add(p.getName());
            }
            return results;
        }
        if (args.length > 3) {
            return results;
        }
        if (args.length < 3) {
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                this.addIfMatches(results, p.getName(), args[1].toLowerCase());
            }
        } else {
            this.addIfMatches(results, "kills", args[2].toLowerCase());
            this.addIfMatches(results, "deaths", args[2].toLowerCase());
            this.addIfMatches(results, "streak", args[2].toLowerCase());
            this.addIfMatches(results, "currentstreak", args[2].toLowerCase());
            this.addIfMatches(results, "elo", args[2].toLowerCase());
        }
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("set");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!st");
    }

    @Override
    public String getShortInfo() {
        return "/pvpstats set [player] [type] [amount] - set a player's [type] statistic - valid types:\nkills, deaths, streak, currentstrak, elo";
    }
}

