/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.DatabaseAPI;
import net.slipcor.pvpstats.classes.PlayerHandler;
import net.slipcor.pvpstats.core.CoreCommand;
import net.slipcor.pvpstats.core.CoreDebugger;
import net.slipcor.pvpstats.core.CorePlugin;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandDebugKill
extends CoreCommand {
    public static CoreDebugger debugger;

    public CommandDebugKill(CorePlugin plugin) {
        super(plugin, "pvpstats.debugkill", Language.MSG.COMMAND_ARGUMENT_COUNT_INVALID);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        debugger.i("debug kill!");
        if (!this.hasPerms(sender)) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.NO_PERMISSION_DEBUG.parse());
            return;
        }
        if (!this.argCountValid(sender, args, new Integer[]{3, 5})) {
            return;
        }
        debugger.i("let's go!");
        String attacker = args[1];
        String victim = args[2];
        OfflinePlayer offlineAttacker = Bukkit.getServer().getOfflinePlayer(attacker);
        OfflinePlayer offlineVictim = Bukkit.getServer().getOfflinePlayer(victim);
        DatabaseAPI.AkilledB(offlineAttacker, offlineVictim);
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                results.add(PlayerHandler.getRawPlayerName((OfflinePlayer)p));
            }
            return results;
        }
        if (args.length > 3) {
            return results;
        }
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            this.addIfMatches(results, p.getName(), args[1]);
        }
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("debugkill");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!dk");
    }

    @Override
    public String getShortInfo() {
        return "/pvpstats debugkill killer killed - add a manual kill";
    }
}

