/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.api;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.DatabaseAPI;
import net.slipcor.pvpstats.classes.PlayerStatistic;
import net.slipcor.pvpstats.yml.Config;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public final class PlayerStatisticsBuffer {
    private static final Map<UUID, Integer> kills = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> deaths = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> streaks = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> maxStreaks = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> eloScore = new HashMap<UUID, Integer>();

    private PlayerStatisticsBuffer() {
    }

    public static void addDeath(UUID uuid) {
        int value = deaths.containsKey(uuid) ? deaths.get(uuid) : 0;
        deaths.put(uuid, ++value);
    }

    public static void addKill(UUID uuid) {
        int value = kills.containsKey(uuid) ? kills.get(uuid) : 0;
        kills.put(uuid, ++value);
    }

    public static boolean addStreak(final UUID uuid) {
        final int streak = streaks.get(uuid) + 1;
        Bukkit.getScheduler().runTaskLater((Plugin)PVPStats.getInstance(), new Runnable(){

            @Override
            public void run() {
                PVPStats.getInstance().handleStreak(uuid, streak);
            }
        }, 1L);
        streaks.put(uuid, streak);
        if (PlayerStatisticsBuffer.hasMaxStreak(uuid)) {
            if (maxStreaks.get(uuid) < streak) {
                maxStreaks.put(uuid, Math.max(maxStreaks.get(uuid), streak));
                return true;
            }
        } else {
            int max = PlayerStatisticsBuffer.getMaxStreak(uuid);
            if (max > streak) {
                return false;
            }
            maxStreaks.put(uuid, streak);
            return true;
        }
        return false;
    }

    public static void clear(UUID uuid) {
        if (uuid == null) {
            deaths.clear();
            kills.clear();
            maxStreaks.clear();
            streaks.clear();
            eloScore.clear();
        } else {
            PlayerStatisticsBuffer.clearDeaths(uuid);
            PlayerStatisticsBuffer.clearKills(uuid);
            PlayerStatisticsBuffer.clearMaxStreak(uuid);
            PlayerStatisticsBuffer.clearStreak(uuid);
            PlayerStatisticsBuffer.clearEloScore(uuid);
        }
    }

    public static void clearDeaths(UUID uuid) {
        deaths.remove(uuid);
    }

    public static void clearKills(UUID uuid) {
        kills.remove(uuid);
    }

    public static void clearMaxStreak(UUID uuid) {
        maxStreaks.remove(uuid);
    }

    public static void clearStreak(UUID uuid) {
        streaks.remove(uuid);
    }

    public static void clearEloScore(UUID uuid) {
        eloScore.remove(uuid);
    }

    public static Integer getDeaths(UUID uuid) {
        if (deaths.containsKey(uuid)) {
            return deaths.get(uuid);
        }
        int value = DatabaseAPI.getEntry(uuid, "deaths");
        deaths.put(uuid, value);
        return value;
    }

    public static Integer getKills(UUID uuid) {
        if (kills.containsKey(uuid)) {
            return kills.get(uuid);
        }
        int value = DatabaseAPI.getEntry(uuid, "kills");
        kills.put(uuid, value);
        return value;
    }

    public static Integer getMaxStreak(UUID uuid) {
        if (PlayerStatisticsBuffer.hasMaxStreak(uuid)) {
            return maxStreaks.get(uuid);
        }
        int value = DatabaseAPI.getEntry(uuid, "streak");
        maxStreaks.put(uuid, value);
        return value;
    }

    public static Integer getStreak(UUID uuid) {
        if (PlayerStatisticsBuffer.hasStreak(uuid)) {
            return streaks.get(uuid);
        }
        int value = DatabaseAPI.getEntry(uuid, "currentstreak");
        streaks.put(uuid, value);
        return value;
    }

    public static Integer getEloScore(UUID uuid) {
        if (PlayerStatisticsBuffer.hasEloScore(uuid)) {
            return eloScore.get(uuid);
        }
        int value = DatabaseAPI.getEntry(uuid, "elo");
        if (value > 0) {
            eloScore.put(uuid, value);
            return value;
        }
        Integer idefault = PVPStats.getInstance().config().getInt(Config.Entry.ELO_DEFAULT);
        eloScore.put(uuid, idefault);
        return idefault;
    }

    public static Double getRatio(UUID uuid) {
        return DatabaseAPI.calculateRatio(new PlayerStatistic(null, PlayerStatisticsBuffer.getKills(uuid), PlayerStatisticsBuffer.getDeaths(uuid), PlayerStatisticsBuffer.getMaxStreak(uuid), PlayerStatisticsBuffer.getStreak(uuid), 0, 0L, uuid));
    }

    public static boolean hasMaxStreak(UUID uuid) {
        return maxStreaks.containsKey(uuid);
    }

    public static boolean hasStreak(UUID uuid) {
        return streaks.containsKey(uuid);
    }

    public static boolean hasEloScore(UUID uuid) {
        return eloScore.containsKey(uuid);
    }

    public static void loadPlayer(OfflinePlayer player) {
        UUID uuid = player.getUniqueId();
        if (deaths.containsKey(uuid) && kills.containsKey(uuid)) {
            return;
        }
        PlayerStatistic statistic = DatabaseAPI.getAllStats(player);
        deaths.put(uuid, statistic.getDeaths());
        kills.put(uuid, statistic.getKills());
        eloScore.put(uuid, statistic.getELO());
        streaks.put(uuid, statistic.getCurrentStreak());
        maxStreaks.put(uuid, statistic.getMaxStreak());
    }

    public static void setDeaths(UUID uuid, int value) {
        deaths.put(uuid, value);
    }

    public static void setKills(UUID uuid, int value) {
        kills.put(uuid, value);
    }

    public static void setMaxStreak(UUID uuid, int value) {
        maxStreaks.put(uuid, value);
    }

    public static void setStreak(UUID uuid, int value) {
        streaks.put(uuid, value);
    }

    public static void setEloScore(UUID uuid, int value) {
        eloScore.put(uuid, value);
    }

    static void refresh() {
        PlayerStatisticsBuffer.clear(null);
    }
}

