/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.api;

import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.DatabaseConnection;
import net.slipcor.pvpstats.api.InformationType;
import net.slipcor.pvpstats.api.PVPStatsPVPEvent;
import net.slipcor.pvpstats.api.PlayerStatisticsBuffer;
import net.slipcor.pvpstats.classes.PlayerHandler;
import net.slipcor.pvpstats.classes.PlayerStatistic;
import net.slipcor.pvpstats.core.CoreDebugger;
import net.slipcor.pvpstats.display.SignDisplay;
import net.slipcor.pvpstats.impl.FlatFileConnection;
import net.slipcor.pvpstats.impl.MySQLConnection;
import net.slipcor.pvpstats.impl.SQLiteConnection;
import net.slipcor.pvpstats.math.Formula;
import net.slipcor.pvpstats.math.MathFormulaManager;
import net.slipcor.pvpstats.runnables.CheckAndDo;
import net.slipcor.pvpstats.runnables.DatabaseFirstEntry;
import net.slipcor.pvpstats.runnables.DatabaseKillAddition;
import net.slipcor.pvpstats.runnables.DatabaseSetSpecific;
import net.slipcor.pvpstats.text.TextComponent;
import net.slipcor.pvpstats.text.TextFormatter;
import net.slipcor.pvpstats.yml.Config;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class DatabaseAPI {
    private static PVPStats plugin = null;
    public static CoreDebugger DEBUGGER;
    private static final Map<String, String> lastKill;
    private static final Map<String, String> lastKillAlt;
    private static final Map<String, String> lastKillComplex;
    private static final Map<String, String> lastKillAltComplex;
    private static final Map<String, BukkitTask> killTask;
    private static final TextComponent DATABASE_CONNECTED;
    private static Formula formula;
    private static List<UUID> allUUIDs;
    private static List<String> allPlayerNames;

    private DatabaseAPI() {
    }

    public static void AkilledB(final OfflinePlayer attacker, final OfflinePlayer victim) {
        int streak;
        BukkitTask task;
        String finalAttacker;
        BukkitTask task2;
        String finalAttacker2;
        String finalComplexAttacker;
        int abusesec;
        PVPStatsPVPEvent event = new PVPStatsPVPEvent(attacker, victim);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            DEBUGGER.i("Another plugin prevented PVP!");
            return;
        }
        if (attacker == null && victim == null) {
            DEBUGGER.i("attacker and victim are null");
            return;
        }
        if (attacker != null && victim != null && plugin.config().getBoolean(Config.Entry.STATISTICS_CHECK_ABUSE)) {
            if (plugin.config().getBoolean(Config.Entry.STATISTICS_ABUSE_COMPLEX)) {
                DEBUGGER.i("- checking abuse complex");
                if (lastKillComplex.containsKey(attacker.getName() + ';' + attacker.getName())) {
                    TextFormatter.explainAbusePrevention(attacker, victim, false);
                    DEBUGGER.i("> OUT: " + victim.getName());
                    return;
                }
                lastKillComplex.put(attacker.getName() + ';' + attacker.getName(), victim.getName());
                lastKill.put(attacker.getName(), victim.getName());
                abusesec = plugin.config().getInt(Config.Entry.STATISTICS_ABUSE_SECONDS);
                if (abusesec > 0) {
                    finalComplexAttacker = attacker.getName() + ';' + attacker.getName();
                    finalAttacker2 = attacker.getName();
                    class RemoveLater
                    implements Runnable {
                        RemoveLater() {
                        }

                        @Override
                        public void run() {
                            lastKillComplex.remove(finalComplexAttacker);
                            lastKill.remove(finalAttacker2);
                            killTask.remove(finalComplexAttacker);
                        }
                    }
                    task2 = Bukkit.getScheduler().runTaskLater((Plugin)plugin, (Runnable)new RemoveLater(), (long)abusesec * 20L);
                    if (killTask.containsKey(finalComplexAttacker)) {
                        killTask.get(finalComplexAttacker).cancel();
                    }
                    killTask.put(finalComplexAttacker, task2);
                }
            } else {
                DEBUGGER.i("- checking abuse simple");
                if (lastKill.containsKey(attacker.getName()) && lastKill.get(attacker.getName()).equals(victim.getName())) {
                    TextFormatter.explainAbusePrevention(attacker, victim, false);
                    DEBUGGER.i("> OUT: " + victim.getName());
                    return;
                }
                lastKill.put(attacker.getName(), victim.getName());
                abusesec = plugin.config().getInt(Config.Entry.STATISTICS_ABUSE_SECONDS);
                if (abusesec > 0) {
                    finalAttacker = attacker.getName();
                    class RemoveLater
                    implements Runnable {
                        final /* synthetic */ String val$finalAttacker;

                        RemoveLater(String string) {
                            this.val$finalAttacker = string;
                        }

                        @Override
                        public void run() {
                            lastKill.remove(this.val$finalAttacker);
                            killTask.remove(this.val$finalAttacker);
                        }
                    }
                    task = Bukkit.getScheduler().runTaskLater((Plugin)plugin, (Runnable)new RemoveLater(finalAttacker), (long)abusesec * 20L);
                    if (killTask.containsKey(finalAttacker)) {
                        killTask.get(finalAttacker).cancel();
                    }
                    killTask.put(finalAttacker, task);
                }
            }
        }
        if (attacker != null && victim != null && plugin.config().getBoolean(Config.Entry.STATISTICS_CHECK_ALT_ABUSE)) {
            if (plugin.config().getBoolean(Config.Entry.STATISTICS_ABUSE_COMPLEX)) {
                DEBUGGER.i("- checking alt abuse complex");
                if (lastKillAltComplex.containsKey(attacker.getPlayer().getAddress().toString() + ';' + attacker.getPlayer().getAddress().toString())) {
                    TextFormatter.explainAbusePrevention(attacker, victim, true);
                    DEBUGGER.i("> OUT: " + victim.getName());
                    return;
                }
                lastKillAltComplex.put(attacker.getPlayer().getAddress().toString() + ';' + attacker.getPlayer().getAddress().toString(), victim.getName());
                lastKillAlt.put(attacker.getPlayer().getAddress().toString(), victim.getPlayer().getAddress().toString());
                abusesec = plugin.config().getInt(Config.Entry.STATISTICS_ABUSE_SECONDS);
                if (abusesec > 0) {
                    finalComplexAttacker = attacker.getPlayer().getAddress().toString() + ';' + attacker.getPlayer().getAddress().toString();
                    finalAttacker2 = attacker.getPlayer().getAddress().toString();
                    class RemoveLater
                    implements Runnable {
                        RemoveLater() {
                        }

                        @Override
                        public void run() {
                            lastKillAltComplex.remove(finalComplexAttacker);
                            lastKillAlt.remove(finalAttacker2);
                            killTask.remove(finalComplexAttacker);
                        }
                    }
                    task2 = Bukkit.getScheduler().runTaskLater((Plugin)plugin, (Runnable)new RemoveLater(), (long)abusesec * 20L);
                    if (killTask.containsKey(finalComplexAttacker)) {
                        killTask.get(finalComplexAttacker).cancel();
                    }
                    killTask.put(finalComplexAttacker, task2);
                }
            } else {
                DEBUGGER.i("- checking alt abuse simple");
                if (lastKillAlt.containsKey(attacker.getPlayer().getAddress().toString()) && lastKillAlt.get(attacker.getPlayer().getAddress().toString()).equals(victim.getPlayer().getAddress().toString())) {
                    TextFormatter.explainAbusePrevention(attacker, victim, true);
                    DEBUGGER.i("> OUT: " + victim.getPlayer().getAddress().toString());
                    return;
                }
                lastKillAlt.put(attacker.getPlayer().getAddress().toString(), victim.getPlayer().getAddress().toString());
                abusesec = plugin.config().getInt(Config.Entry.STATISTICS_ABUSE_SECONDS);
                if (abusesec > 0) {
                    finalAttacker = attacker.getPlayer().getAddress().toString();
                    class RemoveLater
                    implements Runnable {
                        final /* synthetic */ String val$finalAttacker;

                        RemoveLater(String string) {
                            this.val$finalAttacker = string;
                        }

                        @Override
                        public void run() {
                            lastKillAlt.remove(this.val$finalAttacker);
                            killTask.remove(this.val$finalAttacker);
                        }
                    }
                    task = Bukkit.getScheduler().runTaskLater((Plugin)plugin, (Runnable)new RemoveLater(finalAttacker), (long)abusesec * 20L);
                    if (killTask.containsKey(finalAttacker)) {
                        killTask.get(finalAttacker).cancel();
                    }
                    killTask.put(finalAttacker, task);
                }
            }
        }
        if (victim == null) {
            DEBUGGER.i("victim is null", attacker.getName());
            if (plugin.config().getBoolean(Config.Entry.STATISTICS_CHECK_NEWBIES) && DatabaseAPI.isNewbie(attacker)) {
                DEBUGGER.i("killer has newbie status", attacker.getName());
                TextFormatter.explainNewbieStatus(attacker, null);
                return;
            }
            DatabaseAPI.incKill(attacker, PlayerStatisticsBuffer.getEloScore(attacker.getUniqueId()));
            if (plugin.getSQLHandler().allowsAsync()) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new DatabaseKillAddition(PlayerHandler.getPlayerName(attacker), attacker.getUniqueId().toString(), "", "", PlayerHandler.getPlayerWorld(attacker)));
            } else {
                Bukkit.getScheduler().runTask((Plugin)PVPStats.getInstance(), (Runnable)new DatabaseKillAddition(PlayerHandler.getPlayerName(attacker), attacker.getUniqueId().toString(), "", "", PlayerHandler.getPlayerWorld(attacker)));
            }
            SignDisplay.updateAll();
            return;
        }
        if (attacker == null) {
            DEBUGGER.i("attacker is null", victim.getName());
            if (plugin.config().getBoolean(Config.Entry.STATISTICS_CHECK_NEWBIES) && DatabaseAPI.isNewbie(victim)) {
                DEBUGGER.i("victim has newbie status", victim.getName());
                TextFormatter.explainNewbieStatus(null, victim);
                return;
            }
            streak = PlayerStatisticsBuffer.getStreak(victim.getUniqueId());
            int threshold = plugin.config().getInt(Config.Entry.STATISTICS_STREAK_BROKEN_THRESHOLD);
            if (threshold == 0 && streak > 0 || threshold > 0 && streak >= threshold) {
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)PVPStats.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        if (victim.getPlayer() != null) {
                            plugin.sendPrefixed((CommandSender)victim.getPlayer(), Language.MSG.PLAYER_KILLSTREAK_ENDED.parse(String.valueOf(streak)));
                            String playerName = PlayerHandler.getPlayerName(victim);
                            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                                plugin.sendPrefixed((CommandSender)p, Language.MSG.PLAYER_KILLSTREAK_ENDED_GLOBAL.parse(playerName, String.valueOf(streak)));
                            }
                        }
                    }
                }, 1L);
            }
            DatabaseAPI.incDeath(victim, PlayerStatisticsBuffer.getEloScore(victim.getUniqueId()));
            if (plugin.getSQLHandler().allowsAsync()) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new DatabaseKillAddition("", "", PlayerHandler.getPlayerName(victim), victim.getUniqueId().toString(), PlayerHandler.getPlayerWorld(victim)));
            } else {
                Bukkit.getScheduler().runTask((Plugin)PVPStats.getInstance(), (Runnable)new DatabaseKillAddition("", "", PlayerHandler.getPlayerName(victim), victim.getUniqueId().toString(), PlayerHandler.getPlayerWorld(victim)));
            }
            SignDisplay.updateAll();
            return;
        }
        if (plugin.config().getBoolean(Config.Entry.STATISTICS_CHECK_NEWBIES) && (DatabaseAPI.isNewbie(attacker) || DatabaseAPI.isNewbie(victim))) {
            DEBUGGER.i("either one has newbie status", victim.getName());
            TextFormatter.explainNewbieStatus(attacker, victim);
            return;
        }
        streak = PlayerStatisticsBuffer.getStreak(victim.getUniqueId());
        int threshold = plugin.config().getInt(Config.Entry.STATISTICS_STREAK_BROKEN_THRESHOLD);
        if (threshold == 0 && streak > 0 || threshold > 0 && streak >= threshold) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)PVPStats.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (victim.getPlayer() != null) {
                        plugin.sendPrefixed((CommandSender)victim.getPlayer(), Language.MSG.PLAYER_KILLSTREAK_ENDED.parse(String.valueOf(streak)));
                        String playerName = PlayerHandler.getPlayerName(victim);
                        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                            plugin.sendPrefixed((CommandSender)p, Language.MSG.PLAYER_KILLSTREAK_ENDED_GLOBAL.parse(playerName, String.valueOf(streak)));
                        }
                    }
                }
            }, 1L);
        }
        DEBUGGER.i("Counting kill by " + attacker.getName(), victim.getName());
        lastKill.put(attacker.getName(), victim.getName());
        if (!plugin.config().getBoolean(Config.Entry.ELO_ACTIVE)) {
            DEBUGGER.i("no elo", victim.getName());
            DatabaseAPI.incKill(attacker, PlayerStatisticsBuffer.getEloScore(attacker.getUniqueId()));
            DatabaseAPI.incDeath(victim, PlayerStatisticsBuffer.getEloScore(victim.getUniqueId()));
            DEBUGGER.i("internal stats updated. sending database update!");
            if (plugin.getSQLHandler().allowsAsync()) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new DatabaseKillAddition(PlayerHandler.getPlayerName(attacker), attacker.getUniqueId().toString(), PlayerHandler.getPlayerName(victim), victim.getUniqueId().toString(), PlayerHandler.getPlayerWorld(victim)));
            } else {
                Bukkit.getScheduler().runTask((Plugin)PVPStats.getInstance(), (Runnable)new DatabaseKillAddition(PlayerHandler.getPlayerName(attacker), attacker.getUniqueId().toString(), PlayerHandler.getPlayerName(victim), victim.getUniqueId().toString(), PlayerHandler.getPlayerWorld(victim)));
            }
            SignDisplay.updateAll();
            return;
        }
        int min = plugin.config().getInt(Config.Entry.ELO_MINIMUM);
        int max = plugin.config().getInt(Config.Entry.ELO_MAXIMUM);
        int kBelow = plugin.config().getInt(Config.Entry.ELO_K_BELOW);
        int kAbove = plugin.config().getInt(Config.Entry.ELO_K_ABOVE);
        int kThreshold = plugin.config().getInt(Config.Entry.ELO_K_THRESHOLD);
        final int oldA = PlayerStatisticsBuffer.getEloScore(attacker.getUniqueId());
        final int oldP = PlayerStatisticsBuffer.getEloScore(victim.getUniqueId());
        int kA = oldA >= kThreshold ? kAbove : kBelow;
        int kP = oldP >= kThreshold ? kAbove : kBelow;
        final int newA = DatabaseAPI.calcElo(oldA, oldP, kA, true, min, max);
        final int newP = DatabaseAPI.calcElo(oldP, oldA, kP, false, min, max);
        if (DatabaseAPI.incKill(attacker, newA)) {
            DEBUGGER.i("increasing kill", attacker.getName());
            if (!plugin.config().getBoolean(Config.Entry.ELO_ANNOUNCE_PUBLIC)) {
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)PVPStats.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        if (attacker.getPlayer() != null) {
                            plugin.sendPrefixed((CommandSender)attacker.getPlayer(), Language.MSG.PLAYER_ELO_ADDED.parse(String.valueOf(newA - oldA), String.valueOf(newA)));
                        }
                    }
                }, 1L);
            }
            PlayerStatisticsBuffer.setEloScore(attacker.getUniqueId(), newA);
        }
        if (DatabaseAPI.incDeath(victim, newP)) {
            DEBUGGER.i("increasing death", victim.getName());
            if (!plugin.config().getBoolean(Config.Entry.ELO_ANNOUNCE_PUBLIC)) {
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)PVPStats.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        plugin.sendPrefixed((CommandSender)victim.getPlayer(), Language.MSG.PLAYER_ELO_REMOVED.parse(String.valueOf(oldP - newP), String.valueOf(newP)));
                    }
                }, 1L);
            }
            PlayerStatisticsBuffer.setEloScore(victim.getUniqueId(), newP);
        }
        if (plugin.config().getBoolean(Config.Entry.ELO_ANNOUNCE_PUBLIC) && victim.getPlayer() != null && attacker.getPlayer() != null) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)PVPStats.getInstance(), new Runnable(){

                @Override
                public void run() {
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        if (p == null) continue;
                        plugin.sendPrefixed((CommandSender)p, Language.MSG.PLAYER_ELO_EXCHANGE_PUBLIC_1.parse(attacker.getPlayer().getName(), victim.getPlayer().getName(), String.valueOf(newA - oldA), String.valueOf(oldP - newP)));
                        plugin.sendPrefixed((CommandSender)p, Language.MSG.PLAYER_ELO_EXCHANGE_PUBLIC_2.parse(attacker.getPlayer().getName(), victim.getPlayer().getName(), String.valueOf(newA), String.valueOf(newP)));
                    }
                }
            }, 1L);
        }
        if (plugin.getSQLHandler().allowsAsync()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new DatabaseKillAddition(PlayerHandler.getPlayerName(attacker), attacker.getUniqueId().toString(), PlayerHandler.getPlayerName(victim), victim.getUniqueId().toString(), PlayerHandler.getPlayerWorld(attacker)));
        } else {
            Bukkit.getScheduler().runTask((Plugin)PVPStats.getInstance(), (Runnable)new DatabaseKillAddition(PlayerHandler.getPlayerName(attacker), attacker.getUniqueId().toString(), PlayerHandler.getPlayerName(victim), victim.getUniqueId().toString(), PlayerHandler.getPlayerWorld(attacker)));
        }
        SignDisplay.updateAll();
    }

    public static List<UUID> getAllUUIDs() {
        if (!plugin.getSQLHandler().isConnected()) {
            plugin.getLogger().severe("Database is not connected!");
            plugin.sendPrefixedOP(new ArrayList<CommandSender>(), DATABASE_CONNECTED);
            return null;
        }
        if (allUUIDs == null) {
            ArrayList<UUID> output = new ArrayList<UUID>();
            try {
                List<UUID> result = plugin.getSQLHandler().getStatsUUIDs();
                output.addAll(result);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            allUUIDs = output;
        }
        return allUUIDs;
    }

    public static PlayerStatistic getAllStats(OfflinePlayer player) {
        if (!plugin.getSQLHandler().isConnected()) {
            plugin.getLogger().severe("Database is not connected!");
            plugin.sendPrefixedOP(new ArrayList<CommandSender>(), DATABASE_CONNECTED);
            return new PlayerStatistic(PlayerHandler.getPlayerName(player), 0, 0, 0, 0, 0, 0L, player.getUniqueId());
        }
        try {
            return plugin.getSQLHandler().getStats(player);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return new PlayerStatistic(PlayerHandler.getPlayerName(player), 0, 0, 0, 0, 0, 0L, player.getUniqueId());
        }
    }

    public static List<String> getAllPlayers() {
        if (!plugin.getSQLHandler().isConnected()) {
            plugin.getLogger().severe("Database is not connected!");
            plugin.sendPrefixedOP(new ArrayList<CommandSender>(), DATABASE_CONNECTED);
            return null;
        }
        if (allPlayerNames == null) {
            ArrayList<String> output = new ArrayList<String>();
            try {
                List<String> result = plugin.getSQLHandler().getNamesWithoutUUIDs();
                output.addAll(result);
                allPlayerNames = output;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return allPlayerNames;
    }

    public static Integer getEntry(UUID uuid, String entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry can not be null!");
        }
        if (!(entry.equals("elo") || entry.equals("kills") || entry.equals("deaths") || entry.equals("streak") || entry.equals("currentstreak"))) {
            throw new IllegalArgumentException("entry can not be '" + entry + "'. Valid values: elo, kills, deaths, streak, currentstreak");
        }
        if (!plugin.getSQLHandler().isConnected()) {
            plugin.getLogger().severe("Database is not connected!");
            plugin.sendPrefixedOP(new ArrayList<CommandSender>(), DATABASE_CONNECTED);
            return null;
        }
        int result = -1;
        try {
            result = plugin.getSQLHandler().getStats(entry, uuid);
            if (result < 0) {
                return 0;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result < 0 ? 0 : result;
    }

    public static String getLastKilled(String killer) {
        return lastKill.get(killer);
    }

    public static boolean hasEntry(UUID uuid) {
        int result = -1;
        try {
            result = plugin.getSQLHandler().getStats("kills", uuid);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return result > -1;
    }

    public static String[] info(OfflinePlayer player) {
        if (!plugin.getSQLHandler().isConnected()) {
            plugin.getLogger().severe("Database is not connected!");
            plugin.sendPrefixedOP(new ArrayList<CommandSender>(), DATABASE_CONNECTED);
            return null;
        }
        DEBUGGER.i("getting info for " + player.getName());
        PlayerStatistic result = null;
        try {
            result = plugin.getSQLHandler().getStats(player);
            if (result == null) {
                String[] output = new String[]{Language.MSG.COMMAND_PLAYER_NOT_FOUND.parse(PlayerHandler.getPlayerName(player))};
                return output;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (result == null) {
            String[] output = new String[]{Language.MSG.COMMAND_PLAYER_NOT_FOUND.parse(PlayerHandler.getPlayerName(player))};
            output[1] = Language.MSG.COMMAND_PLAYER_NOT_FOUND_EXPLANATION.parse();
            return output;
        }
        String name = result.getName();
        int elo = result.getELO();
        int kills = result.getKills();
        int deaths = result.getDeaths();
        int streak = result.getCurrentStreak();
        int maxStreak = result.getMaxStreak();
        Double ratio = DatabaseAPI.calculateRatio(result);
        DecimalFormat df = new DecimalFormat("#.##");
        if (plugin.config().getBoolean(Config.Entry.MESSAGES_OVERRIDES)) {
            List<String> lines = plugin.config().getStringList(Config.Entry.MESSAGES_OVERRIDE_LIST, new ArrayList<String>());
            String[] output = new String[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                line = line.replace("%d", String.valueOf(deaths));
                line = line.replace("%k", String.valueOf(kills));
                line = line.replace("%m", String.valueOf(maxStreak));
                line = line.replace("%n", name);
                line = line.replace("%r", df.format(ratio));
                line = line.replace("%s", String.valueOf(streak));
                line = line.replace("%e", String.valueOf(elo));
                output[i] = Language.colorize(line);
            }
            return output;
        }
        String[] output = new String[plugin.config().getBoolean(Config.Entry.ELO_ACTIVE) ? 7 : 6];
        output[0] = Language.MSG.STATISTIC_FORMAT_VALUE.parse(Language.MSG.STATISTIC_VALUE_NAME.parse(), name);
        output[1] = Language.MSG.STATISTIC_FORMAT_VALUE.parse(Language.MSG.STATISTIC_VALUE_KILLS.parse(), String.valueOf(kills));
        output[2] = Language.MSG.STATISTIC_FORMAT_VALUE.parse(Language.MSG.STATISTIC_VALUE_DEATHS.parse(), String.valueOf(deaths));
        output[3] = Language.MSG.STATISTIC_FORMAT_VALUE.parse(Language.MSG.STATISTIC_VALUE_RATIO.parse(), df.format(ratio));
        output[4] = Language.MSG.STATISTIC_FORMAT_VALUE.parse(Language.MSG.STATISTIC_VALUE_STREAK.parse(), String.valueOf(streak));
        output[5] = Language.MSG.STATISTIC_FORMAT_VALUE.parse(Language.MSG.STATISTIC_VALUE_MAX_STREAK.parse(), String.valueOf(maxStreak));
        if (plugin.config().getBoolean(Config.Entry.ELO_ACTIVE)) {
            output[6] = Language.MSG.STATISTIC_FORMAT_VALUE.parse(Language.MSG.STATISTIC_VALUE_ELO.parse(), String.valueOf(elo));
        }
        return output;
    }

    public static void initiate(PVPStats plugin) {
        DatabaseAPI.plugin = plugin;
    }

    public static void initiatePlayer(OfflinePlayer player) {
        if (!DatabaseAPI.getAllUUIDs().contains(player.getUniqueId())) {
            if (DatabaseAPI.getAllPlayers().contains(PlayerHandler.getPlayerName(player))) {
                try {
                    plugin.getSQLHandler().setStatUIDByPlayer(player);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                allUUIDs.add(player.getUniqueId());
                allPlayerNames.remove(PlayerHandler.getPlayerName(player));
            } else if (plugin.config().getBoolean(Config.Entry.STATISTICS_CREATE_ON_JOIN)) {
                if (plugin.getSQLHandler().allowsAsync()) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new DatabaseFirstEntry(player));
                } else {
                    Bukkit.getScheduler().runTask((Plugin)PVPStats.getInstance(), (Runnable)new DatabaseFirstEntry(player));
                }
                allUUIDs.add(player.getUniqueId());
            } else {
                allUUIDs.add(player.getUniqueId());
            }
        }
        PlayerStatisticsBuffer.loadPlayer(player);
    }

    private static DatabaseConnection connectToOther(String method, CommandSender sender) {
        DatabaseConnection dbHandler = null;
        String dbHost = null;
        String dbUser = null;
        String dbPass = null;
        String dbDatabase = null;
        String dbTable = null;
        String dbOptions = null;
        String dbKillTable = null;
        int dbPort = 0;
        Config config = PVPStats.getInstance().config();
        if (method.equals("yml")) {
            if (PVPStats.getInstance().getSQLHandler() instanceof FlatFileConnection) {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_MIGRATE_DATABASE_METHOD_INVALID.parse());
                return null;
            }
            dbTable = config.getString(Config.Entry.YML_TABLE);
            if (config.getBoolean(Config.Entry.STATISTICS_COLLECT_PRECISE) && config.getBoolean(Config.Entry.YML_COLLECT_PRECISE)) {
                dbKillTable = config.getString(Config.Entry.MYSQL_KILLTABLE);
            }
            dbHandler = new FlatFileConnection(dbTable, dbKillTable);
        } else if (method.equals("sqlite")) {
            if (PVPStats.getInstance().getSQLHandler() instanceof SQLiteConnection) {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_MIGRATE_DATABASE_METHOD_INVALID.parse());
                return null;
            }
            dbDatabase = config.getString(Config.Entry.SQLITE_FILENAME);
            dbTable = config.getString(Config.Entry.SQLITE_TABLE);
            if (config.getBoolean(Config.Entry.STATISTICS_COLLECT_PRECISE)) {
                dbKillTable = config.getString(Config.Entry.SQLITE_KILLTABLE);
            }
            dbHandler = new SQLiteConnection(dbDatabase, dbTable, dbKillTable);
        } else if (method.equals("mysql")) {
            if (PVPStats.getInstance().getSQLHandler() instanceof MySQLConnection) {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_MIGRATE_DATABASE_METHOD_INVALID.parse());
                return null;
            }
            dbHost = config.getString(Config.Entry.MYSQL_HOST);
            dbUser = config.getString(Config.Entry.MYSQL_USERNAME);
            dbPass = config.getString(Config.Entry.MYSQL_PASSWORD);
            dbDatabase = config.getString(Config.Entry.MYSQL_DATABASE);
            dbTable = config.getString(Config.Entry.MYSQL_TABLE);
            dbOptions = config.getString(Config.Entry.MYSQL_OPTIONS);
            if (config.getBoolean(Config.Entry.STATISTICS_COLLECT_PRECISE)) {
                dbKillTable = config.getString(Config.Entry.MYSQL_KILLTABLE);
            }
            dbPort = config.getInt(Config.Entry.MYSQL_PORT);
            try {
                dbHandler = new MySQLConnection(dbHost, dbPort, dbDatabase, dbUser, dbPass, dbOptions, dbTable, dbKillTable);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e1) {
                e1.printStackTrace();
            }
        } else {
            return null;
        }
        if (dbHandler != null && dbHandler.connect(true)) {
            sender.sendMessage("Database connection successful");
            if (!dbHandler.tableExists(dbDatabase, dbTable)) {
                sender.sendMessage("Creating table " + dbTable);
                dbHandler.createStatsTable(true);
                if (dbKillTable != null) {
                    sender.sendMessage("Creating table " + dbKillTable);
                    dbHandler.createKillStatsTable(true);
                }
            } else if (!dbHandler.hasColumn(dbKillTable, "world")) {
                dbHandler.addWorldColumn();
            }
        } else {
            sender.sendMessage("Database connection failed");
        }
        return dbHandler;
    }

    public static int migrateFrom(String method, CommandSender sender) {
        DatabaseConnection dbHandler = DatabaseAPI.connectToOther(method, sender);
        if (dbHandler == null) {
            return -1;
        }
        try {
            List<PlayerStatistic> players = dbHandler.getAll();
            for (PlayerStatistic stat : players) {
                PVPStats.getInstance().getSQLHandler().insert(stat);
            }
            return players.size();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int migrateTo(String method, CommandSender sender) {
        DatabaseConnection dbHandler = DatabaseAPI.connectToOther(method, sender);
        if (dbHandler == null) {
            return -1;
        }
        try {
            List<PlayerStatistic> players = PVPStats.getInstance().getSQLHandler().getAll();
            for (PlayerStatistic stat : players) {
                dbHandler.insert(stat);
            }
            return players.size();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static boolean isNewbie(OfflinePlayer player) {
        Player p = player.getPlayer();
        if (p == null) {
            DEBUGGER.i("Player is offline, we assume they are not newbie...");
            return false;
        }
        boolean newbie = p.hasPermission("pvpstats.newbie");
        if (p.hasPermission("pvpstats.null")) {
            DEBUGGER.i("Player has ALL permissions, we assume they are not newbie...");
            return false;
        }
        if (newbie) {
            DEBUGGER.i("Player has 'newbie'...");
            return true;
        }
        return !p.hasPermission("pvpstats.nonewbie");
    }

    public static int purgeKillStats(int days) {
        if (!plugin.getSQLHandler().isConnected()) {
            plugin.getLogger().severe("Database is not connected!");
            plugin.sendPrefixedOP(new ArrayList<CommandSender>(), DATABASE_CONNECTED);
            return 0;
        }
        int count = 0;
        long timestamp = System.currentTimeMillis() / 1000L - (long)days * 24L * 60L * 60L;
        try {
            count = plugin.getSQLHandler().deleteKillsOlderThan(timestamp);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    public static int purgeStats(int days) {
        if (!plugin.getSQLHandler().isConnected()) {
            plugin.getLogger().severe("Database is not connected!");
            plugin.sendPrefixedOP(new ArrayList<CommandSender>(), DATABASE_CONNECTED);
            return 0;
        }
        int count = 0;
        long timestamp = System.currentTimeMillis() / 1000L - (long)days * 24L * 60L * 60L;
        try {
            count = plugin.getSQLHandler().deleteStatsOlderThan(timestamp);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    public static void setSpecificStat(OfflinePlayer player, String entry, int value) {
        if (!(entry.equals("elo") || entry.equals("kills") || entry.equals("deaths") || entry.equals("streak") || entry.equals("currentstreak"))) {
            throw new IllegalArgumentException("entry can not be '" + entry + "'. Valid values: elo, kills, deaths, streak, currentstreak");
        }
        if (PVPStats.getInstance().getSQLHandler().allowsAsync()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, (Runnable)new DatabaseSetSpecific(player.getUniqueId(), entry, value));
        } else {
            Bukkit.getScheduler().runTask((Plugin)plugin, (Runnable)new DatabaseSetSpecific(player.getUniqueId(), entry, value));
        }
    }

    public static String[] top(int limit, String sort) {
        if (!plugin.getSQLHandler().isConnected()) {
            plugin.getLogger().severe("Database is not connected!");
            plugin.sendPrefixedOP(new ArrayList<CommandSender>(), DATABASE_CONNECTED);
            return null;
        }
        sort = sort.toUpperCase();
        List<PlayerStatistic> result = null;
        HashMap<String, Double> results = new HashMap<String, Double>();
        ArrayList<String> sortedValues = new ArrayList<String>();
        try {
            String order;
            switch (sort) {
                case "DEATHS": {
                    order = "deaths";
                    break;
                }
                case "STREAK": {
                    order = "streak";
                    break;
                }
                case "CURRENTSTREAK": {
                    order = "currentstreak";
                    break;
                }
                case "ELO": {
                    order = "elo";
                    break;
                }
                case "RADIO": 
                case "K-D": {
                    order = "`kills`/(`deaths`+1.0)";
                    break;
                }
                default: {
                    order = "kills";
                }
            }
            boolean isAscending = false;
            if (!PVPStats.getInstance().config().getBoolean(Config.Entry.STATISTICS_DEATHS_DESCENDING) && sort.equals("DEATHS")) {
                isAscending = true;
            }
            result = plugin.getSQLHandler().getTopSorted(limit, order, isAscending);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (result != null) {
            block32: for (PlayerStatistic entry : result) {
                switch (sort) {
                    case "KILLS": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getKills())));
                        continue block32;
                    }
                    case "DEATHS": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getDeaths())));
                        continue block32;
                    }
                    case "ELO": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getELO())));
                        continue block32;
                    }
                    case "STREAK": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getMaxStreak())));
                        continue block32;
                    }
                    case "CURRENTSTREAK": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getCurrentStreak())));
                        continue block32;
                    }
                }
                results.put(entry.getName(), DatabaseAPI.calculateRatio(entry));
            }
        }
        if (sort.equals("KILLS") || sort.equals("DEATHS") || sort.equals("ELO") || sort.equals("STREAK") || sort.equals("CURRENTSTREAK")) {
            String[] output = new String[sortedValues.size()];
            int pos = 0;
            for (String s : sortedValues) {
                output[pos++] = s;
            }
            return output;
        }
        return DatabaseAPI.sortParse(results, limit);
    }

    public static String[] topWorld(int limit, String sort, String world, int days) {
        if (!plugin.getSQLHandler().isConnected()) {
            plugin.getLogger().severe("Database is not connected!");
            plugin.sendPrefixedOP(new ArrayList<CommandSender>(), DATABASE_CONNECTED);
            return null;
        }
        sort = sort.toUpperCase();
        List<PlayerStatistic> result = null;
        HashMap<String, Double> results = new HashMap<String, Double>();
        ArrayList<String> sortedValues = new ArrayList<String>();
        try {
            result = plugin.getSQLHandler().getTopWorldSorted(limit, sort, world, days);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (result != null) {
            block10: for (PlayerStatistic entry : result) {
                switch (sort) {
                    case "KILLS": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getKills())));
                        continue block10;
                    }
                    case "DEATHS": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getDeaths())));
                        continue block10;
                    }
                }
                results.put(entry.getName(), DatabaseAPI.calculateRatio(entry));
            }
        }
        if (sort.equals("KILLS") || sort.equals("DEATHS")) {
            String[] output = new String[sortedValues.size()];
            int pos = 0;
            for (String s : sortedValues) {
                output[pos++] = s;
            }
            return output;
        }
        return DatabaseAPI.sortParse(results, limit);
    }

    public static String[] topPlus(int limit, String sort, int days) {
        if (!plugin.getSQLHandler().isConnected()) {
            plugin.getLogger().severe("Database is not connected!");
            plugin.sendPrefixedOP(new ArrayList<CommandSender>(), DATABASE_CONNECTED);
            return null;
        }
        sort = sort.toUpperCase();
        List<PlayerStatistic> result = null;
        HashMap<String, Double> results = new HashMap<String, Double>();
        ArrayList<String> sortedValues = new ArrayList<String>();
        try {
            result = plugin.getSQLHandler().getTopPlusSorted(limit, sort, days);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (result != null) {
            block10: for (PlayerStatistic entry : result) {
                switch (sort) {
                    case "KILLS": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getKills())));
                        continue block10;
                    }
                    case "DEATHS": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getDeaths())));
                        continue block10;
                    }
                }
                results.put(entry.getName(), DatabaseAPI.calculateRatio(entry));
            }
        }
        if (sort.equals("KILLS") || sort.equals("DEATHS")) {
            String[] output = new String[sortedValues.size()];
            int pos = 0;
            for (String s : sortedValues) {
                output[pos++] = s;
            }
            return output;
        }
        return DatabaseAPI.sortParse(results, limit);
    }

    public static String[] flop(int count, String sort) {
        if (!plugin.getSQLHandler().isConnected()) {
            plugin.getLogger().severe("Database is not connected!");
            plugin.sendPrefixedOP(new ArrayList<CommandSender>(), DATABASE_CONNECTED);
            return null;
        }
        sort = sort.toUpperCase();
        List<PlayerStatistic> result = null;
        HashMap<String, Double> results = new HashMap<String, Double>();
        ArrayList<String> sortedValues = new ArrayList<String>();
        try {
            String order;
            switch (sort) {
                case "DEATHS": {
                    order = "deaths";
                    break;
                }
                case "STREAK": {
                    order = "streak";
                    break;
                }
                case "CURRENTSTREAK": {
                    order = "currentstreak";
                    break;
                }
                case "ELO": {
                    order = "elo";
                    break;
                }
                case "RATIO": 
                case "K-D": {
                    order = "`kills`/(`deaths`+1.0)";
                    break;
                }
                default: {
                    order = "kills";
                }
            }
            int limit = count;
            boolean isAscending = true;
            if (!PVPStats.getInstance().config().getBoolean(Config.Entry.STATISTICS_DEATHS_DESCENDING) && sort.equals("DEATHS")) {
                isAscending = false;
            }
            result = plugin.getSQLHandler().getTopSorted(limit, order, isAscending);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (result != null) {
            block32: for (PlayerStatistic entry : result) {
                switch (sort) {
                    case "KILLS": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getKills())));
                        continue block32;
                    }
                    case "DEATHS": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getDeaths())));
                        continue block32;
                    }
                    case "ELO": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getELO())));
                        continue block32;
                    }
                    case "STREAK": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getMaxStreak())));
                        continue block32;
                    }
                    case "CURRENTSTREAK": {
                        sortedValues.add(Language.MSG.STATISTIC_FORMAT_VALUE.parse(entry.getName(), String.valueOf(entry.getCurrentStreak())));
                        continue block32;
                    }
                }
                results.put(entry.getName(), DatabaseAPI.calculateRatio(entry));
            }
        }
        if (sort.equals("KILLS") || sort.equals("DEATHS") || sort.equals("ELO") || sort.equals("STREAK") || sort.equals("CURRENTSTREAK")) {
            String[] output = new String[sortedValues.size()];
            int pos = 0;
            for (String s : sortedValues) {
                output[pos++] = s;
            }
            return output;
        }
        return DatabaseAPI.sortParse(results, count);
    }

    public static List<Map<InformationType, String>> detailedTop(int max, InformationType column) {
        ArrayList<Map<InformationType, String>> result = new ArrayList<Map<InformationType, String>>();
        try {
            String sort = "";
            switch (column) {
                case NAME: 
                case DEATHS: 
                case KILLS: 
                case ELO: 
                case CURRENTSTREAK: 
                case STREAK: {
                    sort = column.name().toLowerCase();
                }
            }
            List<PlayerStatistic> stats = plugin.getSQLHandler().getTopSorted(max, sort, column == InformationType.DEATHS);
            for (PlayerStatistic stat : stats) {
                result.add(stat.toStringMap());
            }
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        return result;
    }

    public static void wipe(UUID uuid) {
        if (uuid == null) {
            plugin.getSQLHandler().deleteStats();
            plugin.getSQLHandler().deleteKills();
        } else {
            plugin.getSQLHandler().deleteStatsByUUID(uuid);
            plugin.getSQLHandler().deleteKillsByUUID(uuid);
        }
        PlayerStatisticsBuffer.clear(uuid);
    }

    public static Double calculateRatio(PlayerStatistic statistic) {
        if (plugin.config().getBoolean(Config.Entry.STATISTICS_KD_SIMPLE)) {
            if (statistic.getDeaths() < 1) {
                return statistic.getKills();
            }
            return (double)statistic.getKills() / (double)statistic.getDeaths();
        }
        if (formula == null) {
            String string = plugin.config().getString(Config.Entry.STATISTICS_KD_CALCULATION);
            formula = MathFormulaManager.getInstance().parse(string);
        }
        return formula.evaluate(statistic);
    }

    @Deprecated
    public static Double calculateRatio(int kills, int deaths, int streak, int maxstreak) {
        return DatabaseAPI.calculateRatio(new PlayerStatistic("legacy", kills, deaths, maxstreak, streak, 0, 0L, new UUID(0L, 0L)));
    }

    public static int calcElo(int myOld, int otherOld, int k, boolean win, int min, int max) {
        double expected = 1.0 / (1.0 + Math.pow(10.0, (float)(otherOld - myOld) / 400.0f));
        int newVal = win ? (int)Math.round((double)myOld + (double)k * (1.0 - expected)) : (int)Math.round((double)myOld + (double)k * (0.0 - expected));
        if (min > -1 && newVal < min) {
            return min;
        }
        if (max > -1 && newVal > max) {
            return max;
        }
        return newVal;
    }

    private static void checkAndDo(String playerName, UUID uuid, boolean kill, boolean addMaxStreak, int elo, String world) {
        if (plugin.getSQLHandler().allowsAsync()) {
            DEBUGGER.i("checkAndDo will run async...");
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new CheckAndDo(playerName, uuid, kill, addMaxStreak, elo, world));
        } else {
            DEBUGGER.i("checkAndDo will run SYNC!");
            Bukkit.getScheduler().runTask((Plugin)PVPStats.getInstance(), (Runnable)new CheckAndDo(playerName, uuid, kill, addMaxStreak, elo, world));
        }
    }

    private static boolean incDeath(OfflinePlayer player, int elo) {
        if (player.getPlayer() == null || player.getPlayer().hasPermission("pvpstats.count")) {
            PlayerStatisticsBuffer.setStreak(player.getUniqueId(), 0);
            DatabaseAPI.checkAndDo(PlayerHandler.getPlayerName(player), player.getUniqueId(), false, false, elo, PlayerHandler.getPlayerWorld(player));
            return true;
        }
        return false;
    }

    private static boolean incKill(OfflinePlayer player, int elo) {
        if (player.getPlayer() == null || player.getPlayer().hasPermission("pvpstats.count")) {
            boolean incMaxStreak;
            if (PlayerStatisticsBuffer.hasStreak(player.getUniqueId())) {
                incMaxStreak = PlayerStatisticsBuffer.addStreak(player.getUniqueId());
                PlayerStatisticsBuffer.getStreak(player.getUniqueId());
            } else {
                int streakCheck = PlayerStatisticsBuffer.getStreak(player.getUniqueId());
                if (streakCheck < 1) {
                    PlayerStatisticsBuffer.setStreak(player.getUniqueId(), 1);
                    PlayerStatisticsBuffer.setMaxStreak(player.getUniqueId(), 1);
                    incMaxStreak = true;
                } else {
                    incMaxStreak = PlayerStatisticsBuffer.addStreak(player.getUniqueId());
                }
            }
            DatabaseAPI.checkAndDo(PlayerHandler.getPlayerName(player), player.getUniqueId(), true, incMaxStreak, elo, PlayerHandler.getPlayerWorld(player));
            return true;
        }
        return false;
    }

    private static String[] sortParse(Map<String, Double> results, int count) {
        String[] result = new String[results.size()];
        Double[] sort = new Double[results.size()];
        int pos = 0;
        DecimalFormat df = new DecimalFormat("#.##");
        for (String key : results.keySet()) {
            sort[pos] = results.get(key);
            result[pos] = Language.MSG.STATISTIC_FORMAT_VALUE.parse(key, df.format(sort[pos]));
            ++pos;
        }
        int pos2 = results.size();
        boolean doMore = true;
        while (doMore) {
            --pos2;
            doMore = false;
            for (int i = 0; i < pos2; ++i) {
                if (!(sort[i] < sort[i + 1])) continue;
                double tempI = sort[i];
                sort[i] = sort[i + 1];
                sort[i + 1] = tempI;
                String tempR = result[i];
                result[i] = result[i + 1];
                result[i + 1] = tempR;
                doMore = true;
            }
        }
        if (result.length < count) {
            return result;
        }
        String[] output = new String[count];
        System.arraycopy(result, 0, output, 0, output.length);
        return output;
    }

    public static void refresh() {
        PlayerStatisticsBuffer.refresh();
        formula = null;
    }

    static {
        lastKill = new HashMap<String, String>();
        lastKillAlt = new HashMap<String, String>();
        lastKillComplex = new HashMap<String, String>();
        lastKillAltComplex = new HashMap<String, String>();
        killTask = new HashMap<String, BukkitTask>();
        DATABASE_CONNECTED = new TextComponent("Warning: Database is not connected! Kills will not be recorded.");
    }
}

