/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.runnables;

import java.util.UUID;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.PlayerStatisticsBuffer;
import net.slipcor.pvpstats.core.CoreDebugger;
import net.slipcor.pvpstats.runnables.DatabaseIncreaseDeaths;
import net.slipcor.pvpstats.runnables.DatabaseIncreaseKills;
import net.slipcor.pvpstats.runnables.DatabaseIncreaseKillsStreak;
import org.bukkit.Bukkit;

public class CheckAndDo
implements Runnable {
    private final String playerName;
    private final UUID uuid;
    private final boolean kill;
    private final boolean addMaxStreak;
    private final int elo;
    private final String world;
    public static CoreDebugger DEBUGGER;
    private final PVPStats plugin = PVPStats.getInstance();

    public CheckAndDo(String playerName, UUID uuid, boolean kill, boolean addMaxStreak, int elo, String world) {
        this.playerName = playerName;
        this.uuid = uuid;
        this.kill = kill;
        this.addMaxStreak = addMaxStreak;
        this.elo = elo;
        this.world = world;
    }

    @Override
    public void run() {
        DEBUGGER.i("checkAndDo running in thread: " + Thread.currentThread().getName());
        DEBUGGER.i("checkAndDo isMainThread: " + (Bukkit.isPrimaryThread() ? "YES" : "NO"));
        if (!this.plugin.getSQLHandler().hasEntry(this.uuid)) {
            DEBUGGER.i("player has no entry yet, adding!");
            int kills = this.kill ? 1 : 0;
            int deaths = this.kill ? 0 : 1;
            this.plugin.getSQLHandler().addFirstStat(this.playerName, this.uuid, kills, deaths, this.elo);
            PlayerStatisticsBuffer.setKills(this.uuid, kills);
            PlayerStatisticsBuffer.setDeaths(this.uuid, deaths);
            return;
        }
        if (this.addMaxStreak && this.kill) {
            DEBUGGER.i("increasing kills and max streak");
            new DatabaseIncreaseKillsStreak(this.playerName, this.uuid, this.elo).run();
        } else if (this.kill) {
            DEBUGGER.i("increasing kills and current streak");
            new DatabaseIncreaseKills(this.playerName, this.uuid, this.elo).run();
        } else {
            DEBUGGER.i("increasing deaths");
            new DatabaseIncreaseDeaths(this.playerName, this.uuid, this.elo).run();
        }
        if (this.kill) {
            PlayerStatisticsBuffer.addKill(this.uuid);
        } else {
            PlayerStatisticsBuffer.addDeath(this.uuid);
        }
    }
}

