/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.metrics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.concurrent.Callable;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.core.CoreMetrics;
import net.slipcor.pvpstats.yml.Config;
import org.bukkit.plugin.Plugin;

public class MetricsMain
extends CoreMetrics {
    public MetricsMain(Plugin plugin) {
        super(plugin, 9747);
        this.addConnectionChart(Config.Entry.MYSQL_ACTIVE, Config.Entry.SQLITE_ACTIVE);
        this.addChart(Config.Entry.STATISTICS_KD_SIMPLE, "simple_kd_ratio");
        this.addChart(Config.Entry.STATISTICS_CLEAR_ON_START, "clear_on_start");
        this.addChart(Config.Entry.STATISTICS_CREATE_ON_JOIN, "create_on_join");
        this.addChart(Config.Entry.STATISTICS_COLLECT_PRECISE, "collect_precise");
        this.addChart(Config.Entry.STATISTICS_COUNT_REGULAR_DEATHS, "count_regular_deaths");
        this.addChart(Config.Entry.STATISTICS_CHECK_ABUSE, "check_abuse");
        this.addChart(Config.Entry.STATISTICS_CHECK_NEWBIES, "check_newbies");
        this.addChart(Config.Entry.STATISTICS_DEATHS_DESCENDING, "deaths_descending");
        this.addChart(Config.Entry.STATISTICS_RESET_KILLSTREAK_ON_QUIT, "reset_streak");
        this.addChart(Config.Entry.STATISTICS_STREAK_ANNOUNCEMENTS, "streak_announcements");
        this.addChart(Config.Entry.STATISTICS_STREAK_COMMANDS, "streak_commands");
        this.addChart(Config.Entry.ELO_ACTIVE, "use_elo");
        this.addChart(Config.Entry.OTHER_PVPARENA, "use_pvparena");
        PVPStats.getInstance().getLogger().info("sending full Metrics! You can deactivate this in the config.yml");
    }

    private void addConnectionChart(final Config.Entry mysql, final Config.Entry sqlite) {
        this.addCustomChart(new CoreMetrics.SimplePie("connection_type", new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (PVPStats.getInstance().config().getBoolean(mysql)) {
                    return "mySQL";
                }
                if (PVPStats.getInstance().config().getBoolean(sqlite)) {
                    return "SQLite";
                }
                return "YML";
            }
        }));
    }

    private void addChart(final Config.Entry cfg, String id) {
        this.addCustomChart(new CoreMetrics.SimplePie(id, new Callable<String>(){

            @Override
            public String call() throws Exception {
                return String.valueOf(PVPStats.getInstance().config().getBoolean(cfg));
            }
        }));
    }

    @Override
    protected JsonArray calculateCharts() {
        JsonArray customCharts = new JsonArray();
        for (CoreMetrics.CustomChart customChart : this.charts) {
            JsonObject chart = customChart.getRequestJsonObject();
            if (chart == null) continue;
            customCharts.add((JsonElement)chart);
        }
        return customCharts;
    }
}

