/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.math;

import java.util.ArrayDeque;
import java.util.List;
import net.slipcor.pvpstats.math.Formula;
import net.slipcor.pvpstats.math.InfixFormula;
import net.slipcor.pvpstats.math.InfixOperatorToken;
import net.slipcor.pvpstats.math.InfixToPostfix;
import net.slipcor.pvpstats.math.NumberToken;
import net.slipcor.pvpstats.math.PrefixFormula;
import net.slipcor.pvpstats.math.PrefixOperatorToken;
import net.slipcor.pvpstats.math.StatisticFormula;
import net.slipcor.pvpstats.math.StatisticToken;
import net.slipcor.pvpstats.math.Token;
import net.slipcor.pvpstats.math.UnexpectedStackSizeException;
import net.slipcor.pvpstats.math.ValueFormula;

public class Parser {
    private boolean debug = false;

    public Formula parse(List<Token> tokens) {
        List<Token> postFix = new InfixToPostfix().convert(tokens);
        if (this.debug) {
            System.out.println("postFix: " + postFix);
        }
        ArrayDeque<Formula> stack = new ArrayDeque<Formula>();
        for (Token token : postFix) {
            if (token instanceof NumberToken || token instanceof StatisticToken) {
                stack.push(this.parse(token));
                continue;
            }
            if (token instanceof PrefixOperatorToken) {
                Formula argument = (Formula)stack.pop();
                stack.push(new PrefixFormula(((PrefixOperatorToken)token).symbol, argument));
            }
            if (!(token instanceof InfixOperatorToken)) continue;
            Formula right = (Formula)stack.pop();
            Formula left = (Formula)stack.pop();
            stack.push(new InfixFormula(((InfixOperatorToken)token).symbol, left, right));
        }
        if (stack.size() == 1) {
            return (Formula)stack.pop();
        }
        throw new UnexpectedStackSizeException(stack.size());
    }

    Formula parse(Token token) {
        if (token instanceof NumberToken) {
            NumberToken number = (NumberToken)token;
            return new ValueFormula(number.value);
        }
        if (token instanceof StatisticToken) {
            StatisticToken statistic = (StatisticToken)token;
            return StatisticFormula.from(statistic.type);
        }
        throw new IllegalArgumentException("Cannot be turned into Formula: " + token);
    }

    @Deprecated
    public void setDebug(boolean value) {
        this.debug = value;
        InfixToPostfix.debug = value;
    }
}

