/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.math;

import java.util.HashMap;
import java.util.Map;
import net.slipcor.pvpstats.api.InformationType;
import net.slipcor.pvpstats.math.InfixOperatorToken;
import net.slipcor.pvpstats.math.PrefixOperatorToken;
import net.slipcor.pvpstats.math.StatisticToken;

public class Environment {
    private static final String OPERATOR_SYMBOLS = "+-*/^";
    private final Map<String, InfixOperatorToken> infixOperators = new HashMap<String, InfixOperatorToken>();
    private final Map<String, PrefixOperatorToken> prefixOperators = new HashMap<String, PrefixOperatorToken>();
    private final Map<String, StatisticToken> statistics = new HashMap<String, StatisticToken>();

    Environment() {
        this.registerInfixOperator("+", 2, true);
        this.registerInfixOperator("-", 2, true);
        this.registerInfixOperator("*", 3, true);
        this.registerInfixOperator("/", 3, true);
        this.registerInfixOperator("^", 4, false);
        this.registerPrefixOperator("+", 4);
        this.registerPrefixOperator("-", 4);
        this.registerStatistic("&k", InformationType.KILLS);
        this.registerStatistic("&d", InformationType.DEATHS);
        this.registerStatistic("&e", InformationType.ELO);
        this.registerStatistic("&s", InformationType.CURRENTSTREAK);
        this.registerStatistic("&m", InformationType.STREAK);
    }

    private void registerInfixOperator(String symbol, int precedence, boolean left) {
        this.validateOperator(symbol);
        this.infixOperators.put(symbol, new InfixOperatorToken(symbol, precedence, left));
    }

    private void registerPrefixOperator(String symbol, int precedence) {
        this.validateOperator(symbol);
        this.prefixOperators.put(symbol, new PrefixOperatorToken(symbol, precedence));
    }

    private void registerStatistic(String symbol, InformationType type) {
        this.statistics.put(symbol, new StatisticToken(type));
    }

    boolean isValidOperatorSymbol(char c) {
        return OPERATOR_SYMBOLS.indexOf(c) >= 0;
    }

    InfixOperatorToken getInfixOperator(String symbol) {
        return this.infixOperators.get(symbol);
    }

    PrefixOperatorToken getPrefixOperator(String symbol) {
        return this.prefixOperators.get(symbol);
    }

    StatisticToken getStatic(String symbol) {
        return this.statistics.get(symbol);
    }

    private void validateOperator(String symbol) {
        for (char c : symbol.toCharArray()) {
            if (this.isValidOperatorSymbol(c)) continue;
            throw new IllegalArgumentException("invalid operator symbol: " + c);
        }
    }
}

