/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.impl;

import java.io.File;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.impl.AbstractSQLConnection;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class SQLiteConnection
extends AbstractSQLConnection {
    private final String dbDatabase;

    public SQLiteConnection(String dbDatabase, String dbTable, String dbKillTable) {
        super(dbTable, dbKillTable);
        this.dbDatabase = dbDatabase;
    }

    @Override
    public boolean allowsAsync() {
        return false;
    }

    @Override
    public int cleanup(CommandSender sender) {
        return super.cleanup(sender, "rowid");
    }

    @Override
    public boolean connect(boolean printError) {
        try {
            File file = new File(PVPStats.getInstance().getDataFolder(), this.dbDatabase + ".db");
            if (file.exists()) {
                file.createNewFile();
            }
            this.databaseConnection = DriverManager.getConnection("jdbc:sqlite:" + file);
            this.collectPrecise = this.dbKillTable != null && !"".equals(this.dbKillTable);
            return this.databaseConnection != null;
        }
        catch (IOException | SQLException e) {
            if (printError) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean tableExists(String database, String table) {
        String query = "SELECT name FROM sqlite_master WHERE type='table' AND name='" + table + "'";
        try {
            ResultSet set = this.executeQuery(query, false);
            return set != null && set.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void createKillStatsTable(boolean printError) {
        String world = Bukkit.getServer().getWorlds().size() > 0 ? ((World)Bukkit.getServer().getWorlds().get(0)).getName() : "unknown";
        String query2 = "CREATE TABLE `" + this.dbKillTable + "` ( `name` varchar(42) NOT NULL, `uid` varchar(42), `victim` varchar(42), `victimuid` varchar(42), `kill` int(1) NOT NULL default 0,`time` int(16) not null default 0, `world` varchar(42) NOT NULL DEFAULT '" + world + "');";
        try {
            this.executeQuery(query2, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createStatsTable(boolean printError) {
        String query = "CREATE TABLE `" + this.dbTable + "` ( `name` varchar(42) NOT NULL, `uid` varchar(42), `kills` int(8) not null default 0, `deaths` int(8) not null default 0, `streak` int(8) not null default 0, `currentstreak` int(8) not null default 0, `elo` int(8) not null default 0, `time` int(16) not null default 0);";
        try {
            this.executeQuery(query, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

