/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.impl;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.slipcor.pvpstats.impl.AbstractSQLConnection;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class MySQLConnection
extends AbstractSQLConnection {
    private final String dbUrl;
    private final String dbUsername;
    private final String dbPassword;
    private final String dbOptions;

    public MySQLConnection(String host, int port, String database, String username, String password, String dbOptions, String dbTable, String dbKillTable) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(dbTable, dbKillTable);
        this.dbUrl = host + ":" + port + "/" + database;
        this.dbUsername = username;
        this.dbPassword = password;
        this.dbOptions = dbOptions;
    }

    @Override
    public boolean allowsAsync() {
        return true;
    }

    @Override
    public boolean connect(boolean printError) {
        try {
            this.databaseConnection = DriverManager.getConnection("jdbc:mysql://" + this.dbUrl + this.dbOptions, this.dbUsername, this.dbPassword);
            this.collectPrecise = this.dbKillTable != null && !"".equals(this.dbKillTable);
            return this.databaseConnection != null;
        }
        catch (SQLException e) {
            if (printError) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public int cleanup(CommandSender sender) {
        return super.cleanup(sender, "id");
    }

    @Override
    public boolean tableExists(String database, String table) {
        try {
            ResultSet result = this.databaseConnection.getMetaData().getTables(this.databaseConnection.getCatalog(), null, table, null);
            while (result.next()) {
                if (!result.getString("TABLE_NAME").equals(table)) continue;
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void createKillStatsTable(boolean printError) {
        String world = Bukkit.getServer().getWorlds().size() > 0 ? ((World)Bukkit.getServer().getWorlds().get(0)).getName() : "unknown";
        String query2 = "CREATE TABLE `" + this.dbKillTable + "` ( `id` int(16) NOT NULL AUTO_INCREMENT, `name` varchar(42) NOT NULL, `uid` varchar(42), `victim` varchar(42), `victimuid` varchar(42), `kill` int(1) not null default 0, `time` int(16) not null default 0, `world` varchar(42) not null default '" + world + "', PRIMARY KEY (`id`) ) AUTO_INCREMENT=1 ;";
        try {
            this.executeQuery(query2, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void createStatsTable(boolean printError) {
        String query = "CREATE TABLE `" + this.dbTable + "` ( `id` int(5) NOT NULL AUTO_INCREMENT, `name` varchar(42) NOT NULL, `uid` varchar(42), `kills` int(8) not null default 0, `deaths` int(8) not null default 0, `streak` int(8) not null default 0, `currentstreak` int(8) not null default 0, `elo` int(8) not null default 0, `time` int(16) not null default 0, PRIMARY KEY (`id`) ) AUTO_INCREMENT=1 ;";
        try {
            this.executeQuery(query, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

