/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.impl;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.DatabaseConnection;
import net.slipcor.pvpstats.classes.PlayerHandler;
import net.slipcor.pvpstats.classes.PlayerStatistic;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class FlatFileConnection
implements DatabaseConnection {
    private final String dbTable;
    private final String dbKillTable;
    private boolean collectPrecise = false;
    private FileConfiguration statConfig;
    private FileConfiguration killStatConfig;

    public FlatFileConnection(String dbTable, String dbKillTable) {
        this.dbTable = dbTable;
        this.dbKillTable = dbKillTable;
    }

    @Override
    public boolean allowsAsync() {
        return false;
    }

    @Override
    public int cleanup(CommandSender sender) {
        return 0;
    }

    @Override
    public boolean connect(boolean printError) {
        try {
            File file = new File(PVPStats.getInstance().getDataFolder(), this.dbTable + ".yml");
            if (!file.exists()) {
                file.createNewFile();
            }
            this.statConfig = new YamlConfiguration();
            this.statConfig.load(file);
            if (this.dbKillTable != null && !"".equals(this.dbKillTable)) {
                File killFile = new File(PVPStats.getInstance().getDataFolder(), this.dbKillTable + ".yml");
                if (!killFile.exists()) {
                    killFile.createNewFile();
                }
                this.killStatConfig = new YamlConfiguration();
                this.killStatConfig.load(killFile);
                this.collectPrecise = true;
            }
            return this.statConfig != null;
        }
        catch (IOException | InvalidConfigurationException e) {
            if (printError) {
                e.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean hasColumn(String tableName, String column) {
        return true;
    }

    @Override
    public boolean tableExists(String database, String table) {
        File file = new File(PVPStats.getInstance().getDataFolder(), table + ".yml");
        return file.exists();
    }

    @Override
    public void addWorldColumn() {
    }

    @Override
    public void addKillVictim() {
    }

    @Override
    public void addFirstStat(String playerName, UUID uuid, int kills, int deaths, int elo) {
        long time = System.currentTimeMillis() / 1000L;
        String root = uuid.toString() + ".";
        this.statConfig.set(root + "name", (Object)playerName);
        this.statConfig.set(root + "kills", (Object)kills);
        this.statConfig.set(root + "deaths", (Object)deaths);
        this.statConfig.set(root + "streak", (Object)kills);
        this.statConfig.set(root + "currentstreak", (Object)kills);
        this.statConfig.set(root + "elo", (Object)elo);
        this.statConfig.set(root + "time", (Object)time);
        this.save(this.statConfig, this.dbTable);
    }

    @Override
    public void addKill(String playerName, String uuid, String victimName, String victimUUID, String world) {
        if (!this.collectPrecise) {
            return;
        }
        long time = System.currentTimeMillis() / 1000L;
        StringBuilder root = new StringBuilder();
        root.append(uuid);
        root.append('.');
        root.append("kills.");
        root.append(time);
        if (uuid != null && !uuid.isEmpty()) {
            this.killStatConfig.set(root.toString() + ".killerName", (Object)playerName);
            this.killStatConfig.set(root.toString() + ".victimName", (Object)victimName);
            this.killStatConfig.set(root.toString() + ".victimUUID", (Object)victimUUID);
        }
        root = new StringBuilder();
        root.append(victimUUID);
        root.append('.');
        root.append("deaths.");
        root.append(time);
        if (victimUUID != null && !victimUUID.isEmpty()) {
            this.killStatConfig.set(root.toString() + ".killerName", (Object)playerName);
            this.killStatConfig.set(root.toString() + ".killerUUID", (Object)uuid);
            this.killStatConfig.set(root.toString() + ".victimName", (Object)victimName);
        }
        this.save(this.killStatConfig, this.dbKillTable);
    }

    @Override
    public void createKillStatsTable(boolean printError) {
        this.collectPrecise = true;
    }

    @Override
    public void createStatsTable(boolean printError) {
    }

    @Override
    public void deleteKills() {
        if (!this.collectPrecise) {
            return;
        }
        this.killStatConfig = new YamlConfiguration();
        this.save(this.killStatConfig, this.dbKillTable);
    }

    @Override
    public void deleteKillsByUUID(UUID uuid) {
        if (!this.collectPrecise) {
            return;
        }
        this.killStatConfig.set(uuid.toString(), null);
        this.save(this.killStatConfig, this.dbKillTable);
    }

    @Override
    public int deleteKillsOlderThan(long timestamp) {
        if (!this.collectPrecise) {
            return 0;
        }
        Map uuids = this.killStatConfig.getValues(false);
        ArrayList<String> removeables = new ArrayList<String>();
        for (String uuid : uuids.keySet()) {
            long time;
            ConfigurationSection player = this.killStatConfig.getConfigurationSection(uuid);
            Map kills = new HashMap();
            try {
                kills = player.getConfigurationSection("kills").getValues(false);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            Map deaths = new HashMap();
            try {
                deaths = player.getConfigurationSection("deaths").getValues(false);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            for (String key : kills.keySet()) {
                time = Long.parseLong(key);
                if (time >= timestamp) continue;
                removeables.add(uuid + ".kills." + key);
            }
            for (String key : deaths.keySet()) {
                time = Long.parseLong(key);
                if (time >= timestamp) continue;
                removeables.add(uuid + ".deaths." + key);
            }
        }
        for (String key : removeables) {
            this.killStatConfig.set(key, null);
        }
        this.save(this.killStatConfig, this.dbKillTable);
        return removeables.size();
    }

    @Override
    public void deleteStats() {
        this.statConfig = new YamlConfiguration();
        this.save(this.statConfig, this.dbTable);
    }

    @Override
    public void deleteStatsByUUID(UUID uuid) {
        this.statConfig.set(uuid.toString(), null);
        this.save(this.statConfig, this.dbTable);
    }

    @Override
    public int deleteStatsOlderThan(long timestamp) {
        ConfigurationSection root = this.statConfig.getConfigurationSection(this.statConfig.getCurrentPath());
        Map uuids = root.getValues(false);
        ArrayList<String> removeables = new ArrayList<String>();
        for (String uuid : uuids.keySet()) {
            ConfigurationSection player = root.getConfigurationSection(uuid);
            if (timestamp <= player.getLong("time", 0L)) continue;
            removeables.add(uuid);
        }
        for (String key : removeables) {
            this.statConfig.set(key, null);
        }
        this.save(this.statConfig, this.dbTable);
        return removeables.size();
    }

    @Override
    public OfflinePlayer findPlayer(String name) {
        String match = null;
        ConfigurationSection root = this.statConfig.getConfigurationSection(this.statConfig.getCurrentPath());
        Map uuids = root.getValues(false);
        for (String uuid : uuids.keySet()) {
            ConfigurationSection player = root.getConfigurationSection(uuid);
            if (player.getString("name").toLowerCase().contains(name.toLowerCase())) {
                match = uuid;
            }
            if (!player.getString("name").equalsIgnoreCase(name)) continue;
            break;
        }
        if (match == null) {
            return null;
        }
        return Bukkit.getOfflinePlayer((UUID)UUID.fromString(match));
    }

    @Override
    public List<PlayerStatistic> getAll() {
        ConfigurationSection root = this.statConfig.getConfigurationSection(this.statConfig.getCurrentPath());
        Map uuids = root.getValues(false);
        ArrayList<PlayerStatistic> result = new ArrayList<PlayerStatistic>();
        for (String uuid : uuids.keySet()) {
            ConfigurationSection player = root.getConfigurationSection(uuid);
            result.add(new PlayerStatistic(player.getString("name", ""), player.getInt("kills", 0), player.getInt("deaths", 0), player.getInt("streak", 0), player.getInt("currentstreak", 0), player.getInt("elo", 0), player.getLong("time", 0L), UUID.fromString(uuid)));
        }
        return result;
    }

    @Override
    public List<String> getNamesWithoutUUIDs() {
        return new ArrayList<String>();
    }

    @Override
    public int getStats(String stat, UUID uuid) {
        ConfigurationSection root = this.statConfig.getConfigurationSection(this.statConfig.getCurrentPath());
        ConfigurationSection player = root.getConfigurationSection(uuid.toString());
        if (player == null) {
            return 0;
        }
        return player.getInt(stat, 0);
    }

    @Override
    public PlayerStatistic getStats(OfflinePlayer offlinePlayer) {
        ConfigurationSection player = this.statConfig.getConfigurationSection(offlinePlayer.getUniqueId().toString());
        if (player == null) {
            return new PlayerStatistic(PlayerHandler.getPlayerName(offlinePlayer), 0, 0, 0, 0, 0, 0L, offlinePlayer.getUniqueId());
        }
        return new PlayerStatistic(player.getString("name", ""), player.getInt("kills", 0), player.getInt("deaths", 0), player.getInt("streak", 0), player.getInt("currentstreak", 0), player.getInt("elo", 0), player.getLong("time", 0L), offlinePlayer.getUniqueId());
    }

    @Override
    public List<UUID> getStatsUUIDs() {
        ArrayList<UUID> ids = new ArrayList<UUID>();
        ConfigurationSection root = this.statConfig.getConfigurationSection(this.statConfig.getCurrentPath());
        Map uuids = root.getValues(false);
        for (String uuid : uuids.keySet()) {
            ids.add(UUID.fromString(uuid));
        }
        return ids;
    }

    @Override
    public List<PlayerStatistic> getTopSorted(int amount, final String orderBy, final boolean ascending) {
        ConfigurationSection root = this.statConfig.getConfigurationSection(this.statConfig.getCurrentPath());
        Map uuids = root.getValues(false);
        ArrayList<PlayerStatistic> result = new ArrayList<PlayerStatistic>();
        for (String uuid : uuids.keySet()) {
            ConfigurationSection player = root.getConfigurationSection(uuid);
            result.add(new PlayerStatistic(player.getString("name", ""), player.getInt("kills", 0), player.getInt("deaths", 0), player.getInt("streak", 0), player.getInt("currentstreak", 0), player.getInt("elo", 0), player.getLong("time", 0L), UUID.fromString(uuid)));
        }
        class CustomComparator
        implements Comparator<PlayerStatistic> {
            CustomComparator() {
            }

            @Override
            public int compare(PlayerStatistic stat1, PlayerStatistic stat2) {
                switch (orderBy) {
                    case "kills": {
                        return (stat1.getKills() - stat2.getKills()) * (ascending ? 1 : -1);
                    }
                    case "deaths": {
                        return (stat1.getDeaths() - stat2.getDeaths()) * (ascending ? 1 : -1);
                    }
                    case "streak": {
                        return (stat1.getMaxStreak() - stat2.getMaxStreak()) * (ascending ? 1 : -1);
                    }
                    case "currentstreak": {
                        return (stat1.getCurrentStreak() - stat2.getCurrentStreak()) * (ascending ? 1 : -1);
                    }
                    case "elo": {
                        return (stat1.getELO() - stat2.getELO()) * (ascending ? 1 : -1);
                    }
                }
                return (stat1.getKills() / (stat1.getDeaths() + 1) - stat2.getKills() / (stat2.getDeaths() + 1)) * (ascending ? 1 : -1);
            }
        }
        Collections.sort(result, new CustomComparator());
        return result.size() > amount ? result.subList(0, amount) : result;
    }

    @Override
    public List<PlayerStatistic> getTopWorldSorted(int amount, String orderBy, String world, int days) throws SQLException {
        return this.getTopPlusSorted(amount, orderBy, days);
    }

    @Override
    public List<PlayerStatistic> getTopPlusSorted(int amount, String orderBy, int days) throws SQLException {
        long queryTime = System.currentTimeMillis() / 1000L - (long)(days * 86400);
        ConfigurationSection root = this.killStatConfig.getConfigurationSection(this.killStatConfig.getCurrentPath());
        Map uuids = root.getValues(false);
        ArrayList<PlayerStatistic> result = new ArrayList<PlayerStatistic>();
        for (String uuid : uuids.keySet()) {
            int deathCount = 0;
            int killCount = 0;
            ConfigurationSection player = root.getConfigurationSection(uuid);
            ConfigurationSection deathSection = player.getConfigurationSection("deaths");
            Map deaths = deathSection.getValues(false);
            long latest = 0L;
            String name = "";
            UUID uid = UUID.fromString(uuid);
            for (String timeString : deaths.keySet()) {
                Long time = Long.parseLong(timeString);
                if (time <= queryTime) continue;
                ++deathCount;
                if (time <= latest) continue;
                time = latest;
                name = deathSection.getString(timeString + ".victimName");
            }
            ConfigurationSection killSection = player.getConfigurationSection("kills");
            Map kills = killSection.getValues(false);
            for (String timeString : kills.keySet()) {
                Long time = Long.parseLong(timeString);
                if (time <= queryTime) continue;
                ++killCount;
                if (time <= latest) continue;
                time = latest;
                name = deathSection.getString(timeString + ".killerName");
            }
            result.add(new PlayerStatistic(name, killCount, deathCount, 0, 0, 0, 0L, uid));
        }
        if (orderBy.equals("KILLS")) {
            Collections.sort(result, Comparator.comparingInt(PlayerStatistic::getKills).reversed());
        } else if (orderBy.equals("DEATHS")) {
            Collections.sort(result, Comparator.comparingInt(PlayerStatistic::getDeaths).reversed());
        } else {
            Collections.sort(result, Comparator.comparingDouble(PlayerStatistic::getRatio).reversed());
        }
        while (result.size() > amount) {
            result.remove(amount);
        }
        return result;
    }

    @Override
    public boolean hasEntry(UUID uuid) {
        return !this.statConfig.getString(uuid.toString() + ".name", "").equals("");
    }

    @Override
    public void increaseDeaths(String name, UUID uuid, int elo) {
        long time = System.currentTimeMillis() / 1000L;
        String root = uuid.toString() + ".";
        this.statConfig.set(root + "deaths", (Object)(this.statConfig.getInt(root + "deaths", 0) + 1));
        this.statConfig.set(root + "elo", (Object)elo);
        this.statConfig.set(root + "currentstreak", (Object)0);
        this.statConfig.set(root + "time", (Object)time);
        this.statConfig.set(root + "name", (Object)name);
        this.save(this.statConfig, this.dbTable);
    }

    @Override
    public void increaseKillsAndMaxStreak(String name, UUID uuid, int elo) {
        long time = System.currentTimeMillis() / 1000L;
        String root = uuid.toString() + ".";
        this.statConfig.set(root + "kills", (Object)(this.statConfig.getInt(root + "kills", 0) + 1));
        this.statConfig.set(root + "elo", (Object)elo);
        this.statConfig.set(root + "streak", (Object)(this.statConfig.getInt(root + "streak", 0) + 1));
        this.statConfig.set(root + "currentstreak", (Object)(this.statConfig.getInt(root + "currentstreak", 0) + 1));
        this.statConfig.set(root + "time", (Object)time);
        this.statConfig.set(root + "name", (Object)name);
        this.save(this.statConfig, this.dbTable);
    }

    @Override
    public void increaseKillsAndStreak(String name, UUID uuid, int elo) {
        long time = System.currentTimeMillis() / 1000L;
        String root = uuid.toString() + ".";
        this.statConfig.set(root + "kills", (Object)(this.statConfig.getInt(root + "kills", 0) + 1));
        this.statConfig.set(root + "elo", (Object)elo);
        this.statConfig.set(root + "currentstreak", (Object)(this.statConfig.getInt(root + "currentstreak", 0) + 1));
        this.statConfig.set(root + "time", (Object)time);
        this.statConfig.set(root + "name", (Object)name);
        this.save(this.statConfig, this.dbTable);
    }

    @Override
    public void insert(PlayerStatistic stat) {
        String root = stat.getUid() + ".";
        int count = 0;
        try {
            count = this.statConfig.getConfigurationSection(this.statConfig.getCurrentPath()).getValues(false).keySet().size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.statConfig.set(root + "oid", (Object)(++count));
        this.statConfig.set(root + "name", (Object)stat.getName());
        this.statConfig.set(root + "kills", (Object)stat.getKills());
        this.statConfig.set(root + "deaths", (Object)stat.getDeaths());
        this.statConfig.set(root + "streak", (Object)stat.getMaxStreak());
        this.statConfig.set(root + "currentstreak", (Object)stat.getCurrentStreak());
        this.statConfig.set(root + "elo", (Object)stat.getELO());
        this.statConfig.set(root + "time", (Object)stat.getTime());
        this.save(this.statConfig, this.dbTable);
    }

    @Override
    public boolean isConnected() {
        return this.statConfig != null;
    }

    private void save(FileConfiguration config, String filename) {
        File file = new File(PVPStats.getInstance().getDataFolder(), filename + ".yml");
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setSpecificStat(UUID uuid, String entry, int value) {
        this.statConfig.set(uuid.toString() + "." + entry, (Object)value);
        this.save(this.statConfig, this.dbTable);
    }

    @Override
    public void setStatUIDByPlayer(OfflinePlayer player) {
    }
}

