/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.DatabaseConnection;
import net.slipcor.pvpstats.classes.PlayerHandler;
import net.slipcor.pvpstats.classes.PlayerStatistic;
import net.slipcor.pvpstats.impl.SQLiteConnection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class AbstractSQLConnection
implements DatabaseConnection {
    final String dbTable;
    final String dbKillTable;
    Connection databaseConnection;
    boolean collectPrecise = false;

    AbstractSQLConnection(String dbTable, String dbKillTable) {
        this.dbTable = dbTable;
        this.dbKillTable = dbKillTable;
    }

    protected ResultSet executeQuery(String query, boolean modifies) throws SQLException {
        Statement statement = this.databaseConnection.createStatement();
        if (modifies) {
            statement.execute(query);
            return null;
        }
        return statement.executeQuery(query);
    }

    @Override
    public boolean hasColumn(String tableName, String column) {
        try {
            ResultSet result = this.executeQuery("SELECT `" + column + "` FROM `" + tableName + "` WHERE 1 LIMIT 1", false);
            result.next();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void addWorldColumn() {
        try {
            String world = Bukkit.getServer().getWorlds().size() > 0 ? ((World)Bukkit.getServer().getWorlds().get(0)).getName() : "unknown";
            this.executeQuery("ALTER TABLE `" + this.dbKillTable + "` ADD `world` varchar(42) NOT NULL DEFAULT '" + world + "';", true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void addKillVictim() {
        try {
            this.executeQuery("ALTER TABLE `" + this.dbKillTable + "` ADD `victim` varchar(42);", true);
            this.executeQuery("ALTER TABLE `" + this.dbKillTable + "` ADD `victimuid` varchar(42);", true);
            if (this instanceof SQLiteConnection) {
                this.executeQuery("ALTER TABLE `" + this.dbKillTable + "` ADD `time` int(16) not null default 0;", true);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void addFirstStat(String playerName, UUID uuid, int kills, int deaths, int elo) {
        long time = System.currentTimeMillis() / 1000L;
        try {
            this.executeQuery("INSERT INTO `" + this.dbTable + "` (`name`, `uid`, `kills`,`deaths`,`streak`,`currentstreak`,`elo`,`time`) VALUES ('" + playerName + "', '" + uuid + "', " + kills + ", " + deaths + ", " + kills + ", " + kills + ", " + elo + ", " + time + ")", true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void addKill(String playerName, String uuid, String victimName, String victimUUID, String world) {
        if (!this.collectPrecise) {
            return;
        }
        long time = System.currentTimeMillis() / 1000L;
        try {
            this.executeQuery("INSERT INTO " + this.dbKillTable + " (`name`,`uid`,`victim`,`victimuid`,`time`,`world`) VALUES('" + playerName + "', '" + uuid + "', '" + victimName + "', '" + victimUUID + "', " + time + ", '" + world + "')", true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected int cleanup(CommandSender sender, String rowid) {
        String query = "SELECT `" + rowid + "`, `uid` FROM " + this.dbTable + " WHERE 1 ORDER BY `kills` DESC;";
        ArrayList<Integer> ids = new ArrayList<Integer>();
        HashSet<String> uids = new HashSet<String>();
        try {
            ResultSet result = this.executeQuery(query, false);
            while (result != null && result.next()) {
                String uid = result.getString("uid");
                if (uids.contains(uid)) {
                    ids.add(result.getInt(rowid));
                    continue;
                }
                uids.add(uid);
            }
            if (ids.size() > 0) {
                StringBuilder buffer = new StringBuilder("DELETE FROM `");
                buffer.append(this.dbTable);
                buffer.append("` WHERE `");
                buffer.append(rowid);
                buffer.append("` IN (-1");
                for (Integer i : ids) {
                    buffer.append(',');
                    buffer.append(i);
                }
                buffer.append(");");
                this.executeQuery(buffer.toString(), true);
            }
            return ids.size();
        }
        catch (SQLException e) {
            System.out.println("Error while cleaning up. Please send this to slipcor:");
            e.printStackTrace();
            if (sender instanceof Player) {
                PVPStats.getInstance().sendPrefixed(sender, ChatColor.RED + "There was an error trying to clean up. Please see the logfile!");
            }
            return -1;
        }
    }

    @Override
    public void deleteKills() {
        if (!this.collectPrecise) {
            return;
        }
        try {
            this.executeQuery("DELETE FROM `" + this.dbKillTable + "` WHERE 1;", true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void deleteKillsByUUID(UUID uuid) {
        if (!this.collectPrecise) {
            return;
        }
        try {
            this.executeQuery("DELETE FROM `" + this.dbKillTable + "` WHERE `uid` = '" + uuid + "';", true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public int deleteKillsOlderThan(long timestamp) throws SQLException {
        if (!this.collectPrecise) {
            return 0;
        }
        int count = 0;
        ResultSet result = this.executeQuery("SELECT `time` FROM `" + this.dbKillTable + "` WHERE `time` < " + timestamp + ";", false);
        while (result.next()) {
            ++count;
        }
        this.executeQuery("DELETE FROM `" + this.dbKillTable + "` WHERE `time` < " + timestamp + ";", true);
        return count;
    }

    @Override
    public void deleteStats() {
        try {
            this.executeQuery("DELETE FROM `" + this.dbTable + "` WHERE 1;", true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void deleteStatsByUUID(UUID uuid) {
        try {
            this.executeQuery("DELETE FROM `" + this.dbTable + "` WHERE `uid` = '" + uuid + "';", true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public int deleteStatsOlderThan(long timestamp) throws SQLException {
        int count = 0;
        ResultSet result = this.executeQuery("SELECT `time` FROM `" + this.dbTable + "` WHERE `time` < " + timestamp + ";", false);
        while (result.next()) {
            ++count;
        }
        this.executeQuery("DELETE FROM `" + this.dbTable + "` WHERE `time` < " + timestamp + ";", true);
        return count;
    }

    @Override
    public OfflinePlayer findPlayer(String name) {
        try {
            PreparedStatement statement = this.databaseConnection.prepareStatement("SELECT `name`, `uid` FROM " + this.dbTable + " WHERE `name` LIKE ?;");
            statement.setString(1, "%" + name + "%");
            ResultSet result = statement.executeQuery();
            String match = null;
            UUID matchUUID = null;
            while (result.next()) {
                String rowName = result.getString("name");
                String rowUUID = result.getString("uid");
                if (rowUUID != null && !rowUUID.isEmpty()) {
                    matchUUID = UUID.fromString(rowUUID);
                }
                if (!(match = rowName).equalsIgnoreCase(name)) continue;
                break;
            }
            if (matchUUID != null) {
                return Bukkit.getOfflinePlayer(matchUUID);
            }
            if (match != null) {
                return Bukkit.getOfflinePlayer(match);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<PlayerStatistic> getAll() throws SQLException {
        String query = "SELECT `name`,`kills`,`deaths`,`streak`,`currentstreak`,`elo`,`time`,`uid` FROM `" + this.dbTable + "` WHERE 1;";
        ArrayList<PlayerStatistic> list = new ArrayList<PlayerStatistic>();
        ResultSet result = this.executeQuery(query, false);
        if (result == null) {
            return null;
        }
        while (result.next()) {
            list.add(new PlayerStatistic(result.getString("name"), result.getInt("kills"), result.getInt("deaths"), result.getInt("streak"), result.getInt("currentstreak"), result.getInt("elo"), result.getLong("time"), UUID.fromString(result.getString("uid"))));
        }
        return list;
    }

    @Override
    public int getStats(String stat, UUID uuid) throws SQLException {
        ResultSet result = this.executeQuery("SELECT `" + stat + "` FROM `" + this.dbTable + "` WHERE `uid` = '" + uuid + "' LIMIT 1;", false);
        return result != null && result.next() ? result.getInt(stat) : -1;
    }

    @Override
    public PlayerStatistic getStats(OfflinePlayer offlinePlayer) throws SQLException {
        ResultSet result = this.executeQuery("SELECT `name`,`kills`,`deaths`,`streak`,`currentstreak`, `elo`,`time`,`uid` FROM `" + this.dbTable + "` WHERE `uid` = '" + offlinePlayer.getUniqueId() + "' LIMIT 1;", false);
        if (result.next()) {
            return new PlayerStatistic(result.getString("name"), result.getInt("kills"), result.getInt("deaths"), result.getInt("streak"), result.getInt("currentstreak"), result.getInt("elo"), result.getInt("time"), UUID.fromString(result.getString("uid")));
        }
        return new PlayerStatistic(PlayerHandler.getPlayerName(offlinePlayer), 0, 0, 0, 0, 0, 0L, offlinePlayer.getUniqueId());
    }

    @Override
    public List<String> getNamesWithoutUUIDs() throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        ResultSet result = this.executeQuery("SELECT `name` FROM `" + this.dbTable + "` WHERE `uid` = '';", false);
        while (result.next()) {
            list.add(result.getString("name"));
        }
        return list;
    }

    @Override
    public List<UUID> getStatsUUIDs() throws SQLException {
        ArrayList<UUID> ids = new ArrayList<UUID>();
        ResultSet result = this.executeQuery("SELECT `uid` FROM `" + this.dbTable + "` WHERE 1;", false);
        while (result.next()) {
            ids.add(UUID.fromString(result.getString("uid")));
        }
        return ids;
    }

    @Override
    public List<PlayerStatistic> getTopWorldSorted(int amount, String orderBy, String world, int days) throws SQLException {
        ArrayList<PlayerStatistic> list = new ArrayList<PlayerStatistic>();
        long queryTime = System.currentTimeMillis() / 1000L - (long)(days * 86400);
        ResultSet result = this.executeQuery("SELECT * FROM " + this.dbKillTable + " WHERE `time` > " + queryTime + " ORDER BY `time` DESC", false);
        if (result == null) {
            return null;
        }
        HashMap<UUID, PlayerStatistic> players = new HashMap<UUID, PlayerStatistic>();
        while (result.next()) {
            UUID victimUID;
            UUID killerUID;
            if (!result.getString("world").equals(world) || (killerUID = UUID.fromString(result.getString("uid"))).equals(victimUID = UUID.fromString(result.getString("victimuid")))) continue;
            if (players.containsKey(killerUID)) {
                ((PlayerStatistic)players.get(killerUID)).addKill();
            } else {
                players.put(killerUID, new PlayerStatistic(result.getString("name"), 1, 0, 0, 0, 0, 0L, killerUID));
            }
            if (players.containsKey(victimUID)) {
                ((PlayerStatistic)players.get(victimUID)).addDeath();
                continue;
            }
            players.put(victimUID, new PlayerStatistic(result.getString("victim"), 0, 1, 0, 0, 0, 0L, victimUID));
        }
        list.addAll(players.values());
        if (orderBy.equals("KILLS")) {
            Collections.sort(list, Comparator.comparingInt(PlayerStatistic::getKills).reversed());
        } else if (orderBy.equals("DEATHS")) {
            Collections.sort(list, Comparator.comparingInt(PlayerStatistic::getDeaths).reversed());
        } else {
            Collections.sort(list, Comparator.comparingDouble(PlayerStatistic::getRatio).reversed());
        }
        while (list.size() > amount) {
            list.remove(amount);
        }
        return list;
    }

    @Override
    public List<PlayerStatistic> getTopPlusSorted(int amount, String orderBy, int days) throws SQLException {
        ArrayList<PlayerStatistic> list = new ArrayList<PlayerStatistic>();
        long queryTime = System.currentTimeMillis() / 1000L - (long)(days * 86400);
        ResultSet result = this.executeQuery("SELECT * FROM " + this.dbKillTable + " WHERE `time` > " + queryTime + " ORDER BY `time` DESC", false);
        if (result == null) {
            return null;
        }
        HashMap<UUID, PlayerStatistic> players = new HashMap<UUID, PlayerStatistic>();
        while (result.next()) {
            UUID victimUID;
            UUID killerUID = UUID.fromString(result.getString("uid"));
            if (killerUID.equals(victimUID = UUID.fromString(result.getString("victimuid")))) continue;
            if (players.containsKey(killerUID)) {
                ((PlayerStatistic)players.get(killerUID)).addKill();
            } else {
                players.put(killerUID, new PlayerStatistic(result.getString("name"), 1, 0, 0, 0, 0, 0L, killerUID));
            }
            if (players.containsKey(victimUID)) {
                ((PlayerStatistic)players.get(victimUID)).addDeath();
                continue;
            }
            players.put(victimUID, new PlayerStatistic(result.getString("victim"), 0, 1, 0, 0, 0, 0L, victimUID));
        }
        list.addAll(players.values());
        if (orderBy.equals("KILLS")) {
            Collections.sort(list, Comparator.comparingInt(PlayerStatistic::getKills).reversed());
        } else if (orderBy.equals("DEATHS")) {
            Collections.sort(list, Comparator.comparingInt(PlayerStatistic::getDeaths).reversed());
        } else {
            Collections.sort(list, Comparator.comparingDouble(PlayerStatistic::getRatio).reversed());
        }
        while (list.size() > amount) {
            list.remove(amount);
        }
        return list;
    }

    @Override
    public List<PlayerStatistic> getTopSorted(int amount, String orderBy, boolean ascending) throws SQLException {
        String query = "SELECT `name`,`kills`,`deaths`,`streak`,`currentstreak`,`elo`,`time`,`uid` FROM `" + this.dbTable + "` WHERE 1 ORDER BY `" + orderBy + "` " + (ascending ? "ASC" : "DESC") + " LIMIT " + amount + ";";
        if (orderBy.contains("`")) {
            query = "SELECT `name`,`kills`,`deaths`,`streak`,`currentstreak`,`elo`,`time`,`uid` FROM `" + this.dbTable + "` WHERE 1 ORDER BY " + orderBy + " " + (ascending ? "ASC" : "DESC") + " LIMIT " + amount + ";";
        }
        ArrayList<PlayerStatistic> list = new ArrayList<PlayerStatistic>();
        ResultSet result = this.executeQuery(query, false);
        if (result == null) {
            return null;
        }
        while (result.next()) {
            list.add(new PlayerStatistic(result.getString("name"), result.getInt("kills"), result.getInt("deaths"), result.getInt("streak"), result.getInt("currentstreak"), result.getInt("elo"), result.getInt("time"), UUID.fromString(result.getString("uid"))));
        }
        return list;
    }

    @Override
    public boolean hasEntry(UUID uuid) {
        try {
            ResultSet result = this.executeQuery("SELECT * FROM `" + this.dbTable + "` WHERE `uid` = '" + uuid + "';", false);
            return result != null && result.next();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public void increaseDeaths(String name, UUID uuid, int elo) {
        long time = System.currentTimeMillis() / 1000L;
        try {
            this.executeQuery("UPDATE `" + this.dbTable + "` SET `name` = '" + name + "', `deaths` = `deaths`+1, `elo` = " + elo + ", `currentstreak` = 0, `time` = " + time + " WHERE `uid` = '" + uuid + "'", true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void increaseKillsAndMaxStreak(String name, UUID uuid, int elo) {
        long time = System.currentTimeMillis() / 1000L;
        try {
            this.executeQuery("UPDATE `" + this.dbTable + "` SET `name` = '" + name + "', `kills` = `kills`+1, `elo` = '" + elo + "', `streak` = `streak`+1, `currentstreak` = `currentstreak`+1, `time` = " + time + " WHERE `uid` = '" + uuid + "'", true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void increaseKillsAndStreak(String name, UUID uuid, int elo) {
        long time = System.currentTimeMillis() / 1000L;
        try {
            this.executeQuery("UPDATE `" + this.dbTable + "` SET `name` = '" + name + "', `kills` = `kills`+1, `elo` = '" + elo + "', `currentstreak` = `currentstreak`+1, `time` = " + time + " WHERE `uid` = '" + uuid + "'", true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void insert(PlayerStatistic stat) throws SQLException {
        this.executeQuery("INSERT INTO `" + this.dbTable + "` (`name`, `uid`, `kills`,`deaths`,`streak`,`currentstreak`,`elo`,`time`) VALUES ('" + stat.getName() + "', '" + stat.getUid() + "', " + stat.getKills() + ", " + stat.getDeaths() + ", " + stat.getMaxStreak() + ", " + stat.getCurrentStreak() + ", " + stat.getELO() + ", " + stat.getTime() + ")", true);
    }

    @Override
    public boolean isConnected() {
        return this.databaseConnection != null;
    }

    @Override
    public void setSpecificStat(UUID uuid, String entry, int value) throws SQLException {
        this.executeQuery("UPDATE `" + this.dbTable + "` SET `" + entry + "` = " + value + " WHERE `uid` = '" + uuid.toString() + "';", true);
    }

    @Override
    public void setStatUIDByPlayer(OfflinePlayer player) throws SQLException {
        this.executeQuery("UPDATE `" + this.dbTable + "` SET `uid` = '" + player.getUniqueId() + "' WHERE `uid` = '" + player.getUniqueId() + "';", true);
    }
}

