/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.display;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.DatabaseAPI;
import net.slipcor.pvpstats.api.InformationType;
import net.slipcor.pvpstats.core.CoreDebugger;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Directional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class SignDisplay {
    static final List<SignDisplay> DISPLAYS = new ArrayList<SignDisplay>();
    private final BlockFace direction;
    private final Location location;
    private int signCount = 0;
    public static CoreDebugger debugger;
    Map<Integer, List<Location>> signMap = new LinkedHashMap<Integer, List<Location>>();
    Map<Integer, InformationType> columns = new LinkedHashMap<Integer, InformationType>();
    private InformationType column = InformationType.DEATHS;

    public SignDisplay(Location location, BlockFace face) {
        this.location = location;
        this.direction = face;
        this.discover();
    }

    public static SignDisplay byLocation(Location location) {
        for (SignDisplay display : DISPLAYS) {
            if (!display.location.getBlock().equals(location.getBlock())) continue;
            return display;
        }
        return null;
    }

    public static SignDisplay init(Location location) {
        SignDisplay display = null;
        if (location.getBlock().getState() instanceof Sign) {
            String line = ((Sign)location.getBlock().getState()).getLine(0);
            if (line == null || !line.toLowerCase().contains("pvpstats")) {
                debugger.i("Does not contain PVP Stats: " + line);
                return null;
            }
            BlockFace face = SignDisplay.getPerpendicular(((Directional)location.getBlock().getBlockData()).getFacing());
            if (face != null) {
                display = new SignDisplay(location, face);
                if (display.isValid()) {
                    debugger.i("Display is valid");
                    DISPLAYS.add(display);
                } else {
                    debugger.i("Display is invalid");
                }
            }
        }
        return display;
    }

    private static BlockFace getPerpendicular(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
        }
        return null;
    }

    public static void updateAll() {
        for (final SignDisplay display : DISPLAYS) {
            Bukkit.getScheduler().runTask((Plugin)PVPStats.getInstance(), new Runnable(){

                @Override
                public void run() {
                    display.update();
                }
            });
        }
    }

    public static void loadAllDisplays() {
        DISPLAYS.clear();
        FileConfiguration config = PVPStats.getInstance().getConfig();
        ConfigurationSection cs = config.getConfigurationSection("leaderboards");
        if (cs == null) {
            return;
        }
        for (String key : cs.getKeys(false)) {
            SignDisplay display;
            Location loc = SignDisplay.locationFromString(cs.getString(key));
            if (loc == null || (display = SignDisplay.init(loc)) == null || !display.isValid()) continue;
            InformationType column = SignDisplay.getSortColumn(key);
            if (column == null) {
                column = InformationType.NAME;
            }
            display.column = column;
        }
        PVPStats.getInstance().getLogger().info(DISPLAYS.size() + " leaderboards loaded!");
        for (SignDisplay display : DISPLAYS) {
            display.update();
        }
    }

    public static void saveAllDisplays() {
        PVPStats.getInstance().getConfig().set("leaderboards", null);
        int position = 0;
        for (SignDisplay display : DISPLAYS) {
            debugger.i("Saving display: " + (Object)((Object)display.column));
            PVPStats.getInstance().getConfig().set("leaderboards." + (Object)((Object)display.column) + position++, (Object)SignDisplay.locationToString(display.location));
        }
        try {
            PVPStats.getInstance().getConfig().save(new File(PVPStats.getInstance().getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            PVPStats.getInstance().getLogger().severe("Could not save leaderboards to config!");
            e.printStackTrace();
        }
        PVPStats.getInstance().config().appendComments();
    }

    private static Location locationFromString(String value) {
        try {
            String[] colon = value.split(":");
            World world = Bukkit.getWorld((String)colon[0]);
            String[] ints = colon[1].split(",");
            Location result = world.getBlockAt(Integer.parseInt(ints[0]), Integer.parseInt(ints[1]), Integer.parseInt(ints[2])).getLocation();
            return result;
        }
        catch (Exception e) {
            PVPStats.getInstance().getLogger().severe("Could not parse location: " + value);
            e.printStackTrace();
            return null;
        }
    }

    private static String locationToString(Location location) {
        StringBuilder builder = new StringBuilder();
        builder.append(location.getWorld().getName());
        builder.append(':');
        builder.append(location.getBlockX());
        builder.append(',');
        builder.append(location.getBlockY());
        builder.append(',');
        builder.append(location.getBlockZ());
        return builder.toString();
    }

    public static boolean needsProtection(Location location) {
        for (SignDisplay display : DISPLAYS) {
            for (List<Location> locs : display.signMap.values()) {
                for (Location loc : locs) {
                    if (!loc.getWorld().equals(location.getWorld()) || !(loc.distanceSquared(location) < 4.0)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void discover() {
        int offsetSide = 0;
        int offsetDown = 0;
        debugger.i("discovering sign matrix!");
        Block checkBlock = this.location.getBlock();
        this.signCount = 0;
        while (checkBlock.getRelative(this.direction, offsetSide).getState() instanceof Sign || checkBlock.getRelative(this.direction, offsetSide + 1).getState() instanceof Sign) {
            InformationType sorting;
            debugger.i("we found a sign");
            ArrayList<Location> signs = new ArrayList<Location>();
            if (!(checkBlock.getRelative(this.direction, offsetSide).getState() instanceof Sign)) {
                ++offsetSide;
            }
            debugger.i("offsetSide: " + offsetSide);
            Sign sign = (Sign)checkBlock.getRelative(BlockFace.DOWN, offsetDown).getRelative(this.direction, offsetSide).getState();
            InformationType informationType = sorting = offsetSide > 0 ? this.getSortColumn(sign) : InformationType.NAME;
            if (sorting == null) {
                ++offsetSide;
                debugger.i("sorting is null!");
                continue;
            }
            debugger.i("sorting: " + (Object)((Object)sorting));
            this.columns.put(offsetSide, sorting);
            ++offsetDown;
            while (checkBlock.getRelative(BlockFace.DOWN, offsetDown).getRelative(this.direction, offsetSide).getState() instanceof Sign) {
                debugger.i("discovering " + offsetSide + " - " + offsetDown);
                signs.add(checkBlock.getRelative(BlockFace.DOWN, offsetDown).getRelative(this.direction, offsetSide).getLocation());
                ++offsetDown;
            }
            this.signMap.put(offsetSide, signs);
            this.signCount = Math.max(this.signCount, signs.size());
            debugger.i("signCount: " + this.signCount);
            ++offsetSide;
            offsetDown = 0;
        }
    }

    private InformationType getSortColumn(Sign sign) {
        for (String s : sign.getLines()) {
            if (s == null) continue;
            for (InformationType c : InformationType.values()) {
                if (!s.toUpperCase().contains(c.name())) continue;
                return c;
            }
        }
        return null;
    }

    private static InformationType getSortColumn(String string) {
        for (InformationType c : InformationType.values()) {
            if (!string.toUpperCase().contains(c.name())) continue;
            return c;
        }
        return null;
    }

    public boolean isValid() {
        return this.signCount > 1 && this.signMap.size() > 1;
    }

    private void update() {
        List<Map<InformationType, String>> entries = DatabaseAPI.detailedTop(this.signCount * 4, this.column);
        if (!(this.location.getBlock().getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)this.location.getBlock().getState();
        sign.setLine(1, Language.MSG.SIGN_SORTED_BY.parse());
        sign.setLine(2, Language.MSG.SIGN_SORTED_COLUMN.parse(this.column.name()));
        sign.update();
        if (entries.size() < 1) {
            debugger.i("No entries!");
            return;
        }
        for (Integer key : this.columns.keySet()) {
            debugger.i("column ID " + key);
            InformationType informationType = this.columns.get(key);
            List<Location> signs = this.signMap.get(key);
            this.writeEntryToSigns(signs, informationType, entries);
        }
    }

    private void writeEntryToSigns(List<Location> signs, InformationType column, List<Map<InformationType, String>> entries) {
        int signPos = -1;
        for (Location loc : signs) {
            debugger.i("sign position " + ++signPos);
            if (!(loc.getBlock().getState() instanceof Sign)) continue;
            Sign sign = (Sign)loc.getBlock().getState();
            debugger.i("we have a sign!");
            for (int i = signPos * 4; i < (signPos + 1) * 4; ++i) {
                debugger.i("i: " + i);
                if (entries.size() <= i) {
                    debugger.i("no more entries - " + entries.size() + " >= " + i);
                    break;
                }
                debugger.i("trying to set to : " + entries.get(i).get((Object)column));
                sign.setLine(i % 4, entries.get(i).get((Object)column));
            }
            sign.update();
        }
    }

    public InformationType getSortColumn() {
        return this.column;
    }

    public void cycleSortColumn() {
        int ordinal = this.column.ordinal();
        if (++ordinal >= InformationType.values().length) {
            ordinal = 1;
        }
        this.column = InformationType.values()[ordinal];
        this.update();
    }
}

