/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import net.slipcor.pvpstats.core.ConfigEntry;
import net.slipcor.pvpstats.core.CorePlugin;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CoreUpdater
extends Thread {
    private final UpdateMode mode;
    private final UpdateType type;
    private final CorePlugin plugin;
    private final File file;
    private final int major;
    private final int minor;
    private UpdateInstance instance = null;
    private String defaultURL;

    public CoreUpdater(CorePlugin plugin, File file, String pluginName, String defaultURL, ConfigEntry updateModeConfig, ConfigEntry updateTypeConfig) {
        int b;
        int a;
        String[] chunks;
        this.defaultURL = defaultURL;
        String version = Bukkit.getServer().getBukkitVersion();
        try {
            chunks = version.split("-")[0].split("\\.");
        }
        catch (Exception e) {
            chunks = new String[]{"1", "11"};
        }
        try {
            a = Integer.parseInt(chunks[0]);
        }
        catch (Exception e) {
            a = 1;
        }
        this.major = a;
        try {
            b = Integer.parseInt(chunks[1]);
        }
        catch (Exception e) {
            b = 9;
        }
        this.minor = b;
        this.plugin = plugin;
        this.file = file;
        this.mode = UpdateMode.getBySetting(plugin.config().getString(updateModeConfig));
        if (this.mode == UpdateMode.OFF) {
            this.type = UpdateType.RELEASE;
            plugin.getLogger().info("Updates deactivated. Please check spigotmc.org for updates");
        } else {
            this.type = UpdateType.getBySetting(plugin.config().getString(updateTypeConfig));
            this.instance = new UpdateInstance(pluginName);
            this.start();
        }
    }

    private void message(final CommandSender sender, UpdateInstance instance) {
        block10: {
            try {
                if (!instance.outdated) break block10;
                boolean error = false;
                if (!(sender instanceof Player) && this.mode != UpdateMode.ANNOUNCE) {
                    File pluginFile;
                    File updateFolder = Bukkit.getServer().getUpdateFolderFile();
                    if (!updateFolder.exists()) {
                        updateFolder.mkdirs();
                    }
                    if ((pluginFile = new File(updateFolder, this.file.getName())).exists()) {
                        pluginFile.delete();
                    }
                    try {
                        URL url = new URL(instance.url);
                        ReadableByteChannel rbc = Channels.newChannel(url.openStream());
                        FileOutputStream output = new FileOutputStream(pluginFile);
                        output.getChannel().transferFrom(rbc, 0L, 0x1000000L);
                        output.close();
                    }
                    catch (IOException exception) {
                        error = true;
                    }
                }
                if (this.mode != UpdateMode.DOWNLOAD || error || !(sender instanceof Player)) {
                    this.plugin.sendPrefixed(sender, String.format("You are using %s, an outdated version! Latest %s build: %sv%s", instance.colorize('v' + instance.vThis), instance.colorizeUpgradeType(), ChatColor.GREEN, instance.vOnline));
                }
                if (this.mode == UpdateMode.ANNOUNCE) {
                    this.plugin.sendPrefixed(sender, instance.url);
                } else {
                    final boolean finalError = error;
                    class RunLater
                    implements Runnable {
                        RunLater() {
                        }

                        @Override
                        public void run() {
                            if (finalError) {
                                CoreUpdater.this.plugin.sendPrefixed(sender, "The plugin could not updated, download the new version here: " + CoreUpdater.this.defaultURL);
                            } else {
                                CoreUpdater.this.plugin.sendPrefixed(sender, "The plugin has been updated, please restart the server!");
                            }
                        }
                    }
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, (Runnable)new RunLater(), 60L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void message(final CommandSender player) {
        class DownloadLater
        implements Runnable {
            DownloadLater() {
            }

            @Override
            public void run() {
                if (CoreUpdater.this.instance != null) {
                    CoreUpdater.this.message(player, CoreUpdater.this.instance);
                }
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)new DownloadLater());
    }

    @Override
    public void run() {
        if (this.mode == null || this.mode == UpdateMode.OFF) {
            this.plugin.getLogger().info("Updates deactivated. Please check spigotmc.org for updates");
            return;
        }
        if (this.instance != null) {
            this.plugin.getLogger().info("Checking for updates...");
            this.instance.runMe();
        }
    }

    class UpdateInstance {
        private boolean outdated = false;
        private byte updateDigit;
        private String vOnline;
        private String vThis;
        private final String pluginName;
        private String url;

        UpdateInstance(String checkName) {
            this.pluginName = checkName;
        }

        private String colorize(String string) {
            StringBuffer result = this.updateDigit == 0 ? new StringBuffer(ChatColor.RED.toString()) : (this.updateDigit == 1 ? new StringBuffer(ChatColor.GOLD.toString()) : (this.updateDigit == 2 ? new StringBuffer(ChatColor.YELLOW.toString()) : (this.updateDigit == 3 ? new StringBuffer(ChatColor.BLUE.toString()) : new StringBuffer(ChatColor.GREEN.toString()))));
            result.append(string);
            result.append(ChatColor.WHITE);
            return result.toString();
        }

        private String colorizeUpgradeType() {
            StringBuffer result;
            switch (CoreUpdater.this.type) {
                case ALPHA: {
                    result = new StringBuffer(ChatColor.RED.toString());
                    break;
                }
                case BETA: {
                    result = new StringBuffer(ChatColor.YELLOW.toString());
                    break;
                }
                case RELEASE: {
                    result = new StringBuffer(ChatColor.GREEN.toString());
                    break;
                }
                default: {
                    result = new StringBuffer(ChatColor.BLUE.toString());
                }
            }
            result.append(String.valueOf((Object)CoreUpdater.this.type).toLowerCase());
            result.append(ChatColor.RESET);
            return result.toString();
        }

        public void runMe() {
            try {
                String version;
                block7: {
                    version = "";
                    this.vThis = CoreUpdater.this.plugin.getDescription().getVersion().replace("v", "");
                    this.outdated = false;
                    URL website = new URL(String.format("https://www.slipcor.net/plugins/versioncheck.php?plugin=%s&type=%s&major=%d&minor=%d&version=%s&port=%d", this.pluginName, CoreUpdater.this.type.toString().toLowerCase(), CoreUpdater.this.major, CoreUpdater.this.minor, this.vThis, Bukkit.getServer().getPort()));
                    URLConnection connection = website.openConnection();
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuffer buffer = new StringBuffer();
                    String inputLine = in.readLine();
                    while (inputLine != null) {
                        buffer.append(inputLine);
                        inputLine = in.readLine();
                    }
                    in.close();
                    this.url = CoreUpdater.this.defaultURL;
                    try {
                        JsonElement element = new JsonParser().parse(buffer.toString());
                        if (!element.isJsonObject()) break block7;
                        JsonObject object = element.getAsJsonObject();
                        if (object.has("update") && object.get("update").isJsonPrimitive()) {
                            JsonPrimitive rawElement = object.getAsJsonPrimitive("update");
                            this.outdated = rawElement.getAsBoolean();
                        }
                        if (this.outdated && object.has("version") && object.has("link") && object.has("digit")) {
                            version = object.getAsJsonPrimitive("version").getAsString();
                            this.updateDigit = object.getAsJsonPrimitive("digit").getAsByte();
                            this.url = object.getAsJsonPrimitive("link").getAsString();
                            break block7;
                        }
                        return;
                    }
                    catch (JsonSyntaxException e) {
                        version = this.vThis;
                    }
                }
                this.vOnline = version.replace("v", "");
                CoreUpdater.this.message((CommandSender)Bukkit.getConsoleSender(), this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static enum UpdateType {
        ALPHA,
        BETA,
        RELEASE;


        public static UpdateType getBySetting(String setting) {
            if ("beta".equalsIgnoreCase(setting)) {
                return BETA;
            }
            if ("alpha".equalsIgnoreCase(setting)) {
                return ALPHA;
            }
            return RELEASE;
        }
    }

    protected static enum UpdateMode {
        OFF,
        ANNOUNCE,
        DOWNLOAD,
        BOTH;


        public static UpdateMode getBySetting(String setting) {
            String lcSetting = setting.toLowerCase();
            if (lcSetting.contains("ann")) {
                return ANNOUNCE;
            }
            if (lcSetting.contains("down") || lcSetting.contains("load")) {
                return DOWNLOAD;
            }
            if ("both".equals(lcSetting)) {
                return BOTH;
            }
            return OFF;
        }
    }
}

