/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.core;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.slipcor.pvpstats.core.CorePlugin;
import net.slipcor.pvpstats.core.LanguageEntry;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class CoreLanguage {
    protected final CorePlugin plugin;
    private static final Pattern hexPattern = Pattern.compile("<#([A-Fa-f0-9]){6}>");

    public CoreLanguage(CorePlugin plugin) {
        this.plugin = plugin;
    }

    public String load(String fileName) {
        this.plugin.getDataFolder().mkdir();
        File configFile = new File(this.plugin.getDataFolder(), fileName + ".yml");
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Error when creating language file:\n" + e.getMessage();
            }
        }
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error when loading language file:\n" + e.getMessage();
        }
        for (LanguageEntry m : this.getAllNodes()) {
            config.addDefault(m.getNode(), (Object)m.toString());
        }
        config.options().copyDefaults(true);
        try {
            config.save(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error when saving language file:\n" + e.getMessage();
        }
        for (LanguageEntry m : this.getAllNodes()) {
            m.setValue(config.getString(m.getNode()));
        }
        return null;
    }

    protected abstract LanguageEntry[] getAllNodes();

    public static String colorize(String message) {
        if (message.contains("<#")) {
            try {
                Matcher matcher = hexPattern.matcher(message);
                while (matcher.find()) {
                    ChatColor hexColor = ChatColor.of((String)matcher.group().substring(1, matcher.group().length() - 1));
                    String before = message.substring(0, matcher.start());
                    String after = message.substring(matcher.end());
                    message = before + hexColor + after;
                    matcher = hexPattern.matcher(message);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

