/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.slipcor.pvpstats.core.ConfigEntry;
import net.slipcor.pvpstats.core.CorePlugin;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class CoreConfig {
    private final CorePlugin plugin;
    private final String configName;
    protected final File configFile;
    protected final YamlConfiguration cfg;
    protected final Map<String, Boolean> booleans;
    protected final Map<String, Integer> ints;
    protected final Map<String, Double> doubles;
    protected final Map<String, String> strings;
    protected String[] emptyNodes;

    public CoreConfig(CorePlugin plugin, String configName, File configFile) {
        this.plugin = plugin;
        this.configName = configName;
        this.configFile = configFile;
        this.cfg = new YamlConfiguration();
        this.booleans = new HashMap<String, Boolean>();
        this.ints = new HashMap<String, Integer>();
        this.doubles = new HashMap<String, Double>();
        this.strings = new HashMap<String, String>();
    }

    public void appendComments() {
        try {
            String readLine;
            FileInputStream fis = new FileInputStream(this.configFile);
            DataInputStream dis = new DataInputStream(fis);
            BufferedReader reader = new BufferedReader(new InputStreamReader(dis));
            File tempFile = new File(this.plugin.getDataFolder(), "config-temp.yml");
            if (!tempFile.exists()) {
                tempFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(tempFile);
            DataOutputStream dos = new DataOutputStream(fos);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(dos));
            int indent = 0;
            String key = null;
            while ((readLine = reader.readLine()) != null) {
                if (key == null && writer.toString().length() < 1 && !readLine.startsWith("#")) {
                    writer.append("# === [ " + this.configName + " ] ===");
                    writer.newLine();
                }
                if (readLine.trim().startsWith("#") || readLine.trim().isEmpty()) continue;
                int firstContentCharacter = indent * 2;
                if (readLine.contains(":")) {
                    String[] newString;
                    String newStringLine = readLine.split(":")[0] + ":";
                    StringBuilder builder = new StringBuilder();
                    int newDigit = -1;
                    for (int pos = 0; pos < newStringLine.length(); ++pos) {
                        if (newStringLine.charAt(pos) != ' ' && newStringLine.charAt(pos) != ':') {
                            if (newDigit == -1) {
                                newDigit = pos;
                            }
                            builder.append(newStringLine.charAt(pos));
                            continue;
                        }
                        if (newStringLine.charAt(pos) == ' ') {
                            if (builder.length() <= 0) continue;
                            builder.append(newStringLine.charAt(pos));
                            continue;
                        }
                        if (newStringLine.charAt(pos) == ':') continue;
                        builder.append(newStringLine.charAt(pos));
                    }
                    if (key == null) {
                        key = builder.toString();
                    }
                    String[] split = key.split("\\.");
                    if (newDigit > firstContentCharacter) {
                        ++indent;
                        newString = new String[split.length + 1];
                        System.arraycopy(split, 0, newString, 0, split.length);
                        newString[split.length] = builder.toString();
                        split = newString;
                    } else if (newDigit < firstContentCharacter) {
                        indent = newDigit / 2;
                        newString = new String[indent + 1];
                        System.arraycopy(split, 0, newString, 0, indent);
                        newString[newString.length - 1] = builder.toString();
                        split = newString;
                    } else {
                        split[split.length - 1] = builder.toString();
                    }
                    StringBuilder buffer = new StringBuilder();
                    for (String string : split) {
                        buffer.append('.');
                        buffer.append(string);
                    }
                    key = buffer.substring(1);
                    ConfigEntry entry = this.getByNode(key);
                    if (entry == null) {
                        writer.append(readLine);
                        writer.newLine();
                        continue;
                    }
                    StringBuilder value = new StringBuilder();
                    for (int k = 0; k < indent; ++k) {
                        value.append("  ");
                    }
                    if (entry.getComment() != null && !entry.getComment().isEmpty()) {
                        writer.newLine();
                        writer.append(value);
                        writer.append("# ");
                        writer.append(entry.getComment());
                        writer.newLine();
                    }
                }
                writer.append(readLine);
                writer.newLine();
            }
            writer.flush();
            dos.close();
            fos.close();
            writer.close();
            fis.close();
            dis.close();
            reader.close();
            if (!this.configFile.delete()) {
                this.plugin.getLogger().severe("Could not delete un-commented config!");
            }
            if (!tempFile.renameTo(this.configFile)) {
                this.plugin.getLogger().severe("Could not rename Config!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract ConfigEntry getByNode(String var1);

    public abstract boolean load();

    public YamlConfiguration getYamlConfiguration() {
        return this.cfg;
    }

    public boolean getBoolean(ConfigEntry cfg) {
        return this.getBoolean(cfg, (Boolean)cfg.getValue());
    }

    private boolean getBoolean(ConfigEntry cfg, boolean def) {
        String path = cfg.getNode();
        Boolean result = this.booleans.get(path);
        return result == null ? def : result;
    }

    public int getInt(ConfigEntry cfg) {
        return this.getInt(cfg, (Integer)cfg.getValue());
    }

    public int getInt(ConfigEntry cfg, int def) {
        String path = cfg.getNode();
        Integer result = this.ints.get(path);
        return result == null ? def : result;
    }

    public double getDouble(ConfigEntry cfg) {
        return this.getDouble(cfg, (Double)cfg.getValue());
    }

    public double getDouble(ConfigEntry cfg, double def) {
        String path = cfg.getNode();
        Double result = this.doubles.get(path);
        return result == null ? def : result;
    }

    public String getString(ConfigEntry cfg) {
        return this.getString(cfg, (String)cfg.getValue());
    }

    public String getString(ConfigEntry cfg, String def) {
        String path = cfg.getNode();
        String result = this.strings.get(path);
        return result == null ? def : result;
    }

    public List<String> getStringList(ConfigEntry cfg, List<String> def) {
        if (this.cfg.get(cfg.getNode()) == null) {
            return def == null ? new LinkedList() : def;
        }
        return this.cfg.getStringList(cfg.getNode());
    }

    public void setValue(ConfigEntry entry, Object value) {
        this.cfg.set(entry.getNode(), value);
    }

    protected abstract boolean checkMaterials(String var1);

    protected abstract void loadMaterials();

    public void reloadMaps() {
        block0: for (String s : this.cfg.getKeys(true)) {
            Object object = this.cfg.get(s);
            ConfigEntry node = this.getByNode(s);
            if (object instanceof Boolean) {
                if (node != null && node.getType() == ConfigEntry.Type.BOOLEAN) {
                    this.booleans.put(s, (Boolean)object);
                } else if (node != null) {
                    this.plugin.getLogger().severe(this.configFile.getName() + ": " + s + " has unexpected boolean content, " + (Object)((Object)node.getType()) + " expected - please fix!");
                }
            } else if (object instanceof Integer) {
                if (node != null && node.getType() == ConfigEntry.Type.INT) {
                    this.ints.put(s, (Integer)object);
                } else if (node != null && node.getType() == ConfigEntry.Type.DOUBLE) {
                    double value = ((Integer)object).intValue();
                    this.plugin.getLogger().warning(this.configFile.getName() + ": " + s + " expects double, integer given!");
                    this.doubles.put(s, value);
                } else if (node != null) {
                    this.plugin.getLogger().severe(this.configFile.getName() + ": " + s + " has unexpected integer content, " + (Object)((Object)node.getType()) + " expected - please fix!");
                }
            } else if (object instanceof Double) {
                if (node != null && node.getType() == ConfigEntry.Type.DOUBLE) {
                    this.doubles.put(s, (Double)object);
                } else if (node != null && node.getType() == ConfigEntry.Type.INT) {
                    double value = (Double)object;
                    this.plugin.getLogger().warning(this.configFile.getName() + ": " + s + " expects integer, double given. Trying to round!");
                    this.ints.put(s, (int)value);
                } else if (node != null) {
                    this.plugin.getLogger().severe(this.configFile.getName() + ": " + s + " has unexpected double content, " + (Object)((Object)node.getType()) + " expected - please fix!");
                }
            } else if (object instanceof String) {
                this.strings.put(s, (String)object);
                if (node != null && node.getType() != ConfigEntry.Type.STRING) {
                    this.plugin.getLogger().severe(this.configFile.getName() + ": " + s + " has unexpected string content, " + (Object)((Object)node.getType()) + " expected - please fix!");
                }
            }
            if (node != null) continue;
            for (String test : this.emptyNodes) {
                if (s.equals(test)) continue block0;
            }
            if (this.checkMaterials(s)) continue;
            this.plugin.getLogger().warning("No valid node: " + s);
        }
        this.loadMaterials();
        this.appendComments();
    }

    public void save() {
        try {
            this.cfg.save(this.configFile);
            this.appendComments();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

