/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.classes.PlayerHandler;
import net.slipcor.pvpstats.core.CoreCommand;
import net.slipcor.pvpstats.core.CorePlugin;
import net.slipcor.pvpstats.runnables.SendPlayerStats;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CommandShow
extends CoreCommand {
    public CommandShow(CorePlugin plugin) {
        super(plugin, "pvpstats.count", Language.MSG.COMMAND_ARGUMENT_COUNT_INVALID);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            return;
        }
        if (args == null || args.length < 1 || args.length == 1 && args[0].equals("show")) {
            if (sender instanceof Player) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new SendPlayerStats(sender, (OfflinePlayer)((Player)sender)));
            } else {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.PLAYER_NO_STATS.parse());
            }
            return;
        }
        if (sender.hasPermission("pvpstats.show")) {
            OfflinePlayer player = PlayerHandler.findPlayer(args[1]);
            if (player == null) {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_PLAYER_NOT_FOUND.parse(args[1]));
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)PVPStats.getInstance(), (Runnable)new SendPlayerStats(sender, player));
        } else {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.NO_PERMISSION_SHOW.parse());
        }
    }

    private boolean isVanished(Player p) {
        for (MetadataValue meta : p.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                if (this.isVanished(p)) continue;
                results.add(p.getName());
            }
            return results;
        }
        if (args.length > 2) {
            return results;
        }
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (this.isVanished(p)) continue;
            this.addIfMatches(results, p.getName(), args[1]);
        }
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("show");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!sh");
    }

    @Override
    public String getShortInfo() {
        return "/pvpstats - show your pvp stats";
    }
}

