/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.DatabaseAPI;
import net.slipcor.pvpstats.core.CoreCommand;
import net.slipcor.pvpstats.core.CorePlugin;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.command.CommandSender;

public class CommandMigrate
extends CoreCommand {
    public CommandMigrate(CorePlugin plugin) {
        super(plugin, "pvpstats.migrate", Language.MSG.COMMAND_ARGUMENT_COUNT_INVALID);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.NO_PERMISSION_MIGRATE.parse());
            return;
        }
        if (!this.argCountValid(sender, args, new Integer[]{3})) {
            return;
        }
        String method = "";
        if (!(args[2].toLowerCase().equals("mysql") || args[2].toLowerCase().equals("sqlite") || args[2].toLowerCase().equals("yml"))) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_ARGUMENT_INVALID_TYPE.parse(args[2], "'mysql' or 'sqlite' or 'yml'"));
            return;
        }
        method = args[2].toLowerCase();
        if (args[1].toLowerCase().equals("from")) {
            int result = DatabaseAPI.migrateFrom(method, sender);
            if (result >= 0) {
                if (result > 0) {
                    PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_MIGRATE_SUCCESS.parse(String.valueOf(result)));
                } else {
                    PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_MIGRATE_SKIPPED.parse());
                }
            }
            DatabaseAPI.refresh();
            return;
        }
        if (args[1].toLowerCase().equals("to")) {
            int result = DatabaseAPI.migrateTo(method, sender);
            if (result >= 0) {
                if (result > 0) {
                    PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_MIGRATE_SUCCESS.parse(String.valueOf(result)));
                } else {
                    PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_MIGRATE_SKIPPED.parse());
                }
            }
            return;
        }
        PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_ARGUMENT_INVALID_TYPE.parse(args[1], "'from' or 'to'"));
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            results.add("to");
            results.add("from");
            return results;
        }
        if (args.length > 3) {
            return results;
        }
        if (args.length < 3) {
            this.addIfMatches(results, "to", args[1].toLowerCase());
            this.addIfMatches(results, "from", args[1].toLowerCase());
        } else {
            this.addIfMatches(results, "mysql", args[2].toLowerCase());
            this.addIfMatches(results, "sqlite", args[2].toLowerCase());
            this.addIfMatches(results, "yml", args[2].toLowerCase());
        }
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("migrate");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!m");
    }

    @Override
    public String getShortInfo() {
        return "/pvpstats migrate [from|to] [mysql|sqlite|yml] - read database from / save database to other database logic";
    }
}

