/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.core.CoreCommand;
import net.slipcor.pvpstats.core.CorePlugin;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CommandHelp
extends CoreCommand {
    public CommandHelp(CorePlugin plugin) {
        super(plugin, "pvpstats.help", Language.MSG.COMMAND_ARGUMENT_COUNT_INVALID);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.NO_PERMISSION_HELP.parse());
            return;
        }
        for (CoreCommand command : PVPStats.getInstance().getCommands()) {
            if (!command.hasPerms(sender)) continue;
            sender.sendMessage(ChatColor.YELLOW + command.getShortInfo());
        }
    }

    @Override
    public List<String> completeTab(String[] args) {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("help");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("?");
    }

    @Override
    public String getShortInfo() {
        return "/pvpstats help - get your available commands and information about it";
    }
}

