/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.core.CoreCommand;
import net.slipcor.pvpstats.core.CorePlugin;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.command.CommandSender;

public class CommandDebug
extends CoreCommand {
    public CommandDebug(CorePlugin plugin) {
        super(plugin, "pvpstats.debug", Language.MSG.COMMAND_ARGUMENT_COUNT_INVALID);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.NO_PERMISSION_DEBUG.parse());
            return;
        }
        if (!this.argCountValid(sender, args, new Integer[]{2})) {
            return;
        }
        PVPStats.getInstance().destroyDebugger();
        if (args.length > 1) {
            PVPStats.getInstance().getConfig().set("debug", (Object)args[1]);
        }
        PVPStats.getInstance().loadDebugger("debug", sender);
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            results.add("on");
            results.add("off");
            results.add("all");
            results.add("none");
            results.add("true");
            results.add("false");
            return results;
        }
        if (args.length > 2) {
            return results;
        }
        this.addIfMatches(results, "on", args[1].toLowerCase());
        this.addIfMatches(results, "off", args[1].toLowerCase());
        this.addIfMatches(results, "all", args[1].toLowerCase());
        this.addIfMatches(results, "none", args[1].toLowerCase());
        this.addIfMatches(results, "true", args[1].toLowerCase());
        this.addIfMatches(results, "false", args[1].toLowerCase());
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("debug");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!d");
    }

    @Override
    public String getShortInfo() {
        return "/pvpstats debug [on/off] - activate or deactivate debugging";
    }
}

