/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.core.ConfigEntry;
import net.slipcor.pvpstats.core.CoreCommand;
import net.slipcor.pvpstats.core.CorePlugin;
import net.slipcor.pvpstats.yml.Config;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.command.CommandSender;

public class CommandConfig
extends CoreCommand {
    final List<Config.Entry> accessibleLists = new ArrayList<Config.Entry>();

    public CommandConfig(CorePlugin plugin) {
        super(plugin, "pvpstats.config", Language.MSG.COMMAND_ARGUMENT_COUNT_INVALID);
        this.accessibleLists.add(Config.Entry.IGNORE_WORLDS);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.NO_PERMISSION_CONFIG_SET.parse());
            return;
        }
        if (args.length >= 2 && args[1].toLowerCase().equals("set")) {
            if (!this.argCountValid(sender, args, new Integer[]{4})) {
                return;
            }
            this.set(sender, args[2], args[3]);
            return;
        }
        if (args.length >= 2 && args[1].toLowerCase().equals("get")) {
            if (!this.argCountValid(sender, args, new Integer[]{3})) {
                return;
            }
            this.get(sender, args[2]);
            return;
        }
        if (args.length >= 2 && args[1].toLowerCase().equals("add")) {
            if (!this.argCountValid(sender, args, new Integer[]{4})) {
                return;
            }
            this.add(sender, args[2], args[3]);
            return;
        }
        if (args.length >= 2 && args[1].toLowerCase().equals("remove")) {
            if (!this.argCountValid(sender, args, new Integer[]{4})) {
                return;
            }
            this.remove(sender, args[2], args[3]);
            return;
        }
        PVPStats.getInstance().sendPrefixed(sender, this.getShortInfo());
    }

    private Config.Entry getFullNode(String part) {
        boolean foundEntry = false;
        Config.Entry completedEntry = null;
        for (Config.Entry entry : Config.Entry.values()) {
            if (!entry.getNode().toLowerCase().contains(part.toLowerCase()) || entry.getNode().length() == part.length()) continue;
            if (foundEntry) {
                foundEntry = false;
                completedEntry = null;
                break;
            }
            foundEntry = true;
            completedEntry = entry;
        }
        return completedEntry;
    }

    private void add(CommandSender sender, String node, String value) {
        ArrayList<String> newList;
        Config.Entry completedEntry = this.getFullNode(node);
        if (completedEntry != null) {
            this.add(sender, completedEntry.getNode(), value);
            return;
        }
        Config.Entry entry = Config.Entry.getByNode(node);
        if (entry == null) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_UNKNOWN_NODE.parse(node));
            return;
        }
        ConfigEntry.Type entryType = entry.getType();
        Config config = PVPStats.getInstance().config();
        if (entryType == ConfigEntry.Type.COMMENT) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_SET_GROUP_IMPOSSIBLE.parse(node));
            return;
        }
        if (entryType == ConfigEntry.Type.LIST) {
            newList = new ArrayList<String>(config.getStringList(entry, new ArrayList<String>()));
            if (newList.contains(value)) {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_ADD_SKIPPED.parse(node, value));
                return;
            }
        } else {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_NO_LIST.parse(node));
            return;
        }
        newList.add(value);
        config.setValue(entry, newList);
        PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_ADD_SUCCESS.parse(node, value));
        config.save();
        PVPStats.getInstance().reloadConfig();
    }

    private void get(CommandSender sender, String node) {
        Config.Entry completedEntry = this.getFullNode(node);
        if (completedEntry != null) {
            this.get(sender, completedEntry.getNode());
            return;
        }
        Config.Entry entry = Config.Entry.getByNode(node);
        if (entry == null) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_UNKNOWN_NODE.parse(node));
            return;
        }
        if (entry.secret) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_GET_SECRET_FORBIDDEN.parse(node));
            return;
        }
        ConfigEntry.Type entryType = entry.getType();
        Config config = PVPStats.getInstance().config();
        if (entryType == ConfigEntry.Type.COMMENT) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_GET_GROUP_IMPOSSIBLE.parse(node));
        } else if (entryType == ConfigEntry.Type.LIST) {
            StringBuffer value = new StringBuffer();
            List<String> list = config.getStringList(entry, new ArrayList<String>());
            for (String item : list) {
                value.append("\n");
                value.append(item);
            }
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_GET_SUCCESS.parse(node, value.toString()));
        } else if (entryType == ConfigEntry.Type.BOOLEAN) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_GET_SUCCESS.parse(node, String.valueOf(config.getBoolean(entry))));
        } else if (entryType == ConfigEntry.Type.STRING) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_GET_SUCCESS.parse(node, config.getString(entry)));
        } else if (entryType == ConfigEntry.Type.INT) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_GET_SUCCESS.parse(node, String.valueOf(config.getInt(entry))));
        } else if (entryType == ConfigEntry.Type.DOUBLE) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_GET_SUCCESS.parse(node, String.format("%.2f", config.getDouble(entry))));
        } else {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_UNKNOWN_TYPE.parse(entryType.name()));
        }
    }

    private void remove(CommandSender sender, String node, String value) {
        ArrayList<String> newList;
        Config.Entry completedEntry = this.getFullNode(node);
        if (completedEntry != null) {
            this.remove(sender, completedEntry.getNode(), value);
            return;
        }
        Config.Entry entry = Config.Entry.getByNode(node);
        if (entry == null) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_UNKNOWN_NODE.parse(node));
            return;
        }
        ConfigEntry.Type entryType = entry.getType();
        Config config = PVPStats.getInstance().config();
        if (entryType == ConfigEntry.Type.COMMENT) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_SET_GROUP_IMPOSSIBLE.parse(node));
            return;
        }
        if (entryType == ConfigEntry.Type.LIST) {
            newList = new ArrayList<String>(config.getStringList(entry, new ArrayList<String>()));
            if (!newList.contains(value)) {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_REMOVE_SKIPPED.parse(node, value));
                return;
            }
        } else {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_NO_LIST.parse(node));
            return;
        }
        newList.remove(value);
        config.setValue(entry, newList);
        PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_REMOVE_SUCCESS.parse(node, value));
        config.save();
        PVPStats.getInstance().reloadConfig();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void set(CommandSender sender, String node, String value) {
        Config.Entry completedEntry = this.getFullNode(node);
        if (completedEntry != null) {
            this.set(sender, completedEntry.getNode(), value);
            return;
        }
        Config.Entry entry = Config.Entry.getByNode(node);
        if (entry == null) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_UNKNOWN_NODE.parse(node));
            return;
        }
        ConfigEntry.Type entryType = entry.getType();
        Config config = PVPStats.getInstance().config();
        if (entryType == ConfigEntry.Type.COMMENT) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_SET_GROUP_IMPOSSIBLE.parse(node));
            return;
        }
        if (entryType == ConfigEntry.Type.LIST) {
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_SET_LIST_IMPOSSIBLE.parse(node));
            return;
        }
        if (entryType == ConfigEntry.Type.BOOLEAN) {
            if ("true".equalsIgnoreCase(value)) {
                config.setValue(entry, Boolean.TRUE);
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_SET_SUCCESS.parse(node, "true"));
            } else {
                if (!"false".equalsIgnoreCase(value)) {
                    PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_ARGUMENT_INVALID_TYPE.parse(value, "boolean (true|false)"));
                    return;
                }
                config.setValue(entry, Boolean.FALSE);
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_SET_SUCCESS.parse(node, "false"));
            }
        } else if (entryType == ConfigEntry.Type.STRING) {
            config.setValue(entry, String.valueOf(value));
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_SET_SUCCESS.parse(node, value));
        } else if (entryType == ConfigEntry.Type.INT) {
            int iValue;
            try {
                iValue = Integer.parseInt(value);
            }
            catch (Exception e) {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_ARGUMENT_INVALID_NUMBER.parse(value));
                return;
            }
            config.setValue(entry, iValue);
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_SET_SUCCESS.parse(node, String.valueOf(iValue)));
        } else {
            double dValue;
            if (entryType != ConfigEntry.Type.DOUBLE) {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_UNKNOWN_TYPE.parse(entryType.name()));
                return;
            }
            try {
                dValue = Double.parseDouble(value);
            }
            catch (Exception e) {
                PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_ARGUMENT_INVALID_TYPE.parse(value, "double (e.g. 12.00)"));
                return;
            }
            config.setValue(entry, dValue);
            PVPStats.getInstance().sendPrefixed(sender, Language.MSG.COMMAND_CONFIG_SET_SUCCESS.parse(node, String.valueOf(dValue)));
        }
        config.save();
        PVPStats.getInstance().reloadConfig();
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            results.add("get");
            results.add("set");
            results.add("add");
            results.add("remove");
        } else if (args.length == 2) {
            this.addIfMatches(results, "get", args[1]);
            this.addIfMatches(results, "set", args[1]);
            this.addIfMatches(results, "add", args[1]);
            this.addIfMatches(results, "remove", args[1]);
        } else {
            if (!(args[1].equalsIgnoreCase("get") || args[1].equalsIgnoreCase("set") || args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove"))) {
                return results;
            }
            if (args[2].equals("")) {
                for (Config.Entry entry : Config.Entry.values()) {
                    if (args[1].equalsIgnoreCase("get") ? entry.getType() == ConfigEntry.Type.COMMENT : (args[1].equalsIgnoreCase("set") ? entry.getType() == ConfigEntry.Type.COMMENT || entry.getType() == ConfigEntry.Type.LIST : entry.getType() == ConfigEntry.Type.COMMENT || !this.accessibleLists.contains(entry))) continue;
                    results.add(entry.getNode());
                }
                return results;
            }
            if (args.length > 3) {
                return results;
            }
            for (Config.Entry entry : Config.Entry.values()) {
                if (args[1].equalsIgnoreCase("get") ? entry.getType() == ConfigEntry.Type.COMMENT : (args[1].equalsIgnoreCase("set") ? entry.getType() == ConfigEntry.Type.COMMENT || entry.getType() == ConfigEntry.Type.LIST : entry.getType() == ConfigEntry.Type.COMMENT || !this.accessibleLists.contains(entry))) continue;
                this.addIfMatches(results, entry.getNode(), args[2]);
            }
        }
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("config");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!c");
    }

    @Override
    public String getShortInfo() {
        return "/pvpstats config get [node] - get a config value\n/pvpstats config set [node] [value] - set a config value\n/pvpstats config add [node] [value] - add a value to a config list\n/pvpstats config remove [node] [value] - remove a value from a config list";
    }
}

