/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.classes;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.slipcor.pvpstats.api.InformationType;

public class PlayerStatistic {
    private final String name;
    private int kills;
    private int deaths;
    private final int streak;
    private final int currentstreak;
    private final int elo;
    private final long time;
    private final UUID uid;
    public static int ELO_MINIMUM = 16;
    public static int ELO_DEFAULT = 1500;

    public PlayerStatistic(String name, int kills, int deaths, int streak, int currentstreak, int elo, long time, UUID uid) {
        this.name = name;
        this.kills = kills;
        this.deaths = deaths;
        this.streak = streak;
        this.currentstreak = currentstreak;
        this.elo = elo > ELO_MINIMUM ? elo : ELO_DEFAULT;
        this.time = time;
        this.uid = uid;
    }

    public String getName() {
        return this.name;
    }

    public int getKills() {
        return this.kills;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public int getMaxStreak() {
        return this.streak;
    }

    public int getCurrentStreak() {
        return this.currentstreak;
    }

    public int getELO() {
        return this.elo;
    }

    public long getTime() {
        return this.time;
    }

    public double getRatio() {
        return (double)this.kills / (double)(this.deaths + 1);
    }

    public UUID getUid() {
        return this.uid;
    }

    public Map<InformationType, String> toStringMap() {
        HashMap<InformationType, String> result = new HashMap<InformationType, String>();
        result.put(InformationType.NAME, String.valueOf(this.name));
        result.put(InformationType.DEATHS, String.valueOf(this.deaths));
        result.put(InformationType.KILLS, String.valueOf(this.kills));
        result.put(InformationType.ELO, String.valueOf(this.elo));
        result.put(InformationType.CURRENTSTREAK, String.valueOf(this.currentstreak));
        result.put(InformationType.STREAK, String.valueOf(this.streak));
        return result;
    }

    public void addKill() {
        ++this.kills;
    }

    public void addDeath() {
        ++this.deaths;
    }
}

