/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.classes;

import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.yml.Config;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PlayerHandler {
    public static OfflinePlayer findPlayer(String value) {
        Player result = Bukkit.getServer().getPlayer(value);
        if (result != null || PVPStats.getInstance().config().getBoolean(Config.Entry.OTHER_AVOID_PLAYER_LOOKUP)) {
            return result;
        }
        if (value.length() < 3 || value.length() > 16 || value.contains(" ")) {
            return null;
        }
        if (Bukkit.getOfflinePlayers().length > 10000) {
            return PVPStats.getInstance().getSQLHandler().findPlayer(value);
        }
        for (OfflinePlayer off : Bukkit.getOfflinePlayers()) {
            String name;
            if (off == null || (name = off.getName()) == null) continue;
            if (name.equalsIgnoreCase(value)) {
                return off;
            }
            if (off.getPlayer() != null && off.getPlayer().getDisplayName().toLowerCase().contains(value.toLowerCase())) {
                return off;
            }
            if (result != null || !name.toLowerCase().contains(value.toLowerCase())) continue;
            result = off;
        }
        return result;
    }

    public static String getPlayerName(OfflinePlayer offlinePlayer) {
        if (PVPStats.getInstance().config().getBoolean(Config.Entry.OTHER_DISPLAYNAMES) && offlinePlayer.getPlayer() != null) {
            return offlinePlayer.getPlayer().getDisplayName();
        }
        return offlinePlayer.getName();
    }

    public static String getRawPlayerName(OfflinePlayer offlinePlayer) {
        if (PVPStats.getInstance().config().getBoolean(Config.Entry.OTHER_DISPLAYNAMES) && offlinePlayer.getPlayer() != null) {
            return ChatColor.stripColor((String)offlinePlayer.getPlayer().getDisplayName());
        }
        return offlinePlayer.getName();
    }

    public static String getPlayerWorld(OfflinePlayer offlinePlayer) {
        if (offlinePlayer.getPlayer() != null) {
            Player player = offlinePlayer.getPlayer();
            return player.getWorld().getName();
        }
        if (Bukkit.getServer().getWorlds().size() < 1) {
            return "unknown";
        }
        return ((World)Bukkit.getServer().getWorlds().get(0)).getName();
    }
}

