/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.classes;

import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.LeaderboardBuffer;
import net.slipcor.pvpstats.api.PlayerStatisticsBuffer;
import net.slipcor.pvpstats.core.LanguageEntry;
import net.slipcor.pvpstats.yml.Language;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;

public class PlaceholderAPIHook
extends PlaceholderExpansion {
    long lastError = 0L;
    static Map<String, LanguageEntry> stringToEntry = new HashMap<String, LanguageEntry>();

    public String getIdentifier() {
        return "slipcorpvpstats";
    }

    public String getAuthor() {
        return "SLiPCoR";
    }

    public String getVersion() {
        return "0.0.4";
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String s) {
        if (s == null) {
            return "PlaceholderIsNull";
        }
        if (player != null) {
            if (s.equals("kills")) {
                return String.valueOf(PlayerStatisticsBuffer.getKills(player.getUniqueId()));
            }
            if (s.equals("deaths")) {
                return String.valueOf(PlayerStatisticsBuffer.getDeaths(player.getUniqueId()));
            }
            if (s.equals("streak")) {
                return String.valueOf(PlayerStatisticsBuffer.getStreak(player.getUniqueId()));
            }
            if (s.equals("maxstreak")) {
                return String.valueOf(PlayerStatisticsBuffer.getMaxStreak(player.getUniqueId()));
            }
            if (s.equals("elo")) {
                return String.valueOf(PlayerStatisticsBuffer.getEloScore(player.getUniqueId()));
            }
            if (s.equals("ratio")) {
                return String.format("%.2f", PlayerStatisticsBuffer.getRatio(player.getUniqueId()));
            }
        }
        if (s.startsWith("top_")) {
            try {
                String[] split = s.split("_");
                int pos = Integer.parseInt(s.split("_")[2]);
                String name = split[1].toUpperCase();
                if (split.length > 3 && !s.endsWith("_name") && !s.endsWith("_value")) {
                    return Language.MSG.STATISTIC_HEADLINE_TOP.parse(String.valueOf(pos), stringToEntry.get(name).parse());
                }
                String[] top = LeaderboardBuffer.top(pos, name, 0);
                if (top.length < pos) {
                    return "";
                }
                if (s.endsWith("_name")) {
                    return ChatColor.stripColor((String)top[pos - 1].split(":")[0]);
                }
                if (s.endsWith("_value")) {
                    return ChatColor.stripColor((String)top[pos - 1].split(":")[1].substring(1));
                }
                return Language.MSG.STATISTIC_FORMAT_NUMBER.parse(String.valueOf(pos), top[pos - 1]);
            }
            catch (Exception e) {
                long now = System.currentTimeMillis();
                if (now > this.lastError + 10000L) {
                    PVPStats.getInstance().getLogger().warning("Placeholder not working, here is more info:");
                    e.printStackTrace();
                }
                return "";
            }
        }
        if (s.startsWith("flop_")) {
            try {
                String[] split = s.split("_");
                int pos = Integer.parseInt(s.split("_")[2]);
                String name = split[1].toUpperCase();
                if (split.length > 3 && !s.endsWith("_name") && !s.endsWith("_value")) {
                    return Language.MSG.STATISTIC_HEADLINE_FLOP.parse(String.valueOf(pos), stringToEntry.get(name).parse());
                }
                String[] top = LeaderboardBuffer.flop(pos, name);
                if (top.length < pos) {
                    return "";
                }
                if (s.endsWith("_name")) {
                    return ChatColor.stripColor((String)top[pos - 1].split(":")[0]);
                }
                if (s.endsWith("_value")) {
                    return ChatColor.stripColor((String)top[pos - 1].split(":")[1].substring(1));
                }
                return Language.MSG.STATISTIC_FORMAT_NUMBER.parse(String.valueOf(pos), top[pos - 1]);
            }
            catch (Exception e) {
                long now = System.currentTimeMillis();
                if (now > this.lastError + 10000L) {
                    PVPStats.getInstance().getLogger().warning("Placeholder not working, here is more info:");
                    e.printStackTrace();
                }
                return "";
            }
        }
        if (s.startsWith("topplus_")) {
            try {
                String[] split = s.split("_");
                int pos = Integer.parseInt(split[2]);
                int days = Integer.parseInt(split[3]);
                String name = split[1].toUpperCase();
                if (split.length > 4) {
                    return Language.MSG.STATISTIC_HEADLINE_TOP.parse(String.valueOf(pos), stringToEntry.get(name).parse());
                }
                String[] top = LeaderboardBuffer.topPlus(pos, name, days);
                if (top.length < pos) {
                    return "";
                }
                return Language.MSG.STATISTIC_FORMAT_NUMBER.parse(String.valueOf(pos), top[pos - 1]);
            }
            catch (Exception e) {
                long now = System.currentTimeMillis();
                if (now > this.lastError + 10000L) {
                    PVPStats.getInstance().getLogger().warning("Placeholder not working, here is more info:");
                    e.printStackTrace();
                }
                return "";
            }
        }
        if (s.startsWith("topworld_")) {
            try {
                String[] split = s.split("_");
                int pos = Integer.parseInt(split[2]);
                String world = split[3];
                int days = Integer.parseInt(split[4]);
                String name = split[1].toUpperCase();
                if (split.length > 5) {
                    return Language.MSG.STATISTIC_HEADLINE_TOP.parse(String.valueOf(pos), stringToEntry.get(name).parse());
                }
                String[] top = LeaderboardBuffer.topWorld(pos, name, world, days);
                if (top.length < pos) {
                    return "";
                }
                return Language.MSG.STATISTIC_FORMAT_NUMBER.parse(String.valueOf(pos), top[pos - 1]);
            }
            catch (Exception e) {
                long now = System.currentTimeMillis();
                if (now > this.lastError + 10000L) {
                    PVPStats.getInstance().getLogger().warning("Placeholder not working, here is more info:");
                    e.printStackTrace();
                }
                return "";
            }
        }
        return null;
    }

    static {
        stringToEntry.put("LINE", Language.MSG.STATISTIC_SEPARATOR);
        stringToEntry.put("KILLS", Language.MSG.STATISTIC_HEADLINE_KILLS);
        stringToEntry.put("DEATHS", Language.MSG.STATISTIC_HEADLINE_DEATHS);
        stringToEntry.put("STREAK", Language.MSG.STATISTIC_HEADLINE_STREAK);
        stringToEntry.put("CURRENTSTREAK", Language.MSG.STATISTIC_HEADLINE_CURRENTSTREAK);
        stringToEntry.put("RATIO", Language.MSG.STATISTIC_HEADLINE_RATIO);
        stringToEntry.put("ELO", Language.MSG.STATISTIC_HEADLINE_ELO);
    }
}

