/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats.api;

import java.util.HashMap;
import java.util.Map;
import net.slipcor.pvpstats.PVPStats;
import net.slipcor.pvpstats.api.DatabaseAPI;
import net.slipcor.pvpstats.yml.Config;

public class LeaderboardBuffer {
    private static final Map<String, Long> LASTCHECKEDTOP = new HashMap<String, Long>();
    private static final Map<String, Long> LASTCHECKEDTOPPLUS = new HashMap<String, Long>();
    private static final Map<String, Long> LASTCHECKEDFLOP = new HashMap<String, Long>();
    private static final Map<String, String[]> TOP = new HashMap<String, String[]>();
    private static final Map<String, String[]> TOPPLUS = new HashMap<String, String[]>();
    private static final Map<String, String[]> FLOP = new HashMap<String, String[]>();

    private LeaderboardBuffer() {
    }

    public static String[] top(int value, String type, int offset) {
        String[] values;
        int length;
        type = type.toUpperCase();
        long last = LASTCHECKEDTOP.get(type);
        long now = System.currentTimeMillis() / 1000L;
        if ((last -= now) < 0L && (last *= -1L) > (long)PVPStats.getInstance().config().getInt(Config.Entry.STATISTICS_LEADERBOARD_REFRESH)) {
            String[] array = DatabaseAPI.top(PVPStats.getInstance().config().getInt(Config.Entry.STATISTICS_LIST_LENGTH), type);
            if (array == null) {
                array = new String[]{};
            }
            TOP.put(type, array);
            LASTCHECKEDTOP.put(type, now);
        }
        if ((length = Math.min(value, (values = TOP.get(type)).length - offset)) <= 0) {
            return new String[0];
        }
        length = Math.min(10, length);
        String[] result = new String[length];
        System.arraycopy(values, offset, result, 0, length);
        return result;
    }

    public static String[] topPlus(int value, String type, int days) {
        String[] values;
        int length;
        type = type.toUpperCase();
        String mapKey = type + days;
        long last = LASTCHECKEDTOPPLUS.getOrDefault(mapKey, 0L);
        long now = System.currentTimeMillis() / 1000L;
        if ((last -= now) < 0L && (last *= -1L) > (long)PVPStats.getInstance().config().getInt(Config.Entry.STATISTICS_LEADERBOARD_REFRESH)) {
            String[] array = DatabaseAPI.topPlus(PVPStats.getInstance().config().getInt(Config.Entry.STATISTICS_LIST_LENGTH), type, days);
            if (array == null) {
                array = new String[]{};
            }
            TOPPLUS.put(mapKey, array);
            LASTCHECKEDTOPPLUS.put(mapKey, now);
        }
        if ((length = Math.min(value, (values = TOPPLUS.get(mapKey)).length)) <= 0) {
            return new String[0];
        }
        length = Math.min(10, length);
        String[] result = new String[length];
        System.arraycopy(values, 0, result, 0, length);
        return result;
    }

    public static String[] topWorld(int value, String type, String world, int days) {
        String[] values;
        int length;
        type = type.toUpperCase();
        String mapKey = type + world + days;
        long last = LASTCHECKEDTOPPLUS.getOrDefault(mapKey, 0L);
        long now = System.currentTimeMillis() / 1000L;
        if ((last -= now) < 0L && (last *= -1L) > (long)PVPStats.getInstance().config().getInt(Config.Entry.STATISTICS_LEADERBOARD_REFRESH)) {
            String[] array = DatabaseAPI.topWorld(PVPStats.getInstance().config().getInt(Config.Entry.STATISTICS_LIST_LENGTH), type, world, days);
            if (array == null) {
                array = new String[]{};
            }
            TOPPLUS.put(mapKey, array);
            LASTCHECKEDTOPPLUS.put(mapKey, now);
        }
        if ((length = Math.min(value, (values = TOPPLUS.get(mapKey)).length)) <= 0) {
            return new String[0];
        }
        length = Math.min(10, length);
        String[] result = new String[length];
        System.arraycopy(values, 0, result, 0, length);
        return result;
    }

    public static String[] flop(int value, String type) {
        String[] values;
        int length;
        type = type.toUpperCase();
        long last = LASTCHECKEDFLOP.get(type);
        long now = System.currentTimeMillis() / 1000L;
        if ((last -= now) < 0L && (last *= -1L) > (long)PVPStats.getInstance().config().getInt(Config.Entry.STATISTICS_LEADERBOARD_REFRESH)) {
            String[] array = DatabaseAPI.flop(10, type);
            if (array == null) {
                array = new String[]{};
            }
            FLOP.put(type, array);
            LASTCHECKEDFLOP.put(type, now);
        }
        if ((length = Math.min(value, (values = FLOP.get(type)).length)) <= 0) {
            return new String[0];
        }
        length = Math.min(10, length);
        String[] result = new String[length];
        System.arraycopy(values, 0, result, 0, length);
        return result;
    }

    static {
        LASTCHECKEDTOP.put("KILLS", 0L);
        LASTCHECKEDTOP.put("DEATHS", 0L);
        LASTCHECKEDTOP.put("STREAK", 0L);
        LASTCHECKEDTOP.put("CURRENTSTREAK", 0L);
        LASTCHECKEDTOP.put("ELO", 0L);
        LASTCHECKEDTOP.put("K-D", 0L);
        LASTCHECKEDTOP.put("RATIO", 0L);
        LASTCHECKEDFLOP.put("KILLS", 0L);
        LASTCHECKEDFLOP.put("DEATHS", 0L);
        LASTCHECKEDFLOP.put("STREAK", 0L);
        LASTCHECKEDFLOP.put("CURRENTSTREAK", 0L);
        LASTCHECKEDFLOP.put("ELO", 0L);
        LASTCHECKEDFLOP.put("K-D", 0L);
        LASTCHECKEDFLOP.put("RATIO", 0L);
    }
}

