/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.pvpstats;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.slipcor.pvpstats.api.DatabaseAPI;
import net.slipcor.pvpstats.api.DatabaseConnection;
import net.slipcor.pvpstats.classes.PlaceholderAPIAbbreviationHook;
import net.slipcor.pvpstats.classes.PlaceholderAPIHook;
import net.slipcor.pvpstats.classes.PlayerHandler;
import net.slipcor.pvpstats.classes.PlayerStatistic;
import net.slipcor.pvpstats.commands.CommandCleanup;
import net.slipcor.pvpstats.commands.CommandConfig;
import net.slipcor.pvpstats.commands.CommandDebug;
import net.slipcor.pvpstats.commands.CommandDebugKill;
import net.slipcor.pvpstats.commands.CommandHelp;
import net.slipcor.pvpstats.commands.CommandMigrate;
import net.slipcor.pvpstats.commands.CommandPurge;
import net.slipcor.pvpstats.commands.CommandReload;
import net.slipcor.pvpstats.commands.CommandSet;
import net.slipcor.pvpstats.commands.CommandShow;
import net.slipcor.pvpstats.commands.CommandTop;
import net.slipcor.pvpstats.commands.CommandTopPlus;
import net.slipcor.pvpstats.commands.CommandTopWorld;
import net.slipcor.pvpstats.commands.CommandWipe;
import net.slipcor.pvpstats.core.CoreCommand;
import net.slipcor.pvpstats.core.CoreDebugger;
import net.slipcor.pvpstats.core.CoreLanguage;
import net.slipcor.pvpstats.core.CoreMetrics;
import net.slipcor.pvpstats.core.CorePlugin;
import net.slipcor.pvpstats.core.CoreTabCompleter;
import net.slipcor.pvpstats.core.CoreUpdater;
import net.slipcor.pvpstats.display.SignDisplay;
import net.slipcor.pvpstats.impl.FlatFileConnection;
import net.slipcor.pvpstats.impl.MySQLConnection;
import net.slipcor.pvpstats.impl.SQLiteConnection;
import net.slipcor.pvpstats.listeners.PVPArenaListener;
import net.slipcor.pvpstats.listeners.PlayerListener;
import net.slipcor.pvpstats.listeners.PluginListener;
import net.slipcor.pvpstats.metrics.MetricsLite;
import net.slipcor.pvpstats.metrics.MetricsMain;
import net.slipcor.pvpstats.runnables.CheckAndDo;
import net.slipcor.pvpstats.runnables.DatabaseIncreaseDeaths;
import net.slipcor.pvpstats.runnables.DatabaseIncreaseKills;
import net.slipcor.pvpstats.runnables.DatabaseIncreaseKillsStreak;
import net.slipcor.pvpstats.runnables.DatabaseKillAddition;
import net.slipcor.pvpstats.text.TextComponent;
import net.slipcor.pvpstats.text.TextFormatter;
import net.slipcor.pvpstats.yml.Config;
import net.slipcor.pvpstats.yml.Language;
import net.slipcor.pvpstats.yml.LanguageMigration;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.scheduler.BukkitTask;

public class PVPStats
extends CorePlugin {
    private static PVPStats instance;
    private static final int CFGVERSION = 1;
    private boolean mySQL = false;
    private boolean SQLite = false;
    private DatabaseConnection dbHandler;
    private CoreDebugger debugger;
    private Plugin paHandler = null;
    private CoreUpdater updater = null;
    private CoreLanguage language = null;
    private Config configHandler = null;
    private CoreTabCompleter completer;
    private FileConfiguration announcements = null;
    private FileConfiguration commands = null;
    private PlayerListener playerListener;
    private final PVPArenaListener pluginListener = new PVPArenaListener(this);
    private final Map<String, CoreCommand> commandMap = new HashMap<String, CoreCommand>();
    private final List<CoreCommand> commandList = new ArrayList<CoreCommand>();
    private BukkitTask reloadTask = null;

    public static PVPStats getInstance() {
        return instance;
    }

    @Override
    public Config config() {
        if (this.configHandler == null) {
            if (this.getConfig().getInt("ver", 0) < 1) {
                this.getConfig().options().copyDefaults(true);
                this.getConfig().set("ver", (Object)1);
                this.saveConfig();
            }
            this.reloadConfig();
            this.configHandler = new Config(this);
            this.getLogger().info("Loaded config file!");
        }
        return this.configHandler;
    }

    public List<CoreCommand> getCommands() {
        return new ArrayList<CoreCommand>(this.commandList);
    }

    @Override
    protected String getMessagePrefix() {
        return Language.MSG.MESSAGE_PREFIX.parse();
    }

    @Override
    public String getDebugPrefix() {
        return "[PS-debug] ";
    }

    public Plugin getPAHandler() {
        return this.paHandler;
    }

    public PVPArenaListener getPAListener() {
        return this.pluginListener;
    }

    public DatabaseConnection getSQLHandler() {
        return this.dbHandler;
    }

    public CoreUpdater getUpdater() {
        return this.updater;
    }

    public void handleStreak(UUID uuid, int value) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        try {
            String lastKill;
            String replacement;
            String key;
            if (this.config().getBoolean(Config.Entry.STATISTICS_STREAK_ANNOUNCEMENTS) || this.config().getBoolean(Config.Entry.STATISTICS_STREAK_INTERVAL_ANNOUNCEMENTS)) {
                this.debugger.i("we want announcements");
                if (this.announcements == null) {
                    this.announcements = new YamlConfiguration();
                    this.announcements.load(new File(this.getDataFolder(), "streak_announcements.yml"));
                    this.debugger.i("we loaded the announcements");
                }
                key = this.getMatchingKey(this.announcements, this.config().getBoolean(Config.Entry.STATISTICS_STREAK_INTERVAL_ANNOUNCEMENTS), value);
                List<String> msgList = new ArrayList();
                if (this.announcements.isString(key)) {
                    String msg = this.announcements.getString(key, "");
                    if (!msg.equals("")) {
                        msgList.add(msg);
                    }
                } else if (this.announcements.isList(key)) {
                    msgList = this.announcements.getStringList(key);
                }
                this.debugger.i("we got the announcement list");
                for (String message : msgList) {
                    if (message.isEmpty()) continue;
                    this.debugger.i("message: " + message);
                    replacement = Language.colorize(message).replace("%player%", PlayerHandler.getPlayerName((OfflinePlayer)player)).replace("%value%", String.valueOf(value));
                    this.debugger.i("message replaced to " + replacement);
                    if (message.contains("%killed%")) {
                        lastKill = DatabaseAPI.getLastKilled(player.getName());
                        if (lastKill != null && Bukkit.getPlayer((String)lastKill) != null) {
                            replacement = replacement.replace("%killed%", PlayerHandler.getPlayerName((OfflinePlayer)Bukkit.getPlayer((String)lastKill)));
                        }
                        this.debugger.i("and again replaced to " + replacement);
                    }
                    Bukkit.broadcastMessage((String)replacement);
                }
            }
            if (this.config().getBoolean(Config.Entry.STATISTICS_STREAK_COMMANDS) || this.config().getBoolean(Config.Entry.STATISTICS_STREAK_INTERVAL_COMMANDS)) {
                if (this.commands == null) {
                    this.commands = new YamlConfiguration();
                    this.commands.load(new File(this.getDataFolder(), "streak_commands.yml"));
                }
                key = this.getMatchingKey(this.commands, this.config().getBoolean(Config.Entry.STATISTICS_STREAK_INTERVAL_COMMANDS), value);
                List<String> cmdList = new ArrayList();
                if (this.commands.isString(key)) {
                    String cmd = this.commands.getString(key, "");
                    if (!cmd.equals("")) {
                        cmdList.add(this.commands.getString(key, ""));
                    }
                } else if (this.commands.isList(key)) {
                    cmdList = this.commands.getStringList(key);
                }
                this.debugger.i("we got the commands list");
                for (String command : cmdList) {
                    if (command.isEmpty()) continue;
                    this.debugger.i("command: " + command);
                    replacement = Language.colorize(command).replace("%player%", PlayerHandler.getPlayerName((OfflinePlayer)player)).replace("%value%", String.valueOf(value));
                    this.debugger.i("command replaced to " + replacement);
                    if (command.contains("%killed%")) {
                        lastKill = DatabaseAPI.getLastKilled(player.getName());
                        if (lastKill != null) {
                            replacement = replacement.replace("%killed%", lastKill);
                        }
                        this.debugger.i("and again replaced to " + replacement);
                    }
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), replacement);
                }
            }
        }
        catch (IOException | InvalidConfigurationException exception) {
            exception.printStackTrace();
        }
    }

    private String getMatchingKey(FileConfiguration configuration, boolean interval, int value) {
        if (!interval) {
            return String.valueOf(value);
        }
        int match = 0;
        for (String key : configuration.getKeys(false)) {
            try {
                int keyValue = Integer.parseInt(key);
                if (value % keyValue != 0) continue;
                match = keyValue;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return String.valueOf(match);
    }

    public boolean ignoresWorld(String name) {
        if (!this.getConfig().contains(Config.Entry.IGNORE_WORLDS.getNode())) {
            return false;
        }
        return this.config().getStringList(Config.Entry.IGNORE_WORLDS, new ArrayList<String>()).contains(name);
    }

    public void loadCommands() {
        int seconds;
        this.commandList.clear();
        this.commandMap.clear();
        this.completer = null;
        new CommandCleanup(this).load(this.commandList, this.commandMap);
        new CommandConfig(this).load(this.commandList, this.commandMap);
        new CommandDebug(this).load(this.commandList, this.commandMap);
        new CommandDebugKill(this).load(this.commandList, this.commandMap);
        new CommandHelp(this).load(this.commandList, this.commandMap);
        new CommandMigrate(this).load(this.commandList, this.commandMap);
        new CommandPurge(this).load(this.commandList, this.commandMap);
        new CommandShow(this).load(this.commandList, this.commandMap);
        new CommandSet(this).load(this.commandList, this.commandMap);
        new CommandTop(this).load(this.commandList, this.commandMap);
        new CommandTopPlus(this).load(this.commandList, this.commandMap);
        new CommandTopWorld(this).load(this.commandList, this.commandMap);
        new CommandReload(this).load(this.commandList, this.commandMap);
        new CommandWipe(this).load(this.commandList, this.commandMap);
        if (this.dbHandler != null && (seconds = this.config().getInt(Config.Entry.STATISTICS_FORCE_RELOAD_INTERVAL)) > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DatabaseAPI.refresh();
                }
            };
            if (this.reloadTask != null) {
                this.reloadTask.cancel();
            }
            this.reloadTask = Bukkit.getScheduler().runTaskTimer((Plugin)this, runnable, (long)(20 * seconds), (long)(20 * seconds));
        }
    }

    public void loadConfig() {
        DatabaseAPI.initiate(this);
        this.config().load();
        String dbHost = null;
        String dbUser = null;
        String dbPass = null;
        String dbDatabase = null;
        String dbTable = null;
        String dbOptions = null;
        String dbKillTable = null;
        int dbPort = 0;
        if (this.config().getBoolean(Config.Entry.MYSQL_ACTIVE)) {
            this.mySQL = true;
            dbHost = this.config().getString(Config.Entry.MYSQL_HOST);
            dbUser = this.config().getString(Config.Entry.MYSQL_USERNAME);
            dbPass = this.config().getString(Config.Entry.MYSQL_PASSWORD);
            dbDatabase = this.config().getString(Config.Entry.MYSQL_DATABASE);
            dbTable = this.config().getString(Config.Entry.MYSQL_TABLE);
            dbOptions = this.config().getString(Config.Entry.MYSQL_OPTIONS);
            if (this.config().getBoolean(Config.Entry.STATISTICS_COLLECT_PRECISE)) {
                dbKillTable = this.config().getString(Config.Entry.MYSQL_KILLTABLE);
            }
            dbPort = this.config().getInt(Config.Entry.MYSQL_PORT);
        } else if (this.config().getBoolean(Config.Entry.SQLITE_ACTIVE)) {
            this.SQLite = true;
            dbDatabase = this.config().getString(Config.Entry.SQLITE_FILENAME);
            dbTable = this.config().getString(Config.Entry.SQLITE_TABLE);
            if (this.config().getBoolean(Config.Entry.STATISTICS_COLLECT_PRECISE)) {
                dbKillTable = this.config().getString(Config.Entry.SQLITE_KILLTABLE);
                this.getLogger().warning("Specific stats can be turned off as they are never used, they are intended for SQL and web frontend usage!");
                this.getLogger().warning("We recommend you set '" + Config.Entry.STATISTICS_COLLECT_PRECISE.getNode() + "' to false");
            }
        } else {
            dbTable = this.config().getString(Config.Entry.YML_TABLE);
            if (this.config().getBoolean(Config.Entry.STATISTICS_COLLECT_PRECISE) && this.config().getBoolean(Config.Entry.YML_COLLECT_PRECISE)) {
                dbKillTable = this.config().getString(Config.Entry.MYSQL_KILLTABLE);
            } else if (this.config().getBoolean(Config.Entry.STATISTICS_COLLECT_PRECISE)) {
                this.getLogger().warning("Specific stats can be turned off as they are never used, they are intended for SQL and web frontend usage!");
                this.getLogger().warning("Please either switch to SQLite or re-enable this by setting '" + Config.Entry.YML_COLLECT_PRECISE.getNode() + "' to true");
            }
        }
        if (this.mySQL) {
            if (dbHost.equals("") || dbUser.equals("") || dbPass.equals("") || dbDatabase.equals("") || dbPort == 0) {
                this.mySQL = false;
            }
        } else if (this.SQLite && dbDatabase.equals("")) {
            this.SQLite = false;
        }
        if (this.mySQL) {
            this.getLogger().info("Database: mySQL");
            try {
                this.dbHandler = new MySQLConnection(dbHost, dbPort, dbDatabase, dbUser, dbPass, dbOptions, dbTable, dbKillTable);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e1) {
                e1.printStackTrace();
            }
        } else if (this.SQLite) {
            this.getLogger().info("Database: SQLite");
            this.dbHandler = new SQLiteConnection(dbDatabase, dbTable, dbKillTable);
        } else {
            this.getLogger().warning("Database: YML");
            this.dbHandler = new FlatFileConnection(dbTable, dbKillTable);
        }
        this.getLogger().info("Database Initializing");
        if (this.dbHandler != null && this.dbHandler.connect(true)) {
            this.getLogger().info("Database connection successful");
            if (!this.dbHandler.tableExists(dbDatabase, dbTable)) {
                this.getLogger().info("Creating table " + dbTable);
                this.dbHandler.createStatsTable(true);
                if (dbKillTable != null) {
                    this.getLogger().info("Creating table " + dbKillTable);
                    this.dbHandler.createKillStatsTable(true);
                }
            } else if (dbKillTable != null) {
                if (!this.dbHandler.tableExists(dbDatabase, dbKillTable)) {
                    this.getLogger().info("Creating table " + dbKillTable);
                    this.dbHandler.createKillStatsTable(true);
                } else if (!this.dbHandler.hasColumn(dbKillTable, "world")) {
                    this.dbHandler.addWorldColumn();
                    this.dbHandler.addKillVictim();
                } else if (!this.dbHandler.hasColumn(dbKillTable, "victim")) {
                    this.dbHandler.addKillVictim();
                }
            }
        } else {
            this.getLogger().severe("Database connection failed");
            this.mySQL = false;
            this.SQLite = false;
        }
        PlayerStatistic.ELO_DEFAULT = this.config().getInt(Config.Entry.ELO_DEFAULT);
        PlayerStatistic.ELO_MINIMUM = this.config().getInt(Config.Entry.ELO_MINIMUM);
    }

    public String loadLanguage() {
        LanguageMigration.commit(this);
        return this.language.load("lang");
    }

    private void loadHooks() {
        Plugin paPlugin = this.getServer().getPluginManager().getPlugin("pvparena");
        if (paPlugin != null && paPlugin.isEnabled()) {
            this.getLogger().info("<3 PVP Arena");
            this.paHandler = paPlugin;
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        CoreCommand acc;
        this.debugger.i("onCommand!", sender);
        CoreCommand coreCommand = acc = args.length > 0 ? this.commandMap.get(args[0].toLowerCase()) : null;
        if (acc != null) {
            acc.commit(sender, args);
            return true;
        }
        if (args.length < 1) {
            this.commandMap.get("show").commit(sender, new String[0]);
            return true;
        }
        int legacy = 0;
        try {
            legacy = Integer.parseInt(args[0]);
            if (legacy > 0) {
                this.commandMap.get("top").commit(sender, args);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.config().getBoolean(Config.Entry.GENERAL_SHOW_COMMANDS)) {
            boolean found = false;
            for (CoreCommand command : this.commandList) {
                if (!command.hasPerms(sender)) continue;
                sender.sendMessage(ChatColor.YELLOW + command.getShortInfo());
                found = true;
            }
            if (!found) {
                this.commandMap.get("show").commit(sender, args);
            }
            return found;
        }
        OfflinePlayer player = PlayerHandler.findPlayer(args[0]);
        if (player == null) {
            this.sendPrefixed(sender, Language.MSG.COMMAND_PLAYER_NOT_FOUND.parse(args[0]));
        } else {
            String[] newArgs = new String[]{"show", args[0]};
            this.commandMap.get("show").commit(sender, newArgs);
        }
        return true;
    }

    public void onDisable() {
        this.destroyDebugger();
        this.getLogger().info("disabled. (version " + this.getDescription().getVersion() + ")");
    }

    public void onLoad() {
        instance = this;
        this.language = new Language(this);
        this.loadConfig();
    }

    public void onEnable() {
        this.debugger = new CoreDebugger(this, 8);
        try {
            OfflinePlayer.class.getDeclaredMethod("getUniqueId", new Class[0]);
        }
        catch (Exception e) {
            this.getLogger().info("Your server is still not ready for UUIDs? Use PVP Stats older than v0.8.25.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.configHandler = this.config();
        PluginDescriptionFile pdfFile = this.getDescription();
        this.loadCommands();
        DatabaseAPI.DEBUGGER = new CoreDebugger(this, 4);
        CommandCleanup.debugger = new CoreDebugger(this, 11);
        CommandDebugKill.debugger = new CoreDebugger(this, 13);
        SignDisplay.debugger = new CoreDebugger(this, 16);
        PlayerListener.Debugger = new CoreDebugger(this, 3);
        CheckAndDo.DEBUGGER = new CoreDebugger(this, 20);
        DatabaseIncreaseDeaths.debugger = new CoreDebugger(this, 19);
        DatabaseIncreaseKills.debugger = new CoreDebugger(this, 17);
        DatabaseIncreaseKillsStreak.debugger = new CoreDebugger(this, 15);
        DatabaseKillAddition.debugger = new CoreDebugger(this, 14);
        if (!new File(this.getDataFolder(), "streak_announcements.yml").exists()) {
            this.saveResource("streak_announcements.yml", false);
        }
        if (!new File(this.getDataFolder(), "streak_commands.yml").exists()) {
            this.saveResource("streak_commands.yml", false);
        }
        this.playerListener = new PlayerListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        if (this.dbHandler == null || !this.dbHandler.isConnected()) {
            this.getLogger().severe("Database not connected, plugin DISABLED!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadHooks();
        if (this.config().getBoolean(Config.Entry.OTHER_PVPARENA)) {
            if (this.getServer().getPluginManager().isPluginEnabled("pvparena")) {
                this.getServer().getPluginManager().registerEvents((Listener)this.pluginListener, (Plugin)this);
            } else {
                PluginListener paPluginListener = new PluginListener(this);
                this.getServer().getPluginManager().registerEvents((Listener)paPluginListener, (Plugin)this);
            }
        }
        this.updater = new CoreUpdater(this, this.getFile(), "pvpstats", "https://www.spigotmc.org/resources/pvp-stats.59124/", Config.Entry.UPDATE_MODE, Config.Entry.UPDATE_TYPE);
        if (this.loadLanguage() != null) {
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        if (this.config().getBoolean(Config.Entry.BSTATS_ENABLED)) {
            CoreMetrics coreMetrics = this.config().getBoolean(Config.Entry.BSTATS_FULL) ? new MetricsMain((Plugin)this) : new MetricsLite((Plugin)this);
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlaceholderAPIAbbreviationHook().register();
            new PlaceholderAPIHook().register();
        }
        this.loadDebugger("debug", (CommandSender)Bukkit.getConsoleSender());
        if (this.config().getBoolean(Config.Entry.STATISTICS_CLEAR_ON_START)) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"pvpstats cleanup");
        }
        SignDisplay.loadAllDisplays();
        this.getLogger().info("enabled. (version " + pdfFile.getVersion() + ")");
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (this.completer == null) {
            this.completer = new CoreTabCompleter(this.config().getBoolean(Config.Entry.GENERAL_SHORTHAND_COMMANDS));
        }
        return this.completer.getMatches(sender, this.commandList, args);
    }

    public void reloadStreaks() {
        this.commands = null;
        this.announcements = null;
    }

    public void sendPrefixedOP(List<CommandSender> senders, TextComponent ... message) {
        if (!this.config().getBoolean(Config.Entry.OTHER_OP_MESSAGES)) {
            this.debugger.i("Would opmsg but config is false");
            return;
        }
        if (senders.size() == 0) {
            senders.addAll(Bukkit.getServer().getOnlinePlayers());
        } else {
            senders = new ArrayList<CommandSender>(new HashSet<CommandSender>(senders));
            senders.remove(null);
        }
        for (CommandSender sender : senders) {
            if (!sender.hasPermission("pvpstats.opmessages")) {
                this.debugger.i("Would opmsg but permission is false");
                return;
            }
            if (!TextFormatter.hasContent(message)) continue;
            TextFormatter.send(sender, TextFormatter.addPrefix(message));
            TextFormatter.explainDisableOPMessages(sender);
        }
    }

    public void setPAHandler(Plugin plugin) {
        this.paHandler = plugin;
    }
}

