/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.utils;

import java.util.ArrayList;
import java.util.List;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean matchContains(List<String> list, String needle, boolean partial) {
        if (list.contains(needle)) {
            return true;
        }
        for (String entry : list) {
            if (partial && entry.toLowerCase().contains(needle.toLowerCase())) {
                return true;
            }
            if (entry.contains("*")) {
                String compare = entry.replace("*", "");
                if (!needle.toLowerCase().contains(compare.toLowerCase())) continue;
                return true;
            }
            if (!entry.equalsIgnoreCase(needle)) continue;
            return true;
        }
        return false;
    }

    public static String[] compress(String[] args) {
        String fullCommand = org.apache.commons.lang.StringUtils.join((Object[])args, (char)' ');
        if (!fullCommand.contains("\"")) {
            return args;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String[] quoteString = fullCommand.split("\"");
        int pos = 0;
        for (String entry : quoteString) {
            if (++pos % 2 == 1) {
                String[] spaced;
                for (String space : spaced = entry.split(" ")) {
                    if (space.isEmpty()) continue;
                    arguments.add(space);
                }
                continue;
            }
            if (entry.isEmpty()) continue;
            arguments.add(entry);
        }
        return arguments.toArray(new String[0]);
    }

    public static boolean isSupportedVersion(int[] serverVersion, int[] testVersion) {
        for (int i = 0; i < 3; ++i) {
            if (serverVersion[i] < testVersion[i]) {
                return false;
            }
            if (serverVersion[i] <= testVersion[i]) continue;
            return true;
        }
        return true;
    }

    public static int[] splitToVersionArray(String version) {
        String[] chunks = new String[]{"1", "9"};
        try {
            chunks = version.split("-")[0].split("\\.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int major = 1;
        int minor = 9;
        int patch = 0;
        try {
            major = Integer.parseInt(chunks[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            minor = Integer.parseInt(chunks[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            patch = Integer.parseInt(chunks[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new int[]{major, minor, patch};
    }
}

