/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.discovery;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.TreeAssistDebugger;
import net.slipcor.treeassist.discovery.DiscoveryResult;
import net.slipcor.treeassist.discovery.FailReason;
import net.slipcor.treeassist.events.TASaplingPlaceEvent;
import net.slipcor.treeassist.events.TATreeBlockBrokenEvent;
import net.slipcor.treeassist.externals.mcMMOHook;
import net.slipcor.treeassist.listeners.TreeAssistPlayerListener;
import net.slipcor.treeassist.runnables.CleanRunner;
import net.slipcor.treeassist.runnables.TreeAssistReplant;
import net.slipcor.treeassist.runnables.TreeAssistReplantDelay;
import net.slipcor.treeassist.utils.BlockUtils;
import net.slipcor.treeassist.utils.CommandUtils;
import net.slipcor.treeassist.utils.MaterialUtils;
import net.slipcor.treeassist.utils.ToolUtils;
import net.slipcor.treeassist.yml.Language;
import net.slipcor.treeassist.yml.MainConfig;
import net.slipcor.treeassist.yml.TreeConfig;
import net.slipcor.treeassist.yml.TreeConfigUpdater;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TreeStructure {
    public static Set<Material> allTrunks = new HashSet<Material>();
    public static Set<Material> allSaplings = new HashSet<Material>();
    public static Set<Material> allExtras = new HashSet<Material>();
    public static Set<Material> allNaturals = new HashSet<Material>();
    static Map<BlockFace, BlockFace[]> continuations = new EnumMap<BlockFace, BlockFace[]>(BlockFace.class);
    private static final Map<BlockFace, BlockFace[]> diagonalContinuations = new EnumMap<BlockFace, BlockFace[]>(BlockFace.class);
    public static TreeAssistDebugger debug;
    public Block bottom;
    public List<Block> trunk;
    private final Set<Material> trunkBlocks;
    private final Set<Material> extraBlocks;
    private final Set<Material> naturalBlocks;
    private final Set<Material> groundBlocks;
    private List<Block> neighborTrunks = new ArrayList<Block>();
    public final List<TreeAssistReplantDelay> saplings = new ArrayList<TreeAssistReplantDelay>();
    public Map<Block, List<Block>> branchMap;
    protected Set<Block> extras;
    private final List<Block> roofs = new ArrayList<Block>();
    private final List<Block> checkedBlocks = new ArrayList<Block>();
    private final boolean trunkDiagonally;
    public DiscoveryResult discoveryResult = null;
    private final TreeConfig config;
    private Block northWestBlock;
    private Block northEastBlock;
    private Block southWestBlock;
    private Block southEastBlock;
    private List<Block> caps = new ArrayList<Block>();
    private boolean onlyReplant;

    public TreeStructure(TreeConfig config, Block bottom, boolean onlyTrunk) {
        this.config = config;
        this.bottom = bottom;
        this.trunkBlocks = new LinkedHashSet<Material>(config.getMaterials(TreeConfig.CFG.TRUNK_MATERIALS));
        this.extraBlocks = new LinkedHashSet<Material>(config.getMaterials(TreeConfig.CFG.BLOCKS_MATERIALS));
        this.naturalBlocks = new LinkedHashSet<Material>(config.getMaterials(TreeConfig.CFG.NATURAL_BLOCKS));
        this.groundBlocks = new LinkedHashSet<Material>(config.getMaterials(TreeConfig.CFG.GROUND_BLOCKS));
        this.trunkDiagonally = config.getBoolean(TreeConfig.CFG.TRUNK_DIAGONAL);
        if (config.getBoolean(TreeConfig.CFG.TRUNK_GREEDY) && !onlyTrunk) {
            this.findGreedy(config);
            return;
        }
        int thickness = config.getInt(TreeConfig.CFG.TRUNK_THICKNESS);
        boolean branches = config.getBoolean(TreeConfig.CFG.TRUNK_BRANCH);
        debug.i("Thickness: " + thickness);
        if (thickness == 1) {
            this.trunk = this.findTrunk();
            if (this.hasDiscoveryFailed()) {
                return;
            }
            if (this.trunk == null) {
                this.discoveryResult = new DiscoveryResult(config, this, FailReason.NO_TRUNK);
                return;
            }
            debug.i("Tree of size " + this.trunk.size() + " found!");
            if (onlyTrunk) {
                this.discoveryResult = new DiscoveryResult(config, this, false);
                return;
            }
            int max = config.getInt(TreeConfig.CFG.TRUNK_MAXIMUM_HEIGHT);
            int min = config.getInt(TreeConfig.CFG.TRUNK_MINIMUM_HEIGHT);
            int height = this.trunk.size();
            if (height < min) {
                debug.i("Lower than minimum: " + height + " < " + min + " for " + this.trunk.get(0).getType());
                this.discoveryResult = new DiscoveryResult(config, this, FailReason.TOO_SMALL);
                return;
            }
            if (max > -1 && height > max) {
                debug.i("Higher than maximum: " + height + " > " + min + " for " + this.trunk.get(0).getType());
                this.discoveryResult = new DiscoveryResult(config, this, FailReason.TOO_LARGE);
                return;
            }
            this.neighborTrunks = new ArrayList<Block>();
            this.branchMap = new HashMap<Block, List<Block>>();
            if (branches) {
                this.getAllBranches();
                if (this.hasDiscoveryFailed()) {
                    return;
                }
                debug.i("branch blocks: " + this.countBranches());
            }
            if (this.neighborTrunks.isEmpty()) {
                debug.i("No other trunks found, checking again!");
                this.findOtherTrunks();
                if (!this.neighborTrunks.isEmpty()) {
                    debug.i("Found other trunks: " + this.neighborTrunks.size());
                }
            }
            this.getAllExtras();
            if (this.extras == null || this.extras.size() == 0) {
                debug.i("No leaves found!");
                this.discoveryResult = new DiscoveryResult(config, this, FailReason.NO_LEAVES);
            } else if (!this.hasDistanceTo(this.neighborTrunks)) {
                debug.i("Farming row?");
            } else if (this.extras.size() < config.getInt(TreeConfig.CFG.BLOCKS_REQUIRED, 10)) {
                debug.i("Not enough extra blocks found: " + this.extras.size());
                this.discoveryResult = new DiscoveryResult(config, this, FailReason.NOT_ENOUGH_LEAVES);
            }
            if (!this.hasDiscoveryFailed()) {
                this.discoveryResult = new DiscoveryResult(config, this, false);
            }
            return;
        }
        if (thickness > 2) {
            this.branchMap = new HashMap<Block, List<Block>>();
            List<Block> bottoms = this.findThickBottoms();
            if (bottoms.size() < 3) {
                debug.i("Not enough trunks found: " + bottoms.size());
                this.discoveryResult = new DiscoveryResult(config, this, FailReason.NOT_ENOUGH_TRUNKS);
                return;
            }
            debug.i("Trunks: " + bottoms.size());
            this.trunk = this.findTrunks(bottoms);
            if (this.hasDiscoveryFailed()) {
                return;
            }
            if (this.trunk == null) {
                this.discoveryResult = new DiscoveryResult(config, this, FailReason.NO_TRUNK);
                return;
            }
            if (onlyTrunk) {
                this.discoveryResult = new DiscoveryResult(config, this, false);
                return;
            }
            this.getAllExtras();
            if (this.neighborTrunks.isEmpty()) {
                debug.i("No other trunks found, checking again!");
                this.findOtherTrunks();
                if (!this.neighborTrunks.isEmpty()) {
                    debug.i("Found other trunks: " + this.neighborTrunks.size());
                }
            }
            if (!this.hasDiscoveryFailed()) {
                this.discoveryResult = new DiscoveryResult(config, this, false);
            }
            return;
        }
        Block checkBlock = config.getBoolean(TreeConfig.CFG.TRUNK_UNEVEN_BOTTOM) ? bottom.getRelative(BlockFace.UP, 2) : bottom;
        BlockFace[] faces = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH_EAST, BlockFace.SOUTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_WEST};
        ArrayList<Block> trunks = new ArrayList<Block>();
        trunks.add(bottom);
        for (BlockFace face : faces) {
            Block nextBlock = checkBlock.getRelative(face);
            while (this.trunkBlocks.contains(nextBlock.getType())) {
                nextBlock = nextBlock.getRelative(BlockFace.DOWN);
            }
            if (!this.groundBlocks.contains(nextBlock.getType()) || !this.trunkBlocks.contains(nextBlock.getRelative(BlockFace.UP, 2).getType())) continue;
            trunks.add(nextBlock.getRelative(BlockFace.UP));
        }
        if (trunks.size() != 4) {
            debug.i("We do not have 4 trunks, we found " + trunks.size() + "!");
            this.discoveryResult = new DiscoveryResult(config, this, FailReason.NOT_ENOUGH_TRUNKS);
            return;
        }
        this.trunk = this.findTrunks(trunks);
        if (this.hasDiscoveryFailed()) {
            return;
        }
        if (this.trunk == null) {
            this.discoveryResult = new DiscoveryResult(config, this, FailReason.NO_TRUNK);
            return;
        }
        debug.i("Tree of size " + this.trunk.size() + " found!");
        if (onlyTrunk) {
            this.discoveryResult = new DiscoveryResult(config, this, false);
            return;
        }
        int max = config.getInt(TreeConfig.CFG.TRUNK_MAXIMUM_HEIGHT);
        int min = config.getInt(TreeConfig.CFG.TRUNK_MINIMUM_HEIGHT);
        int height = this.trunk.size() / trunks.size();
        if (height < min) {
            debug.i("Lower than thick minimum: " + height + " < " + min + " for " + this.trunk.get(0).getType());
            this.discoveryResult = new DiscoveryResult(config, this, FailReason.TOO_SMALL);
            return;
        }
        if (max > -1 && height > max) {
            debug.i("Higher than thick maximum: " + height + " > " + min + " for " + this.trunk.get(0).getType());
            this.discoveryResult = new DiscoveryResult(config, this, FailReason.TOO_LARGE);
            return;
        }
        this.neighborTrunks = new ArrayList<Block>();
        this.branchMap = new HashMap<Block, List<Block>>();
        this.setSpecificBottoms(trunks);
        if (branches) {
            this.getDirectionalBranches();
            if (this.hasDiscoveryFailed()) {
                return;
            }
            debug.i("branch blocks: " + this.countBranches());
        }
        if (this.neighborTrunks.isEmpty()) {
            debug.i("No other trunks found, checking again!");
            this.findOtherTrunks();
            if (!this.neighborTrunks.isEmpty()) {
                debug.i("Found other trunks: " + this.neighborTrunks.size());
            }
        }
        this.getDirectionalExtras();
        if (this.extras == null || this.extras.size() == 0) {
            debug.i("No leaves found!");
            this.discoveryResult = new DiscoveryResult(config, this, FailReason.NO_LEAVES);
        } else if (!this.hasDistanceTo(this.neighborTrunks)) {
            debug.i("Farming row?");
        } else if (this.extras.size() < config.getInt(TreeConfig.CFG.BLOCKS_REQUIRED, 10)) {
            debug.i("Not enough extra blocks found: " + this.extras.size());
            this.discoveryResult = new DiscoveryResult(config, this, FailReason.NOT_ENOUGH_LEAVES);
        }
        if (!this.hasDiscoveryFailed()) {
            this.discoveryResult = new DiscoveryResult(config, this, false);
        }
    }

    protected TreeStructure(TreeConfig config) {
        this.config = config;
        this.trunkBlocks = new HashSet<Material>();
        this.extraBlocks = new HashSet<Material>();
        this.naturalBlocks = new HashSet<Material>();
        this.groundBlocks = new HashSet<Material>();
        this.trunkDiagonally = config.getBoolean(TreeConfig.CFG.TRUNK_DIAGONAL);
    }

    public static Block findBottomBlock(Player player, Block block, TreeConfig config, boolean checkParent) {
        Block parentBlock;
        if (config.getParent() != null && checkParent && (parentBlock = TreeStructure.findBottomBlock(player, block, config.getParent(), true)) != null) {
            return parentBlock;
        }
        List<Material> trunkBlocks = config.getMaterials(TreeConfig.CFG.TRUNK_MATERIALS);
        List<Material> extraBlocks = config.getMaterials(TreeConfig.CFG.BLOCKS_MATERIALS);
        List<Material> naturalBlocks = config.getMaterials(TreeConfig.CFG.NATURAL_BLOCKS);
        List<Material> groundBlocks = config.getMaterials(TreeConfig.CFG.GROUND_BLOCKS);
        Block checkBlock = block;
        boolean diagonalTrunk = config.getBoolean(TreeConfig.CFG.TRUNK_DIAGONAL);
        int overflowCheck = 0;
        block0: while (trunkBlocks.contains(checkBlock.getType())) {
            if (++overflowCheck > 256) {
                debug.i("Overflow! Not a valid tree!");
                if (player != null && TreeAssist.instance.getPlayerListener().isDebugTool(player.getInventory().getItemInMainHand())) {
                    TreeAssist.instance.sendPrefixed((CommandSender)player, "invalid tree: trunk overflow");
                }
                return null;
            }
            checkBlock = checkBlock.getRelative(BlockFace.DOWN);
            int grounds = 0;
            debug.i("checking ground at level " + checkBlock.getY());
            if (groundBlocks.contains(checkBlock.getRelative(BlockFace.NORTH).getType())) {
                ++grounds;
            }
            if (groundBlocks.contains(checkBlock.getRelative(BlockFace.SOUTH).getType())) {
                ++grounds;
            }
            if (groundBlocks.contains(checkBlock.getRelative(BlockFace.WEST).getType())) {
                ++grounds;
            }
            if (groundBlocks.contains(checkBlock.getRelative(BlockFace.EAST).getType())) {
                ++grounds;
            }
            if (grounds > 2) {
                if (grounds > 3) {
                    debug.i("We found the ground A around here. Good enough!");
                    return checkBlock.getRelative(BlockFace.UP);
                }
                debug.i("We found the ground B around here. Good enough!");
                return checkBlock.getRelative(BlockFace.UP);
            }
            if (!diagonalTrunk || trunkBlocks.contains(checkBlock.getType())) continue;
            Material checkMaterial = checkBlock.getType();
            debug.i("No more trunk going down at " + block.getLocation() + " - type: " + checkMaterial);
            if (!MaterialUtils.isAir(checkBlock.getType())) {
                if (groundBlocks.contains(checkMaterial)) {
                    debug.i("It's a ground block!");
                    return checkBlock.getRelative(BlockFace.UP);
                }
                if (!(extraBlocks.contains(checkMaterial) || naturalBlocks.contains(checkMaterial) || allTrunks.contains(checkMaterial) || allExtras.contains(checkMaterial))) {
                    debug.i("Unexpected block! Not a valid tree!");
                    if (player != null && TreeAssist.instance.getPlayerListener().isDebugTool(player.getInventory().getItemInMainHand())) {
                        TreeAssist.instance.sendPrefixed((CommandSender)player, "invalid tree: " + BlockUtils.printBlock(checkBlock));
                    }
                    return null;
                }
            }
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    Material innerCheck = checkBlock.getRelative(x, 0, z).getType();
                    if (trunkBlocks.contains(innerCheck)) {
                        checkBlock = checkBlock.getRelative(x, 0, z);
                        continue block0;
                    }
                    debug.i("Checking diagonal at " + checkBlock.getRelative(x, 0, z).getLocation() + " - type: " + innerCheck);
                    if (MaterialUtils.isAir(innerCheck) || groundBlocks.contains(innerCheck) || extraBlocks.contains(innerCheck) || naturalBlocks.contains(innerCheck) || allTrunks.contains(checkMaterial) || allExtras.contains(checkMaterial)) continue;
                    debug.i("Unexpected block! Not a valid tree!");
                    if (player != null && TreeAssist.instance.getPlayerListener().isDebugTool(player.getInventory().getItemInMainHand())) {
                        TreeAssist.instance.sendPrefixed((CommandSender)player, "invalid tree: " + BlockUtils.printBlock(checkBlock.getRelative(x, 0, z)));
                    }
                    return null;
                }
            }
        }
        if (groundBlocks.contains(checkBlock.getType())) {
            debug.i("We hit the ground!");
            return checkBlock.getRelative(BlockFace.UP);
        }
        debug.i("We did not find a ground block (" + checkBlock.getType() + ") not a valid tree.");
        if (player != null && TreeAssist.instance.getPlayerListener().isDebugTool(player.getInventory().getItemInMainHand())) {
            TreeAssist.instance.sendPrefixed((CommandSender)player, "invalid tree: " + BlockUtils.printBlock(checkBlock));
        }
        return null;
    }

    public Block calculateGreedyBottom() {
        if (this.trunk == null || this.trunk.size() < 1) {
            debug.i("No trunk found!");
            return null;
        }
        int[] sums = new int[3];
        World world = null;
        for (Block block : this.trunk) {
            if (world == null) {
                world = block.getWorld();
            }
            sums[0] = sums[0] + block.getX();
            sums[1] = sums[1] + block.getY();
            sums[2] = sums[2] + block.getZ();
        }
        sums[0] = sums[0] / this.trunk.size();
        sums[1] = sums[1] / this.trunk.size();
        sums[2] = sums[2] / this.trunk.size();
        return world.getBlockAt(sums[0], sums[1], sums[2]);
    }

    public void findGreedy(TreeConfig config) {
        int thickness = config.getInt(TreeConfig.CFG.TRUNK_THICKNESS);
        debug.i("Thickness: " + thickness);
        this.trunk = this.findTrunkGreedy();
        if (this.hasDiscoveryFailed()) {
            return;
        }
        if (this.trunk == null) {
            this.discoveryResult = new DiscoveryResult(config, this, FailReason.NO_TRUNK);
            return;
        }
        debug.i("Tree of size " + this.trunk.size() + " found!");
        int max = config.getInt(TreeConfig.CFG.TRUNK_MAXIMUM_HEIGHT);
        int min = config.getInt(TreeConfig.CFG.TRUNK_MINIMUM_HEIGHT);
        int height = this.trunk.size();
        if (height < min) {
            debug.i("Lower than minimum: " + height + " < " + min + " for " + this.trunk.get(0).getType());
            this.discoveryResult = new DiscoveryResult(config, this, FailReason.TOO_SMALL);
            return;
        }
        if (max > -1 && height > max) {
            debug.i("Higher than maximum: " + height + " > " + min + " for " + this.trunk.get(0).getType());
            this.discoveryResult = new DiscoveryResult(config, this, FailReason.TOO_LARGE);
            return;
        }
        this.getAllExtras();
        if (this.extras == null || this.extras.size() == 0) {
            debug.i("No leaves found!");
            this.discoveryResult = new DiscoveryResult(config, this, FailReason.NO_LEAVES);
        } else if (!this.hasDistanceTo(this.neighborTrunks)) {
            debug.i("Farming row?");
        } else if (this.extras.size() < config.getInt(TreeConfig.CFG.BLOCKS_REQUIRED, 10)) {
            debug.i("Not enough extra blocks found: " + this.extras.size());
            this.discoveryResult = new DiscoveryResult(config, this, FailReason.NOT_ENOUGH_LEAVES);
        }
        if (!this.hasDiscoveryFailed()) {
            this.discoveryResult = new DiscoveryResult(config, this, false);
        }
        this.bottom = this.calculateGreedyBottom();
        int loopcheck = 100;
        while (!this.groundBlocks.contains(this.bottom.getType()) && (this.naturalBlocks.contains(this.bottom.getType()) || this.trunkBlocks.contains(this.bottom.getType()) || this.extras.contains(this.bottom.getType()) || this.bottom.getType().isAir() || this.bottom.getType() == Material.WATER) && loopcheck-- >= 1) {
            int grounds = 0;
            if (this.groundBlocks.contains(this.bottom.getRelative(BlockFace.NORTH).getType())) {
                ++grounds;
            }
            if (this.groundBlocks.contains(this.bottom.getRelative(BlockFace.SOUTH).getType())) {
                ++grounds;
            }
            if (this.groundBlocks.contains(this.bottom.getRelative(BlockFace.WEST).getType())) {
                ++grounds;
            }
            if (this.groundBlocks.contains(this.bottom.getRelative(BlockFace.EAST).getType())) {
                ++grounds;
            }
            if (grounds > 2) {
                if (grounds > 3) {
                    this.bottom = this.bottom.getRelative(BlockFace.UP, 2);
                    return;
                }
                debug.i("We found the ground C around here. Good enough!");
                this.bottom = this.bottom.getRelative(BlockFace.UP);
                return;
            }
            this.bottom = this.bottom.getRelative(BlockFace.DOWN);
        }
        if (this.groundBlocks.contains(this.bottom.getType())) {
            this.bottom = this.bottom.getRelative(BlockFace.UP);
            debug.i("We found the ground. Neat!");
            return;
        }
        this.discoveryResult = new DiscoveryResult(config, this, FailReason.INVALID_BLOCK, "block A: " + BlockUtils.printBlock(this.bottom));
    }

    public static TreeStructure discover(Player player, Block checkBlock) {
        TreeConfig matchingTreeConfig = null;
        TreeStructure matchingTreeStructure = null;
        block0: for (TreeConfig config : TreeAssist.treeConfigs.values()) {
            List<Material> list = config.getMaterials(TreeConfig.CFG.TRUNK_MATERIALS);
            debug.i("--- checking config " + config.getConfigName());
            for (Material mat : list) {
                Block block;
                debug.i("checking for material " + mat);
                if (!checkBlock.getType().equals((Object)mat) || (block = TreeStructure.findBottomBlock(player, checkBlock, config, false)) == null) continue;
                debug.i("Tree found for Material " + mat);
                TreeStructure checkTreeStructure = new TreeStructure(config, block, false);
                if (checkTreeStructure.hasDiscoveryFailed()) {
                    debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, "Not a valid tree (" + (Object)((Object)checkTreeStructure.getFailReason()) + ") " + checkTreeStructure.discoveryResult.getInformation());
                } else {
                    checkTreeStructure.discoveryResult = new DiscoveryResult(config, checkTreeStructure, false);
                }
                if (checkTreeStructure.isValid()) {
                    debug.i("Tree matches " + mat);
                    if (TreeAssist.instance.config().getBoolean(MainConfig.CFG.GENERAL_PREVENT_WITHOUT_TOOL) && !ToolUtils.isMatchingTool(player.getInventory().getItemInMainHand(), config) && !TreeAssist.instance.getPlayerListener().isDebugTool(player.getInventory().getItemInMainHand())) {
                        debug.i("Player has not the right tool and we want to prevent now!");
                        if (player.isOp() || player.getGameMode() == GameMode.CREATIVE) {
                            debug.i("Player is OP or creative, let them be!");
                        } else {
                            TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.INFO_NEVER_BREAK_LOG_WITHOUT_TOOL.parse());
                            checkTreeStructure.discoveryResult = new DiscoveryResult(matchingTreeConfig, checkTreeStructure, true);
                            return checkTreeStructure;
                        }
                    }
                    int damagePredicted = -1;
                    if (TreeAssist.instance.config().getBoolean(MainConfig.CFG.GENERAL_PREVENT_WITH_BREAKING_TOOL)) {
                        damagePredicted = ToolUtils.calculateDamage(config, player.getInventory().getItemInMainHand(), checkTreeStructure);
                        debug.i("We predict damage: " + damagePredicted);
                        if (ToolUtils.wouldBreak(player.getInventory().getItemInMainHand(), damagePredicted)) {
                            debug.i("Player's tool would break and we do not want that!");
                            TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.INFO_NEVER_BREAK_LOG_WITH_BREAKING_TOOL.parse());
                            checkTreeStructure.discoveryResult = new DiscoveryResult(matchingTreeConfig, checkTreeStructure, true);
                            return checkTreeStructure;
                        }
                    }
                    if (TreeAssist.instance.config().getBoolean(MainConfig.CFG.GENERAL_USE_PERMISSIONS) && !player.hasPermission(config.getString(TreeConfig.CFG.PERMISSION))) {
                        debug.i("Player does not have permission " + config.getString(TreeConfig.CFG.PERMISSION));
                        debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, "Player does not have permission " + config.getString(TreeConfig.CFG.PERMISSION));
                        matchingTreeConfig = config;
                        matchingTreeStructure = checkTreeStructure;
                        continue block0;
                    }
                    if (config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_ACTIVE)) {
                        short maxDurability;
                        short durability;
                        ItemStack item;
                        if (TreeAssist.instance.hasCoolDown(player)) {
                            debug.i("Cooldown!");
                            TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.INFO_COOLDOWN_STILL.parse());
                            TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.INFO_COOLDOWN_VALUE.parse(String.valueOf(TreeAssist.instance.getCoolDown(player))));
                            checkTreeStructure.discoveryResult = new DiscoveryResult(config, checkTreeStructure, false);
                            return checkTreeStructure;
                        }
                        if (TreeAssist.instance.isDisabled(player.getWorld().getName(), player.getName())) {
                            debug.i("Disabled for this player in this world!");
                            checkTreeStructure.discoveryResult = new DiscoveryResult(config, checkTreeStructure, false);
                            debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, "Disabled for player " + player.getName() + " in this world!");
                            return checkTreeStructure;
                        }
                        String lore = config.getString(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_REQUIRED_LORE);
                        if (!("".equals(lore) || (item = player.getInventory().getItemInMainHand()).hasItemMeta() && item.getItemMeta().hasLore() && item.getItemMeta().getLore().contains(lore))) {
                            debug.i("Lore not found: " + lore);
                            debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, "Player tool does not have the required lore!");
                            matchingTreeConfig = config;
                            matchingTreeStructure = checkTreeStructure;
                            continue block0;
                        }
                        if (player.isSneaking()) {
                            if (!config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_WHEN_SNEAKING)) {
                                debug.i("Sneaking is bad!");
                                debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, "Player is sneaking!");
                                matchingTreeConfig = config;
                                matchingTreeStructure = checkTreeStructure;
                                continue block0;
                            }
                        } else if (!config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_WHEN_NOT_SNEAKING)) {
                            debug.i("Not sneaking is bad!");
                            debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, "Player is not sneaking!");
                            matchingTreeConfig = config;
                            matchingTreeStructure = checkTreeStructure;
                            continue block0;
                        }
                        if (TreeAssist.instance.mcMMO && mcMMOHook.mcMMOTreeFeller(player)) {
                            debug.i("mcMMO Tree Feller!");
                            debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, "Skipping for mcMMO!");
                            matchingTreeConfig = config;
                            matchingTreeStructure = checkTreeStructure;
                            continue block0;
                        }
                        if (config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_REQUIRES_TOOLS) && !ToolUtils.isMatchingTool(player.getInventory().getItemInMainHand(), config) && !TreeAssist.instance.getPlayerListener().isDebugTool(player.getInventory().getItemInMainHand())) {
                            debug.i("Player has not the right tool!");
                            debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, "Player does not have the right tool!");
                            matchingTreeConfig = config;
                            matchingTreeStructure = checkTreeStructure;
                            continue block0;
                        }
                        debug.i("success!");
                        item = player.getInventory().getItemInMainHand();
                        if (!TreeAssist.instance.config().getBoolean(MainConfig.CFG.MODDING_DISABLE_DURABILITY_FIX) && item.hasItemMeta() && item.getItemMeta() != null && !item.getItemMeta().isUnbreakable() && ((durability = (short)((Damageable)item.getItemMeta()).getDamage()) > (maxDurability = item.getType().getMaxDurability()) || durability < 0) && ToolUtils.isVanillaTool(item)) {
                            debug.i("removing item: " + item.getType().name() + " (durability " + durability + ">" + maxDurability);
                            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                            player.updateInventory();
                        }
                        debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, ChatColor.GREEN + "Autochop should work!");
                        checkTreeStructure.discoveryResult = new DiscoveryResult(config, checkTreeStructure, !checkTreeStructure.getConfig().getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_INITIAL_DELAY) || checkTreeStructure.getConfig().getInt(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_INITIAL_DELAY_TIME) <= 0, item, damagePredicted);
                        return checkTreeStructure;
                    }
                    if (config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_FORCED_REMOVAL) || config.getBoolean(TreeConfig.CFG.REPLANTING_ENFORCE) || TreeAssist.instance.getBlockListener().isReplant(player.getName())) {
                        debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, "We might enforce chopping or replanting later!");
                        debug.explain(TreeAssistDebugger.ErrorType.SAPLING, checkBlock, "We might enforce chopping or replanting later!");
                        matchingTreeConfig = config;
                        matchingTreeStructure = checkTreeStructure;
                        continue block0;
                    }
                    if (checkBlock.equals(block) && config.getBoolean(TreeConfig.CFG.REPLANTING_ACTIVE)) {
                        debug.explain(TreeAssistDebugger.ErrorType.SAPLING, checkBlock, ChatColor.GREEN + "Is Bottom Block!");
                        checkTreeStructure.discoveryResult.setOnlyReplant();
                        return checkTreeStructure;
                    }
                }
                debug.i("Shape does not match " + mat + " (" + (Object)((Object)checkTreeStructure.getFailReason()) + ")");
                if (checkTreeStructure.getFailReason() != FailReason.INVALID_BLOCK && checkTreeStructure.getFailReason() != FailReason.INVALID_TRUNK_BLOCK && checkTreeStructure.getFailReason() != FailReason.INVALID_ROOF_BLOCK) continue;
                if (!TreeAssist.instance.getPlayerListener().isDebugTool(player.getInventory().getItemInMainHand()) && player.hasPermission("treeassist.message") && TreeAssist.instance.config().getBoolean(MainConfig.CFG.DESTRUCTION_MESSAGE) && checkTreeStructure.hasFailInformation()) {
                    TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.WARNING_DESTRUCTION_FAILED.parse(checkTreeStructure.discoveryResult.getInformation()));
                } else {
                    debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, "Not a valid tree (" + (Object)((Object)checkTreeStructure.getFailReason()) + ") " + checkTreeStructure.discoveryResult.getInformation());
                }
                return checkTreeStructure;
            }
        }
        if (matchingTreeStructure != null) {
            debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, checkBlock, "Not an exact match found for chopping!");
            matchingTreeStructure.discoveryResult = new DiscoveryResult(matchingTreeConfig, matchingTreeStructure, false);
        }
        return matchingTreeStructure;
    }

    private boolean hasFailInformation() {
        return this.discoveryResult != null && this.discoveryResult.getInformation() != null;
    }

    private FailReason getFailReason() {
        if (this.discoveryResult == null) {
            return null;
        }
        return this.discoveryResult.getReason();
    }

    public TreeConfig getConfig() {
        return this.config;
    }

    private boolean hasDiscoveryFailed() {
        return this.discoveryResult != null && this.discoveryResult.getReason() != null;
    }

    public static void reloadTreeDefinitions() {
        allTrunks.clear();
        allSaplings.clear();
        allExtras.clear();
        TreeAssist.treeConfigs.clear();
        File folder = new File(TreeAssist.instance.getDataFolder().getPath(), "trees");
        HashMap<String, TreeConfig> processing = new HashMap<String, TreeConfig>();
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                for (File subFile : file.listFiles()) {
                    if (!subFile.getName().toLowerCase().endsWith(".yml")) continue;
                    String subNode = subFile.getName().toLowerCase().replace(".yml", "");
                    TreeConfig subTree = new TreeConfig(TreeAssist.instance, subFile);
                    processing.put(subNode, subTree);
                }
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(".yml")) continue;
            String node = file.getName().toLowerCase().replace(".yml", "");
            TreeConfig tree = new TreeConfig(TreeAssist.instance, file);
            processing.put(node, tree);
        }
        for (String key : processing.keySet()) {
            TreeConfig treeConfig = (TreeConfig)processing.get(key);
            TreeConfigUpdater.check(treeConfig, key);
            if (key.equals("default")) {
                treeConfig.clearMaps();
                treeConfig.load();
                continue;
            }
            treeConfig.preLoad();
        }
        int attempts = 100;
        block3: while (--attempts > 0 && processing.size() > 0) {
            for (String key : processing.keySet()) {
                if (TreeAssist.treeConfigs.containsKey(key)) {
                    processing.remove(key);
                    continue block3;
                }
                TreeConfig treeConfig = (TreeConfig)processing.get(key);
                String parentKey = treeConfig.getYamlConfiguration().getString("Parent", null);
                if (parentKey == null) {
                    TreeAssist.treeConfigs.put(key, treeConfig);
                    processing.remove(key);
                    continue block3;
                }
                if (!TreeAssist.treeConfigs.containsKey(parentKey)) continue;
                treeConfig.clearMaps();
                treeConfig.loadDefaults(TreeAssist.treeConfigs.get(parentKey));
                treeConfig.load();
                TreeAssist.treeConfigs.put(key, treeConfig);
                processing.remove(key);
                continue block3;
            }
        }
        for (String key : processing.keySet()) {
            TreeAssist.instance.getLogger().severe("Parent file not found for: " + key);
        }
        ArrayList<String> keys = new ArrayList<String>(TreeAssist.treeConfigs.keySet());
        Collections.reverse(keys);
        LinkedHashMap<String, TreeConfig> reverseMap = new LinkedHashMap<String, TreeConfig>();
        for (String s : keys) {
            reverseMap.put(s, TreeAssist.treeConfigs.get(s));
        }
        TreeAssist.treeConfigs = reverseMap;
    }

    private boolean hasDistanceTo(List<Block> otherTrunks) {
        int radius = this.config.getInt(TreeConfig.CFG.BLOCKS_MIDDLE_RADIUS);
        for (Block block : otherTrunks) {
            for (Block myBlock : this.trunk) {
                if (!(block.getLocation().distance(myBlock.getLocation()) <= (double)radius)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isValid() {
        return this.discoveryResult != null && this.discoveryResult.isValid();
    }

    public boolean containsBlock(Block block) {
        return this.trunk.contains(block) || this.extras.contains(block);
    }

    private int countBranches() {
        int result = 0;
        for (List<Block> list : this.branchMap.values()) {
            if (list == null) continue;
            result += list.size();
        }
        return result;
    }

    private List<Block> findThickBottoms() {
        BlockFace[] faces;
        ArrayList<Block> result = new ArrayList<Block>();
        result.add(this.bottom);
        for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST, BlockFace.EAST}) {
            this.findThickNeighbor(result, this.bottom.getRelative(face), face, true);
        }
        return result;
    }

    private void findThickNeighbor(List<Block> result, Block block, BlockFace direction, boolean first) {
        if (result.contains(block) || !this.trunkBlocks.contains(block.getType())) {
            return;
        }
        if (Math.abs(block.getX() - this.bottom.getX()) > 3 || Math.abs(block.getZ() - this.bottom.getZ()) > 3) {
            debug.i("too far");
            return;
        }
        if (result.size() > 9) {
            debug.i("we found more than enough already");
            return;
        }
        result.add(block);
        debug.i("continuing " + direction);
        this.findThickNeighbor(result, block.getRelative(direction), direction, first);
        if (first) {
            debug.i("branching out");
            if (direction == BlockFace.NORTH || direction == BlockFace.SOUTH) {
                this.findThickNeighbor(result, block.getRelative(BlockFace.EAST), BlockFace.EAST, false);
                this.findThickNeighbor(result, block.getRelative(BlockFace.WEST), BlockFace.WEST, false);
            } else {
                this.findThickNeighbor(result, block.getRelative(BlockFace.NORTH), BlockFace.NORTH, false);
                this.findThickNeighbor(result, block.getRelative(BlockFace.SOUTH), BlockFace.SOUTH, false);
            }
        }
    }

    private List<Block> findTrunk() {
        ArrayList<Block> result = new ArrayList<Block>();
        Block checkBlock = this.bottom;
        block0: while (this.trunkBlocks.contains(checkBlock.getType())) {
            result.add(checkBlock);
            debug.i("Good t block: " + BlockUtils.printBlock(checkBlock));
            checkBlock = checkBlock.getRelative(BlockFace.UP);
            if (!this.trunkDiagonally || this.trunkBlocks.contains(checkBlock.getType())) continue;
            Material checkMaterial = checkBlock.getType();
            debug.i("No more trunk going up at " + checkBlock.getLocation() + " - type: " + checkMaterial);
            if (!MaterialUtils.isAir(checkBlock.getType())) {
                if (this.extraBlocks.contains(checkMaterial)) {
                    debug.i("It's an extra u block: " + BlockUtils.printBlock(checkBlock));
                } else if (this.naturalBlocks.contains(checkMaterial)) {
                    debug.i("It's a natural u block: " + BlockUtils.printBlock(checkBlock));
                } else if (!allTrunks.contains(checkMaterial) && !allExtras.contains(checkMaterial)) {
                    debug.i("Unexpected u block! Not a valid tree!");
                    this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_TRUNK_BLOCK, "block B: " + BlockUtils.printBlock(checkBlock));
                    return null;
                }
            }
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    Material innerCheck = checkBlock.getRelative(x, 0, z).getType();
                    if (this.trunkBlocks.contains(innerCheck)) {
                        checkBlock = checkBlock.getRelative(x, 0, z);
                        continue block0;
                    }
                    debug.i("Checking diagonal at " + checkBlock.getRelative(x, 0, z).getLocation() + " - type: " + innerCheck);
                    if (MaterialUtils.isAir(innerCheck)) continue;
                    if (this.extraBlocks.contains(innerCheck)) {
                        debug.i("It's an extra l block: " + BlockUtils.printBlock(checkBlock));
                        continue;
                    }
                    if (this.naturalBlocks.contains(innerCheck)) {
                        debug.i("It's a natural l block " + BlockUtils.printBlock(checkBlock));
                        continue;
                    }
                    if (allTrunks.contains(innerCheck) || allExtras.contains(innerCheck)) continue;
                    debug.i("Unexpected l block! Not a valid tree!");
                    this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_TRUNK_BLOCK, "block C: " + BlockUtils.printBlock(checkBlock));
                    return null;
                }
            }
        }
        if (allExtras.contains(checkBlock.getType()) || allNaturals.contains(checkBlock.getType()) || MaterialUtils.isAir(checkBlock.getType())) {
            debug.i("We hit the roof!");
            return result;
        }
        debug.i("We did not find a roof block (" + checkBlock.getType() + ") not a valid tree!");
        this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_ROOF_BLOCK, "block F: " + BlockUtils.printBlock(checkBlock));
        return null;
    }

    private List<Block> findTrunkGreedy() {
        ArrayList<Block> result = new ArrayList<Block>();
        Block checkBlock = this.bottom;
        if (this.trunkBlocks.contains(checkBlock.getType())) {
            if (this.greedyBranches(result, checkBlock) == null) {
                return null;
            }
        } else {
            return result;
        }
        checkBlock = this.findTopBlock(result);
        if (checkBlock == null) {
            this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_ROOF_BLOCK);
            return null;
        }
        debug.i("highest block: " + BlockUtils.printBlock(checkBlock));
        checkBlock = checkBlock.getRelative(BlockFace.UP);
        debug.i("roof block: " + BlockUtils.printBlock(checkBlock));
        if (allExtras.contains(checkBlock.getType()) || allNaturals.contains(checkBlock.getType()) || MaterialUtils.isAir(checkBlock.getType())) {
            debug.i("We hit the roof!");
            return result;
        }
        debug.i("We did not find a roof block (" + checkBlock.getType() + ") not a valid tree!");
        this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_ROOF_BLOCK, "block E: " + BlockUtils.printBlock(checkBlock));
        return null;
    }

    private Block findTopBlock(List<Block> blocks) {
        int max = -100;
        Block result = null;
        for (Block b : blocks) {
            if (b.getY() <= max) continue;
            max = b.getY();
            result = b;
        }
        return result;
    }

    private List<Block> greedyBranches(List<Block> blocks, Block block) {
        if (blocks == null) {
            return null;
        }
        if (blocks.contains(block)) {
            return blocks;
        }
        int grounds = 0;
        debug.i("checking branch ground at level " + block.getY());
        if (this.groundBlocks.contains(block.getRelative(BlockFace.NORTH).getType())) {
            ++grounds;
        }
        if (this.groundBlocks.contains(block.getRelative(BlockFace.SOUTH).getType())) {
            ++grounds;
        }
        if (this.groundBlocks.contains(block.getRelative(BlockFace.WEST).getType())) {
            ++grounds;
        }
        if (this.groundBlocks.contains(block.getRelative(BlockFace.EAST).getType())) {
            ++grounds;
        }
        if (grounds > 2) {
            return blocks;
        }
        if (this.trunkBlocks.contains(block.getType())) {
            debug.i("Good g block: " + BlockUtils.printBlock(block));
            blocks.add(block);
            if (this.greedyBranches(blocks, block.getRelative(BlockFace.EAST)) == null) {
                return null;
            }
            if (this.greedyBranches(blocks, block.getRelative(BlockFace.WEST)) == null) {
                return null;
            }
            if (this.greedyBranches(blocks, block.getRelative(BlockFace.SOUTH)) == null) {
                return null;
            }
            if (this.greedyBranches(blocks, block.getRelative(BlockFace.NORTH)) == null) {
                return null;
            }
            if (this.config.getBoolean(TreeConfig.CFG.TRUNK_DIAGONAL)) {
                if (this.greedyBranches(blocks, block.getRelative(BlockFace.EAST).getRelative(BlockFace.UP)) == null) {
                    return null;
                }
                if (this.greedyBranches(blocks, block.getRelative(BlockFace.WEST).getRelative(BlockFace.UP)) == null) {
                    return null;
                }
                if (this.greedyBranches(blocks, block.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP)) == null) {
                    return null;
                }
                if (this.greedyBranches(blocks, block.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP)) == null) {
                    return null;
                }
                this.greedyBranches(blocks, block.getRelative(BlockFace.EAST).getRelative(BlockFace.DOWN));
                this.greedyBranches(blocks, block.getRelative(BlockFace.WEST).getRelative(BlockFace.DOWN));
                this.greedyBranches(blocks, block.getRelative(BlockFace.SOUTH).getRelative(BlockFace.DOWN));
                this.greedyBranches(blocks, block.getRelative(BlockFace.NORTH).getRelative(BlockFace.DOWN));
            }
            if (this.greedyBranches(blocks, block.getRelative(BlockFace.UP)) == null) {
                return null;
            }
            return blocks;
        }
        if (!MaterialUtils.isAir(block.getType())) {
            if (this.extraBlocks.contains(block.getType())) {
                debug.i("It's an extra g block: " + BlockUtils.printBlock(block));
            } else if (this.naturalBlocks.contains(block.getType())) {
                debug.i("It's a natural g block: " + BlockUtils.printBlock(block));
            } else if (!(TreeAssist.instance.config().getBoolean(MainConfig.CFG.GENERAL_AUTODESTRUCT_IGNORES_UNEXPECTED_BLOCKS) || allTrunks.contains(block.getType()) || allExtras.contains(block.getType()))) {
                debug.i("Unexpected g block! Not a valid tree!");
                this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_TRUNK_BLOCK, "block F: " + BlockUtils.printBlock(block));
                return null;
            }
        }
        return blocks;
    }

    private List<Block> findTrunks(List<Block> bottoms) {
        ArrayList<Block> result = new ArrayList<Block>();
        for (Block checkBlock : bottoms) {
            while (this.trunkBlocks.contains(checkBlock.getType())) {
                result.add(checkBlock);
                checkBlock = checkBlock.getRelative(BlockFace.UP);
            }
            if (allExtras.contains(checkBlock.getType()) || allNaturals.contains(checkBlock.getType()) || MaterialUtils.isAir(checkBlock.getType())) {
                debug.i("We hit the roof!");
                this.roofs.add(checkBlock);
                continue;
            }
            debug.i("We did not find a roof block (" + checkBlock.getType() + ") not a valid tree!");
            this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_ROOF_BLOCK, "block G: " + BlockUtils.printBlock(checkBlock));
            return null;
        }
        return result;
    }

    private void findOtherTrunks() {
        int radius = this.config.getInt(TreeConfig.CFG.BLOCKS_MIDDLE_RADIUS) * 2;
        int totalChecks = 0;
        for (int x = -radius; x <= radius; ++x) {
            block1: for (int z = -radius; z <= radius; ++z) {
                if (x == 0 && z == 0) continue;
                Block checkBlock = this.bottom.getRelative(x, 4, z);
                int y = checkBlock.getY();
                int checks = 255;
                while (checks-- > 0) {
                    ++totalChecks;
                    if (this.trunk.contains(checkBlock = checkBlock.getRelative(BlockFace.DOWN)) || checkBlock.getType().equals((Object)Material.BEDROCK)) continue block1;
                    if (this.trunkBlocks.contains(checkBlock.getType())) {
                        Block block = TreeStructure.findBottomBlock(null, checkBlock, this.config, true);
                        if (block != null && this.isNotOurBottom(block)) {
                            TreeStructure otherTree = new TreeStructure(this.config, block, true);
                            if (otherTree.isValid()) {
                                this.neighborTrunks.addAll(otherTree.trunk);
                                debug.i("Found another tree at " + block.getLocation() + " - " + otherTree.trunk.size());
                                continue block1;
                            }
                            if (this.config.getParent() != null && (otherTree = new TreeStructure(this.config.getParent(), block, true)).isValid()) {
                                this.neighborTrunks.addAll(otherTree.trunk);
                                debug.i("Found another tree at " + block.getLocation() + " - " + otherTree.trunk.size());
                                continue block1;
                            }
                        }
                    } else if (this.groundBlocks.contains(checkBlock.getType())) continue block1;
                    --y;
                }
            }
        }
        debug.i("total checks: " + totalChecks);
    }

    private boolean isNotOurBottom(Block block) {
        if (block.equals(this.bottom)) {
            return false;
        }
        return !block.equals(this.northEastBlock) && !block.equals(this.northWestBlock) && !block.equals(this.southEastBlock) && !block.equals(this.southWestBlock);
    }

    private void getAllBranches() {
        boolean first = true;
        BlockFace[] directions = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.NORTH_EAST, BlockFace.SOUTH_WEST};
        for (Block block : this.trunk) {
            if (first) {
                first = false;
                continue;
            }
            for (BlockFace face : directions) {
                Block checkBlock = block.getRelative(face);
                if (this.trunkBlocks.contains(checkBlock.getType())) {
                    ArrayList<Block> branch = new ArrayList<Block>();
                    for (BlockFace innerface : continuations.get(face)) {
                        if (!this.isInvalidBranch(checkBlock, branch, innerface)) continue;
                        this.trunk.clear();
                        this.branchMap.clear();
                        return;
                    }
                    this.branchMap.put(checkBlock, branch);
                    continue;
                }
                if (TreeAssist.instance.config().getBoolean(MainConfig.CFG.GENERAL_AUTODESTRUCT_IGNORES_UNEXPECTED_BLOCKS) || allExtras.contains(checkBlock.getType()) || allTrunks.contains(checkBlock.getType()) || this.naturalBlocks.contains(checkBlock.getType())) continue;
                debug.i("invalid block 2a: " + checkBlock.getType());
                this.trunk.clear();
                this.branchMap.clear();
                this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_BLOCK, "block H: " + BlockUtils.printBlock(checkBlock));
                return;
            }
        }
    }

    private void getAllExtras() {
        this.extras = new LinkedHashSet<Block>();
        int radiusM = this.config.getInt(TreeConfig.CFG.BLOCKS_MIDDLE_RADIUS);
        boolean edgesM = this.config.getBoolean(TreeConfig.CFG.BLOCKS_MIDDLE_EDGES);
        boolean airM = this.config.getBoolean(TreeConfig.CFG.BLOCKS_MIDDLE_AIR);
        Block roof = null;
        BlockFace[] neighbors = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
        Iterator<Block> iterator = this.trunk.iterator();
        while (iterator.hasNext()) {
            Block block;
            roof = block = iterator.next();
            for (BlockFace face : neighbors) {
                if (!this.hasInvalidExtraBlock(block.getRelative(face), face, radiusM, 1, true, edgesM, airM, radiusM)) continue;
                return;
            }
        }
        if (roof == null) {
            debug.i("No more blocks found!");
            this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.NO_TRUNK);
            return;
        }
        int radiusT = this.config.getInt(TreeConfig.CFG.BLOCKS_TOP_RADIUS);
        int heightT = this.config.getInt(TreeConfig.CFG.BLOCKS_TOP_HEIGHT);
        boolean airT = this.config.getBoolean(TreeConfig.CFG.BLOCKS_TOP_AIR);
        boolean edgesT = this.config.getBoolean(TreeConfig.CFG.BLOCKS_TOP_EDGES);
        for (int y = 0; y <= heightT; ++y) {
            Block checkBlock = roof.getRelative(0, y, 0);
            Material checkMaterial = checkBlock.getType();
            if (MaterialUtils.isAir(checkMaterial)) continue;
            if (this.extraBlocks.contains(checkMaterial)) {
                this.extras.add(checkBlock);
                for (BlockFace face : neighbors) {
                    if (!this.hasInvalidExtraBlock(checkBlock.getRelative(face), face, radiusT, 1, true, edgesT, airT, radiusT)) continue;
                    return;
                }
                continue;
            }
            if (TreeAssist.instance.config().getBoolean(MainConfig.CFG.GENERAL_AUTODESTRUCT_IGNORES_UNEXPECTED_BLOCKS) || this.naturalBlocks.contains(checkMaterial) || this.trunkBlocks.contains(checkMaterial) || allTrunks.contains(checkMaterial) || allExtras.contains(checkMaterial)) continue;
            this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_BLOCK, "block I: " + BlockUtils.printBlock(checkBlock));
            debug.i("invalid block at " + BlockUtils.printBlock(checkBlock));
            return;
        }
        this.addCapLeaves();
    }

    private void getDirectionalBranches() {
        ArrayList<Object> branch;
        Block checkBlock;
        BlockFace[] directions;
        boolean first = true;
        ArrayList<Block> checkRoofs = new ArrayList<Block>(this.roofs);
        for (Block block : checkRoofs) {
            for (BlockFace face : directions = this.getTrunkContinuations(block)) {
                checkBlock = block.getRelative(face);
                if (!this.isInvalidBranch(checkBlock, branch = new ArrayList<Block>(), face)) {
                    this.branchMap.put(checkBlock, branch);
                    continue;
                }
                if (this.isInvalidBranch(checkBlock = checkBlock.getRelative(BlockFace.UP), branch, face)) continue;
                this.branchMap.put(checkBlock, branch);
            }
        }
        for (Block block : this.trunk) {
            if (first) {
                first = false;
                continue;
            }
            for (BlockFace face : directions = this.getTrunkContinuations(block)) {
                checkBlock = block.getRelative(face);
                if (this.trunkBlocks.contains(checkBlock.getType())) {
                    branch = new ArrayList();
                    if (this.isInvalidBranch(checkBlock, branch, face)) {
                        this.trunk.clear();
                        this.branchMap.clear();
                        return;
                    }
                    this.branchMap.put(checkBlock, branch);
                    continue;
                }
                if (!(TreeAssist.instance.config().getBoolean(MainConfig.CFG.GENERAL_AUTODESTRUCT_IGNORES_UNEXPECTED_BLOCKS) || allExtras.contains(checkBlock.getType()) || allTrunks.contains(checkBlock.getType()) || this.naturalBlocks.contains(checkBlock.getType()))) {
                    debug.i("invalid block 2b: " + checkBlock.getType());
                    this.trunk.clear();
                    this.branchMap.clear();
                    this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_BLOCK, "block J: " + BlockUtils.printBlock(checkBlock));
                    return;
                }
                if (this.trunk.contains(block)) continue;
                this.caps.add(block);
            }
        }
    }

    public List<Block> getBlocks() {
        ArrayList<Block> result = new ArrayList<Block>(this.trunk);
        if (this.branchMap == null || this.branchMap.isEmpty()) {
            return result;
        }
        for (List<Block> list : this.branchMap.values()) {
            if (list == null || list.isEmpty()) continue;
            result.addAll(list);
        }
        return result;
    }

    public List<Block> getExtraBlocks() {
        ArrayList<Block> result = new ArrayList<Block>();
        if (this.extras == null || this.extras.isEmpty()) {
            return result;
        }
        result.addAll(this.extras);
        return result;
    }

    public List<Block> getTrunk() {
        return this.trunk;
    }

    private void addCapLeaves() {
        debug.i("adding leaves around caps");
        int radiusC = this.config.getInt(TreeConfig.CFG.BLOCKS_CAP_RADIUS);
        int heightC = this.config.getInt(TreeConfig.CFG.BLOCKS_CAP_HEIGHT);
        BlockFace[] neighbors = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
        for (Block block : this.caps) {
            for (int y = 0; y <= heightC; ++y) {
                Block checkBlock = block.getRelative(0, y, 0);
                Material checkMaterial = checkBlock.getType();
                debug.i("checking cap: " + BlockUtils.printBlock(checkBlock));
                if (MaterialUtils.isAir(checkMaterial)) continue;
                if (this.extraBlocks.contains(checkMaterial)) {
                    this.extras.add(checkBlock);
                    for (BlockFace face : neighbors) {
                        if (!this.hasInvalidExtraBlock(checkBlock.getRelative(face), face, radiusC, 1, true, false, false, radiusC)) continue;
                        return;
                    }
                    continue;
                }
                if (!(TreeAssist.instance.config().getBoolean(MainConfig.CFG.GENERAL_AUTODESTRUCT_IGNORES_UNEXPECTED_BLOCKS) || this.naturalBlocks.contains(checkMaterial) || this.trunkBlocks.contains(checkMaterial) || allTrunks.contains(checkMaterial) || allExtras.contains(checkMaterial))) {
                    this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_BLOCK, "block K: " + BlockUtils.printBlock(checkBlock));
                    debug.i("invalid block at " + BlockUtils.printBlock(checkBlock));
                    return;
                }
                if (!this.trunkBlocks.contains(checkMaterial)) continue;
                for (BlockFace face : neighbors) {
                    if (!this.hasInvalidExtraBlock(checkBlock.getRelative(face), face, radiusC, 1, true, false, false, radiusC)) continue;
                    return;
                }
            }
        }
    }

    private void getDirectionalExtras() {
        this.extras = new LinkedHashSet<Block>();
        int radiusM = this.config.getInt(TreeConfig.CFG.BLOCKS_MIDDLE_RADIUS);
        boolean edgesM = this.config.getBoolean(TreeConfig.CFG.BLOCKS_MIDDLE_EDGES);
        boolean airM = this.config.getBoolean(TreeConfig.CFG.BLOCKS_MIDDLE_AIR);
        for (Block checkBlock : this.trunk) {
            for (BlockFace face : this.getTrunkContinuations(checkBlock)) {
                if (!this.hasInvalidExtraBlock(checkBlock.getRelative(face), face, radiusM, 1, true, edgesM, airM, radiusM)) continue;
                return;
            }
        }
        BlockFace[] neighbors = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
        if (this.roofs.size() <= 0) {
            debug.i("No more blocks found!");
            this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.NO_TRUNK);
            return;
        }
        int radiusT = this.config.getInt(TreeConfig.CFG.BLOCKS_TOP_RADIUS);
        int heightT = this.config.getInt(TreeConfig.CFG.BLOCKS_TOP_HEIGHT);
        boolean airT = this.config.getBoolean(TreeConfig.CFG.BLOCKS_TOP_AIR);
        boolean edgesT = this.config.getBoolean(TreeConfig.CFG.BLOCKS_TOP_EDGES);
        debug.i("checking roof!");
        for (Block roof : this.roofs) {
            for (int y = 0; y <= heightT; ++y) {
                Block checkBlock = roof.getRelative(0, y, 0);
                debug.i("checking: " + BlockUtils.printBlock(checkBlock));
                Material checkMaterial = checkBlock.getType();
                if (MaterialUtils.isAir(checkMaterial)) continue;
                if (this.extraBlocks.contains(checkMaterial)) {
                    this.extras.add(checkBlock);
                    for (BlockFace face : neighbors) {
                        if (!this.hasInvalidExtraBlock(checkBlock.getRelative(face), face, radiusT, 1, true, edgesT, airT, radiusT)) continue;
                        return;
                    }
                    continue;
                }
                if (TreeAssist.instance.config().getBoolean(MainConfig.CFG.GENERAL_AUTODESTRUCT_IGNORES_UNEXPECTED_BLOCKS) || this.naturalBlocks.contains(checkMaterial) || this.trunkBlocks.contains(checkMaterial) || allTrunks.contains(checkMaterial) || allExtras.contains(checkMaterial)) continue;
                this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_BLOCK, "block L: " + BlockUtils.printBlock(checkBlock));
                debug.i("invalid block at " + BlockUtils.printBlock(checkBlock));
                return;
            }
        }
        this.addCapLeaves();
    }

    private BlockFace[] getTrunkContinuations(Block checkBlock) {
        if (this.northWestBlock != null && checkBlock.getX() == this.northWestBlock.getX() && checkBlock.getZ() == this.northWestBlock.getZ()) {
            return continuations.get(BlockFace.NORTH_WEST);
        }
        if (this.northEastBlock != null && checkBlock.getX() == this.northEastBlock.getX() && checkBlock.getZ() == this.northEastBlock.getZ()) {
            return continuations.get(BlockFace.NORTH_EAST);
        }
        if (this.southWestBlock != null && checkBlock.getX() == this.southWestBlock.getX() && checkBlock.getZ() == this.southWestBlock.getZ()) {
            return continuations.get(BlockFace.SOUTH_WEST);
        }
        if (this.southEastBlock != null && checkBlock.getX() == this.southEastBlock.getX() && checkBlock.getZ() == this.southEastBlock.getZ()) {
            return continuations.get(BlockFace.SOUTH_EAST);
        }
        return new BlockFace[0];
    }

    private boolean isInvalidBranch(Block checkBlock, List<Block> result, BlockFace direction) {
        Material mat;
        if (this.checkedBlocks.contains(checkBlock)) {
            return false;
        }
        this.checkedBlocks.add(checkBlock);
        BlockFace[] diagonals = diagonalContinuations.get(direction);
        if (diagonals == null) {
            diagonals = new BlockFace[]{direction};
        }
        if (this.trunkBlocks.contains(mat = checkBlock.getType())) {
            Block otherBlock = TreeStructure.findBottomBlock(null, checkBlock, this.config, true);
            if (otherBlock != null) {
                TreeStructure anotherTree = new TreeStructure(this.config, otherBlock, true);
                if (anotherTree.isValid() && !anotherTree.bottom.equals(this.bottom)) {
                    this.neighborTrunks.addAll(anotherTree.trunk);
                    debug.i("We hit a neighbor tree! Our bottom block " + this.bottom.getLocation() + " is not the same as " + anotherTree.bottom.getLocation());
                    return false;
                }
                if (this.config.getParent() != null && (anotherTree = new TreeStructure(this.config.getParent(), otherBlock, true)).isValid() && !anotherTree.bottom.equals(this.bottom)) {
                    this.neighborTrunks.addAll(anotherTree.trunk);
                    debug.i("We hit a neighbor tree! Our bottom block " + this.bottom.getLocation() + " is not the same as " + anotherTree.bottom.getLocation());
                    return false;
                }
            }
            result.add(checkBlock);
            debug.i("Adding " + BlockUtils.printBlock(checkBlock));
            for (BlockFace face : diagonals) {
                debug.i("Continuing branch " + direction + " to " + face);
                if (!this.isInvalidBranch(checkBlock.getRelative(face), result, direction) && !this.isInvalidBranch(checkBlock.getRelative(face).getRelative(BlockFace.UP), result, direction) && !this.isInvalidBranch(checkBlock.getRelative(face).getRelative(BlockFace.DOWN), result, direction)) continue;
                result.clear();
                return true;
            }
            if (this.isInvalidBranch(checkBlock.getRelative(BlockFace.UP), result, direction)) {
                result.clear();
                return true;
            }
        } else {
            if (this.extraBlocks.contains(mat)) {
                debug.i("This branch ends now.");
                this.caps.add(checkBlock.getRelative(direction, -1));
                return false;
            }
            if (!(TreeAssist.instance.config().getBoolean(MainConfig.CFG.GENERAL_AUTODESTRUCT_IGNORES_UNEXPECTED_BLOCKS) || this.naturalBlocks.contains(mat) || allTrunks.contains(mat) || allExtras.contains(mat))) {
                debug.i("invalid block 3: " + mat);
                this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_BLOCK, "block M: " + BlockUtils.printBlock(checkBlock));
                return true;
            }
        }
        return false;
    }

    private boolean hasInvalidExtraBlock(Block checkBlock, BlockFace direction, int expansion, int progress, boolean first, boolean edges, boolean air, int radius) {
        int squaredRadius = radius * radius;
        for (Block otherBlock : this.neighborTrunks) {
            if (!(otherBlock.getLocation().distanceSquared(checkBlock.getLocation()) <= (double)squaredRadius)) continue;
            return false;
        }
        Material checkMaterial = checkBlock.getType();
        if (!air && MaterialUtils.isAir(checkMaterial)) {
            return false;
        }
        boolean found = air;
        if (this.config.getBoolean(TreeConfig.CFG.BLOCKS_VINES) && checkBlock.getType() == Material.VINE) {
            this.followVines(checkBlock);
        }
        if (this.extraBlocks.contains(checkMaterial)) {
            this.extras.add(checkBlock);
            found = true;
        }
        if (found) {
            if (first) {
                boolean shorter;
                boolean bl = shorter = !edges && progress == expansion;
                if (direction == BlockFace.EAST || direction == BlockFace.WEST ? this.hasInvalidExtraBlock(checkBlock.getRelative(BlockFace.SOUTH), BlockFace.SOUTH, shorter ? progress - 1 : progress, 1, false, edges, air, radius) || this.hasInvalidExtraBlock(checkBlock.getRelative(BlockFace.NORTH), BlockFace.NORTH, progress, 1, false, edges, air, radius) : this.hasInvalidExtraBlock(checkBlock.getRelative(BlockFace.EAST), BlockFace.EAST, progress, 1, false, edges, air, radius) || this.hasInvalidExtraBlock(checkBlock.getRelative(BlockFace.WEST), BlockFace.WEST, progress, 1, false, edges, air, radius)) {
                    return true;
                }
            }
            if (progress < expansion) {
                return this.hasInvalidExtraBlock(checkBlock.getRelative(direction), direction, expansion, progress + 1, first, edges, air, radius);
            }
        } else if (!(TreeAssist.instance.config().getBoolean(MainConfig.CFG.GENERAL_AUTODESTRUCT_IGNORES_UNEXPECTED_BLOCKS) || this.naturalBlocks.contains(checkMaterial) || this.trunkBlocks.contains(checkMaterial) || allTrunks.contains(checkMaterial) || allExtras.contains(checkMaterial))) {
            debug.i("Invalid block found 1: " + BlockUtils.printBlock(checkBlock));
            this.discoveryResult = new DiscoveryResult(this.config, this, FailReason.INVALID_BLOCK, "block N: " + BlockUtils.printBlock(checkBlock));
            return true;
        }
        return false;
    }

    private void followVines(Block checkBlock) {
        if (this.extras.contains(checkBlock) || checkBlock.getType() != Material.VINE) {
            return;
        }
        this.extras.add(checkBlock);
        this.followVines(checkBlock.getRelative(0, -1, 0));
    }

    private void maybeBreakBlock(Block block, ItemStack tool, Player player, boolean statPickup, boolean statMineBlock, boolean toolDamage, boolean creative) {
        ItemMeta meta;
        TATreeBlockBrokenEvent event = new TATreeBlockBrokenEvent(this, block, player, tool);
        TreeAssist.instance.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            debug.i(">>> Cancelled by plugin! <<< Aborting breaking!");
            return;
        }
        Material blockMaterial = block.getType();
        boolean calculateCustomDrops = !creative && this.config.getBoolean(TreeConfig.CFG.BLOCKS_CUSTOM_DROPS_ACTIVE) && this.extraBlocks.contains(blockMaterial) || this.config.getBoolean(TreeConfig.CFG.TRUNK_CUSTOM_DROPS_ACTIVE) && this.trunkBlocks.contains(blockMaterial);
        double chanceValue = new Random().nextDouble();
        debug.i("breaking " + blockMaterial + ". custom drops: " + calculateCustomDrops + " - roll: " + chanceValue);
        if (creative) {
            debug.i("no custom drops because in creative mode!");
        } else if (this.extraBlocks.contains(blockMaterial) && !calculateCustomDrops) {
            debug.i("no custom drops because not activated for leaves");
        } else if (this.trunkBlocks.contains(blockMaterial) && !calculateCustomDrops) {
            debug.i("no custom drops because not activated for trunk");
        }
        BlockUtils.callExternals(block, player, false);
        CommandUtils.commitBlock(player, this.config);
        boolean isTrunk = this.trunkBlocks.contains(blockMaterial);
        if (calculateCustomDrops && tool != null) {
            double chance = isTrunk ? this.config.getMapEntry(TreeConfig.CFG.TRUNK_CUSTOM_DROPS_FACTORS, tool.getType().name(), 0.0) : this.config.getMapEntry(TreeConfig.CFG.BLOCKS_CUSTOM_DROPS_FACTORS, tool.getType().name(), 0.0);
            debug.i("probability " + chance + " for " + tool.getType().name());
            double secondChance = isTrunk ? this.config.getMapEntry(TreeConfig.CFG.TRUNK_CUSTOM_DROPS_FACTORS, "minecraft:" + tool.getType().name().toLowerCase(), 0.0) : this.config.getMapEntry(TreeConfig.CFG.BLOCKS_CUSTOM_DROPS_FACTORS, "minecraft:" + tool.getType().name().toLowerCase(), 0.0);
            debug.i("probability " + secondChance + " for " + tool.getType().name().toLowerCase());
            if (secondChance > chance) {
                chance = secondChance;
            }
            if (chance > 0.99 || chanceValue < chance) {
                debug.i("dropping custom drop!");
                Map<String, Double> chances = isTrunk ? this.config.getMap(TreeConfig.CFG.TRUNK_CUSTOM_DROPS_ITEMS) : this.config.getMap(TreeConfig.CFG.BLOCKS_CUSTOM_DROPS_ITEMS);
                debug.i("custom drop count: " + chances.size());
                for (String key : chances.keySet()) {
                    double innerChance = chances.get(key);
                    double innerValue = new Random().nextDouble();
                    if (innerValue < innerChance) {
                        debug.i("dropping: " + key);
                        try {
                            Material mat = Material.matchMaterial((String)key);
                            debug.i(">2 : " + mat.name());
                            block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(mat));
                        }
                        catch (Exception e) {
                            TreeAssist.instance.getLogger().warning("Invalid config value: Custom Drops." + key + " is not a valid Material!");
                        }
                        continue;
                    }
                    debug.i(innerValue + " >= " + innerChance);
                }
            }
        } else {
            debug.i("mat: " + blockMaterial.name());
        }
        TreeAssist.instance.blockList.logBreak(block, player);
        if (player == null) {
            debug.i("breaking block [maybeBreakBlock] without player: " + BlockUtils.printBlock(block));
            BlockUtils.breakBlock(null, block, tool, this.bottom.getY());
            return;
        }
        if (statMineBlock) {
            player.incrementStatistic(Statistic.MINE_BLOCK, blockMaterial);
        }
        if (this.config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_AUTO_ADD_TO_INVENTORY) && (!this.config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_AUTO_ADD_ONLY_LOGS_TO_INVENTORY) || MaterialUtils.isLog(blockMaterial))) {
            debug.i("breaking block [maybeBreakBlock] because of auto adding: " + BlockUtils.printBlock(block));
            if (statPickup) {
                player.incrementStatistic(Statistic.PICKUP, blockMaterial);
            }
            ArrayList drops = new ArrayList(block.getDrops(new ItemStack(tool == null ? Material.AIR : tool.getType(), 1)));
            HashMap didNotFit = player.getInventory().addItem(drops.toArray(new ItemStack[0]));
            if (this.config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_AUTO_ADD_DROP_FAILED)) {
                for (ItemStack item : didNotFit.values()) {
                    player.getWorld().dropItem(player.getLocation(), item);
                }
            }
            block.setType(Material.AIR, true);
        } else {
            debug.i("not auto adding!");
            if (this.config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_USE_SILK_TOUCH) && tool != null && tool.hasItemMeta() && tool.getItemMeta().getEnchants().containsKey(Enchantment.SILK_TOUCH) && MaterialUtils.isMushroom(blockMaterial)) {
                debug.i("breaking block because of silk touching mushroom: " + BlockUtils.printBlock(block));
                block.setType(Material.AIR, true);
                block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(blockMaterial, 1));
                if (this.config.getBoolean(TreeConfig.CFG.BLOCK_STATISTICS_MINE_BLOCK)) {
                    player.incrementStatistic(Statistic.MINE_BLOCK, blockMaterial);
                }
            } else {
                ItemStack anotherTool = tool;
                if (tool != null && !this.config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_USE_SILK_TOUCH)) {
                    debug.i("duplicating tool of type " + tool.getType());
                    anotherTool = new ItemStack(tool.getType(), tool.getAmount());
                } else if (MaterialUtils.isLeaf(blockMaterial) && this.config.getBoolean(TreeConfig.CFG.BLOCKS_CUSTOM_DROPS_OVERRIDE)) {
                    debug.i("nulling tool for leaf " + BlockUtils.printBlock(block));
                    anotherTool = null;
                } else if (MaterialUtils.isLog(blockMaterial) && this.config.getBoolean(TreeConfig.CFG.TRUNK_CUSTOM_DROPS_OVERRIDE)) {
                    debug.i("nulling tool for log " + BlockUtils.printBlock(block));
                    anotherTool = null;
                } else {
                    debug.i("simply breaking " + BlockUtils.printBlock(block));
                    debug.i("tool used: " + ToolUtils.printTool(anotherTool));
                }
                debug.i("breaking with player: " + BlockUtils.printBlock(block));
                BlockUtils.breakBlock(player, block, anotherTool, this.bottom.getY());
            }
        }
        player.sendBlockChange(block.getLocation(), Material.AIR.createBlockData());
        if (!this.config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_TOOL_DAMAGE_FOR_LEAVES) && MaterialUtils.isLeaf(blockMaterial)) {
            debug.i("skipping damage because of nodamage setting in config");
            return;
        }
        if (!toolDamage) {
            debug.i("skipping damage for other reasons");
            return;
        }
        int damage = ToolUtils.calculateDamage(this.config, tool);
        if (damage > 0 && !calculateCustomDrops && tool != null && (meta = tool.getItemMeta()) != null) {
            ((Damageable)meta).setDamage(((Damageable)meta).getDamage() + damage);
            tool.setItemMeta(meta);
        }
    }

    public void maybeReplant(Player player, Block block) {
        debug.i("Maybe replanting?");
        if (!this.config.getBoolean(TreeConfig.CFG.REPLANTING_ACTIVE)) {
            debug.i("replanting is disabled!");
            debug.explain(TreeAssistDebugger.ErrorType.SAPLING, block, "Config " + this.config.getConfigName() + " does not want replanting.");
            return;
        }
        if (TreeAssist.instance.getBlockListener().isNoReplant(player.getName())) {
            debug.i("Player is NoReplant!");
            debug.explain(TreeAssistDebugger.ErrorType.SAPLING, block, "Player is temporarily not replanting.");
            return;
        }
        MainConfig globalConfig = TreeAssist.instance.config();
        if (TreeAssist.instance.getBlockListener().isReplant(player.getName()) || !this.config.getBoolean(TreeConfig.CFG.REPLANTING_ENFORCE)) {
            if (globalConfig.getBoolean(MainConfig.CFG.GENERAL_USE_PERMISSIONS) && !player.hasPermission("treeassist.replant")) {
                debug.i("Player has no replant perms!");
                debug.explain(TreeAssistDebugger.ErrorType.SAPLING, block, "Player does not have replant perms.");
                return;
            }
            if (this.config.getBoolean(TreeConfig.CFG.REPLANTING_REQUIRES_TOOLS) && !ToolUtils.isMatchingTool(player.getInventory().getItemInMainHand(), this.config)) {
                debug.i("Player does not have the tool!!");
                debug.explain(TreeAssistDebugger.ErrorType.SAPLING, block, "Player does not have the tool required by config " + this.config.getConfigName() + ", no replanting.");
                return;
            }
            if (!(block.equals(this.bottom) || block.equals(this.northWestBlock) || block.equals(this.southWestBlock) || block.equals(this.northEastBlock) || block.equals(this.southEastBlock) || !this.config.getBoolean(TreeConfig.CFG.REPLANTING_ONLY_WHEN_BOTTOM_BLOCK_BROKEN_FIRST))) {
                debug.i("We did not break the bottom!");
                debug.explain(TreeAssistDebugger.ErrorType.SAPLING, block, "Config " + this.config.getConfigName() + " requires bottom block being broken for replanting.");
                return;
            }
        }
        debug.i("we are replacing now!");
        int delay = Math.max(1, this.config.getInt(TreeConfig.CFG.REPLANTING_DELAY));
        Material saplingMat = this.config.getMaterial(TreeConfig.CFG.REPLANTING_MATERIAL);
        ArrayList<Block> bottoms = new ArrayList<Block>();
        if (this.bottom != null) {
            bottoms.add(this.bottom);
        }
        if (this.northWestBlock != null) {
            bottoms.add(this.northWestBlock);
        }
        if (this.southWestBlock != null) {
            bottoms.add(this.southWestBlock);
        }
        if (this.northEastBlock != null) {
            bottoms.add(this.northEastBlock);
        }
        if (this.southEastBlock != null) {
            bottoms.add(this.southEastBlock);
        }
        for (Block saplingBlock : bottoms) {
            debug.i("checking bottom: " + BlockUtils.printBlock(saplingBlock));
            TASaplingPlaceEvent placeEvent = new TASaplingPlaceEvent(saplingBlock, saplingMat);
            TreeAssist.instance.getServer().getPluginManager().callEvent((Event)placeEvent);
            if (placeEvent.isCancelled()) {
                debug.i("Sapling placement was cancelled by a plugin!");
                debug.explain(TreeAssistDebugger.ErrorType.SAPLING, block, "Another config cancelled replanting.");
                continue;
            }
            debug.explain(TreeAssistDebugger.ErrorType.SAPLING, block, ChatColor.GREEN + "We should be replanting.");
            TreeAssistReplant b = new TreeAssistReplant(saplingBlock, placeEvent.getType(), this.config);
            this.saplings.add(new TreeAssistReplantDelay(this, saplingBlock, b, delay, null, false));
        }
    }

    public void removeBlocksBelow(Block block) {
        ArrayList<Block> removals = new ArrayList<Block>();
        for (Block b : this.trunk) {
            if (b.getY() >= block.getY()) continue;
            removals.add(b);
        }
        this.trunk.removeAll(removals);
        removals.clear();
        for (Block b : this.extras) {
            if (b.getY() >= block.getY()) continue;
            removals.add(b);
        }
        this.extras.removeAll(removals);
    }

    public void removeTreeLater(final Player player, final ItemStack tool, int damagePredicted) {
        boolean damage;
        final boolean creative = player != null && player.getGameMode() == GameMode.CREATIVE;
        boolean bl = damage = damagePredicted < 0 && !creative && ToolUtils.receivesDamage(this.config, tool);
        if (damagePredicted > 0) {
            ToolUtils.commitDamage(tool, damagePredicted);
        }
        debug.i("Removing The Tree!");
        if (this.trunk == null) {
            debug.i("trunk is null!");
            return;
        }
        int delay = this.config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_INITIAL_DELAY) ? this.config.getInt(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_INITIAL_DELAY_TIME) * 20 : 0;
        final int offset = this.config.getInt(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_DELAY);
        debug.i("delay: " + delay + "; offset: " + offset);
        final Material sapling = this.config.getMaterial(TreeConfig.CFG.REPLANTING_MATERIAL);
        if (player != null) {
            TreeAssist.instance.setCoolDown(player, this.config, this.trunk);
            if (damage && damagePredicted < 1) {
                TreeAssistPlayerListener.addDestroyer(player, this);
            }
        }
        final boolean statPickup = this.config.getBoolean(TreeConfig.CFG.BLOCK_STATISTICS_PICKUP);
        final boolean statMineBlock = this.config.getBoolean(TreeConfig.CFG.BLOCK_STATISTICS_MINE_BLOCK);
        debug.i("pickup: " + statPickup + "; mine: " + statMineBlock);
        final LinkedHashSet<Block> removeBlocks = new LinkedHashSet<Block>(this.trunk);
        debug.i("trunk blocks: " + removeBlocks.size());
        debug.i("this trunk is: " + this.trunk.hashCode());
        if (this.branchMap != null && this.branchMap.size() > 0) {
            for (List<Block> blocks : this.branchMap.values()) {
                if (blocks == null) continue;
                removeBlocks.addAll(blocks);
                debug.i("branch blocks: " + blocks.size());
            }
        }
        if (this.extras == null) {
            this.extras = new HashSet<Block>();
        }
        if (offset >= 0) {
            BlockUtils.sortBottomUp(removeBlocks);
            if (this.extras.size() > 0) {
                BlockUtils.sortInsideOut(this.extras, this.bottom);
            }
        }
        if (statPickup && player != null) {
            BlockUtils.updatePickup(player, this.trunk.get(0).getType(), removeBlocks.size());
        }
        if (statMineBlock && player != null) {
            BlockUtils.updateMining(player, this.trunk.get(0).getType(), removeBlocks.size());
        }
        if (this.config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_REMOVE_LEAVES)) {
            removeBlocks.addAll(this.extras);
            debug.i("extra blocks: " + this.extras.size());
        }
        boolean cleanUpLeaves = this.config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_CLEANUP_LEAVES);
        List<Material> leaves = this.config.getMaterials(TreeConfig.CFG.BLOCKS_MATERIALS);
        CleanRunner cleaner = new CleanRunner(this, offset, removeBlocks, sapling, cleanUpLeaves, leaves);
        if (player != null) {
            class InstantRunner
            extends BukkitRunnable {
                InstantRunner() {
                }

                public void run() {
                    if (offset < 0) {
                        for (Block block : removeBlocks) {
                            if (sapling.equals((Object)block.getType())) {
                                debug.i("InstantRunner: skipping breaking a sapling");
                                continue;
                            }
                            debug.i("InstantRunner: 1 " + BlockUtils.printBlock(block));
                            TreeStructure.this.maybeBreakBlock(block, tool, player, statPickup, statMineBlock, damage, creative);
                            if (!damage || !ToolUtils.willBreak(tool, player)) continue;
                            this.cancel();
                            TreeAssistPlayerListener.removeDestroyer(player, TreeStructure.this);
                            return;
                        }
                        removeBlocks.clear();
                    } else {
                        for (Block block : removeBlocks) {
                            if (sapling.equals((Object)block.getType())) {
                                debug.i("InstantRunner: skipping breaking a sapling");
                                continue;
                            }
                            if (block.getType() == Material.AIR) {
                                debug.i("InstantRunner: 2 AIR " + BlockUtils.printBlock(block));
                                continue;
                            }
                            debug.i("InstantRunner: 2b " + BlockUtils.printBlock(block));
                            TreeStructure.this.maybeBreakBlock(block, tool, player, statPickup, statMineBlock, damage, creative);
                            if (damage && ToolUtils.willBreak(tool, player)) {
                                this.cancel();
                                TreeAssistPlayerListener.removeDestroyer(player, TreeStructure.this);
                                return;
                            }
                            removeBlocks.remove(block);
                            return;
                        }
                    }
                    try {
                        TreeAssistPlayerListener.removeDestroyer(player, TreeStructure.this);
                        this.cancel();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            new InstantRunner().runTaskTimer((Plugin)TreeAssist.instance, delay, offset);
        }
        int cleanDelay = this.config.getInt(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_CLEANUP_DELAY_TIME);
        cleaner.runTaskTimer((Plugin)TreeAssist.instance, (long)cleanDelay * 20L, offset);
    }

    private void setSpecificBottoms(List<Block> bottoms) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Block block : bottoms) {
            if (block.getX() <= minX) {
                if (block.getZ() <= minZ) {
                    this.northWestBlock = block;
                    minX = block.getX();
                    minZ = block.getZ();
                }
                if (block.getZ() >= maxZ) {
                    this.southWestBlock = block;
                    minX = block.getX();
                    maxZ = block.getZ();
                }
            }
            if (block.getX() < maxX) continue;
            if (block.getZ() <= minZ) {
                this.northEastBlock = block;
                maxX = block.getX();
                minZ = block.getZ();
            }
            if (block.getZ() < maxZ) continue;
            this.southEastBlock = block;
            maxX = block.getX();
            maxZ = block.getZ();
        }
    }

    public void setValid(boolean value) {
        if (this.discoveryResult == null) {
            return;
        }
        this.discoveryResult.setValid(value);
    }

    public void plantSaplings() {
        debug.i("We are now planning to replant!");
        ArrayList<TreeAssistReplantDelay> mySaplings = new ArrayList<TreeAssistReplantDelay>(this.saplings);
        for (TreeAssistReplantDelay replanting : mySaplings) {
            replanting.commit();
        }
        if (this.saplings.size() > 0) {
            debug.explain(TreeAssistDebugger.ErrorType.SAPLING, this.bottom, ChatColor.GREEN + "Found saplings for replanting.");
        } else {
            debug.explain(TreeAssistDebugger.ErrorType.SAPLING, this.bottom, "No sapling places found for replanting.");
        }
        this.saplings.clear();
    }

    public void addReplantDelay(TreeAssistReplantDelay delay) {
        delay.setTree(this);
        this.saplings.add(delay);
    }

    public void setFailReason(FailReason reason) {
        if (this.discoveryResult == null) {
            this.discoveryResult = new DiscoveryResult(this.config, this, reason);
            return;
        }
        this.discoveryResult.setReason(reason);
    }

    static {
        continuations.put(BlockFace.EAST, new BlockFace[]{BlockFace.EAST});
        continuations.put(BlockFace.NORTH, new BlockFace[]{BlockFace.NORTH});
        continuations.put(BlockFace.SOUTH, new BlockFace[]{BlockFace.SOUTH});
        continuations.put(BlockFace.WEST, new BlockFace[]{BlockFace.WEST});
        continuations.put(BlockFace.NORTH_EAST, new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.NORTH_EAST});
        continuations.put(BlockFace.NORTH_WEST, new BlockFace[]{BlockFace.NORTH, BlockFace.WEST, BlockFace.NORTH_WEST});
        continuations.put(BlockFace.SOUTH_EAST, new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.SOUTH_EAST});
        continuations.put(BlockFace.SOUTH_WEST, new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.SOUTH_WEST});
        diagonalContinuations.put(BlockFace.NORTH, new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST});
        diagonalContinuations.put(BlockFace.SOUTH, new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST});
        diagonalContinuations.put(BlockFace.EAST, new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.NORTH_EAST, BlockFace.SOUTH_EAST, BlockFace.EAST});
        diagonalContinuations.put(BlockFace.WEST, new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.NORTH_WEST, BlockFace.SOUTH_WEST, BlockFace.WEST});
        diagonalContinuations.put(BlockFace.NORTH_EAST, new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.NORTH_EAST});
        diagonalContinuations.put(BlockFace.NORTH_WEST, new BlockFace[]{BlockFace.NORTH, BlockFace.WEST, BlockFace.NORTH_WEST});
        diagonalContinuations.put(BlockFace.SOUTH_EAST, new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.SOUTH_EAST});
        diagonalContinuations.put(BlockFace.SOUTH_WEST, new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.SOUTH_WEST});
    }
}

