/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.core;

import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.CoreDebugger;
import net.slipcor.treeassist.core.CorePlugin;
import net.slipcor.treeassist.utils.BlockUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TreeAssistDebugger
extends CoreDebugger {
    private static Player player;
    private static ErrorType error;

    public void explain(ErrorType type, Block block, String message) {
        if (TreeAssistDebugger.isCheckingForError(type, block.getLocation())) {
            TreeAssist.instance.sendPrefixed((CommandSender)player, message + " - " + BlockUtils.printBlock(block));
        }
    }

    public TreeAssistDebugger(CorePlugin plugin, int debugID) {
        super(plugin, debugID);
    }

    public static void setCommandSender(Player sender) {
        player = sender;
    }

    public static void setError(String error) {
        if (error == null) {
            TreeAssistDebugger.error = null;
            return;
        }
        for (ErrorType errorType : ErrorType.values()) {
            if (!errorType.name().equalsIgnoreCase(error)) continue;
            TreeAssistDebugger.error = errorType;
            return;
        }
        TreeAssistDebugger.error = null;
    }

    public static boolean isCheckingForError(ErrorType check, Location location) {
        if (error == null || player == null) {
            return false;
        }
        if (player.getLocation().distanceSquared(location) > 10000.0) {
            return false;
        }
        if (error == ErrorType.ALL) {
            return true;
        }
        if (check == ErrorType.DROPS) {
            return error == ErrorType.AUTOCHOP || error == ErrorType.DROPS;
        }
        return error == check;
    }

    public static enum ErrorType {
        ALL,
        DECAY,
        GROW,
        SAPLING,
        DROPS,
        AUTOCHOP,
        CLEANUP;

    }
}

