/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.blocklists.FlatFileBlockList;
import net.slipcor.treeassist.core.CoreCommand;
import net.slipcor.treeassist.core.CorePlugin;
import net.slipcor.treeassist.yml.Language;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class CommandPurge
extends CoreCommand {
    public CommandPurge(CorePlugin plugin) {
        super(plugin, "treeassist.purge", Language.MSG.ERROR_INVALID_ARGUMENT_COUNT);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        block7: {
            if (!this.hasPerms(sender)) {
                TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_PERMISSION_PURGE.parse());
                return;
            }
            if (!this.argCountValid(sender, args, new Integer[]{2})) {
                return;
            }
            if (TreeAssist.instance.blockList instanceof FlatFileBlockList) {
                FlatFileBlockList bl = (FlatFileBlockList)TreeAssist.instance.blockList;
                try {
                    int days = Integer.parseInt(args[1]);
                    int done = bl.purge(days);
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_PURGE_DAYS.parse(String.valueOf(done), args[1]));
                }
                catch (NumberFormatException e) {
                    if (args[1].equalsIgnoreCase("global")) {
                        int done = bl.purge();
                        TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_PURGE_GLOBAL.parse(String.valueOf(done)));
                        break block7;
                    }
                    int done = bl.purge(args[1]);
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_PURGE_WORLD.parse(String.valueOf(done), args[1]));
                }
            } else {
                TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_ONLY_TREEASSIST_BLOCKLIST.parse());
            }
        }
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            results.add("global");
            ArrayList<String> worlds = new ArrayList<String>();
            for (World world : Bukkit.getServer().getWorlds()) {
                worlds.add(world.getName());
            }
            Collections.sort(worlds);
            results.addAll(worlds);
            return results;
        }
        if (args.length > 2) {
            return results;
        }
        if ("global".startsWith(args[1].toLowerCase())) {
            results.add("global");
        }
        ArrayList<String> worlds = new ArrayList<String>();
        for (World world : Bukkit.getServer().getWorlds()) {
            if (!world.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
            worlds.add(world.getName());
        }
        Collections.sort(worlds);
        results.addAll(worlds);
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("purge");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!p");
    }

    @Override
    public String getShortInfo() {
        return "/treeassist purge - [global/world/days] {days} - purge entries for worlds/days";
    }
}

