/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.ConfigEntry;
import net.slipcor.treeassist.core.CoreCommand;
import net.slipcor.treeassist.core.CorePlugin;
import net.slipcor.treeassist.yml.Language;
import net.slipcor.treeassist.yml.MainConfig;
import org.bukkit.command.CommandSender;

public class CommandConfig
extends CoreCommand {
    final List<MainConfig.CFG> accessibleLists = new ArrayList<MainConfig.CFG>();

    public CommandConfig(CorePlugin plugin) {
        super(plugin, "treeassist.config", Language.MSG.ERROR_INVALID_ARGUMENT_COUNT);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_PERMISSION_CONFIG.parse());
            return;
        }
        if (args.length >= 2 && args[1].toLowerCase().equals("set")) {
            if (!this.argCountValid(sender, args, new Integer[]{4})) {
                return;
            }
            this.set(sender, args[2], args[3]);
            return;
        }
        if (args.length >= 2 && args[1].toLowerCase().equals("get")) {
            if (!this.argCountValid(sender, args, new Integer[]{3})) {
                return;
            }
            this.get(sender, args[2]);
            return;
        }
        if (args.length >= 2 && args[1].toLowerCase().equals("info")) {
            if (!this.argCountValid(sender, args, new Integer[]{3})) {
                return;
            }
            this.info(sender, args[2]);
            return;
        }
        if (args.length >= 2 && args[1].toLowerCase().equals("add")) {
            if (!this.argCountValid(sender, args, new Integer[]{4})) {
                return;
            }
            this.add(sender, args[2], args[3]);
            return;
        }
        if (args.length >= 2 && args[1].toLowerCase().equals("remove")) {
            if (!this.argCountValid(sender, args, new Integer[]{4})) {
                return;
            }
            this.remove(sender, args[2], args[3]);
            return;
        }
        TreeAssist.instance.sendPrefixed(sender, this.getShortInfo());
    }

    private MainConfig.CFG getFullNode(String part) {
        boolean foundEntry = false;
        MainConfig.CFG completedEntry = null;
        for (MainConfig.CFG entry : MainConfig.CFG.values()) {
            if (!entry.getNode().replaceAll("\\s+", "").toLowerCase().contains(part.toLowerCase()) || entry.getNode().length() == part.length()) continue;
            if (foundEntry) {
                foundEntry = false;
                completedEntry = null;
                break;
            }
            foundEntry = true;
            completedEntry = entry;
        }
        return completedEntry;
    }

    private void add(CommandSender sender, String node, String value) {
        ArrayList<String> newList;
        MainConfig.CFG completedEntry = this.getFullNode(node);
        if (completedEntry != null) {
            this.add(sender, completedEntry.getNode(), value);
            return;
        }
        MainConfig.CFG entry = MainConfig.CFG.getByNode(node);
        TreeAssist treeAssist = TreeAssist.instance;
        if (entry == null) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_UNKNOWN_NODE.parse(node));
            return;
        }
        ConfigEntry.Type entryType = entry.getType();
        MainConfig config = treeAssist.config();
        if (entryType == ConfigEntry.Type.COMMENT) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_SET_GROUP_IMPOSSIBLE.parse(node));
            return;
        }
        if (entryType == ConfigEntry.Type.LIST) {
            newList = new ArrayList<String>(config.getStringList(entry, new ArrayList<String>()));
            if (newList.contains(value)) {
                treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_ADD_SKIPPED.parse(node, value));
                return;
            }
        } else {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_NO_LIST.parse(node));
            return;
        }
        newList.add(value);
        config.setValue(entry, newList);
        treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_ADD_SUCCESS.parse(node, value));
        config.save();
        config.load();
    }

    private void get(CommandSender sender, String node) {
        MainConfig.CFG completedEntry = this.getFullNode(node);
        if (completedEntry != null) {
            this.get(sender, completedEntry.getNode());
            return;
        }
        MainConfig.CFG entry = MainConfig.CFG.getByNode(node);
        TreeAssist treeAssist = TreeAssist.instance;
        if (entry == null) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_UNKNOWN_NODE.parse(node));
            return;
        }
        ConfigEntry.Type entryType = entry.getType();
        MainConfig config = treeAssist.config();
        if (entryType == ConfigEntry.Type.COMMENT) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_GET_GROUP_IMPOSSIBLE.parse(node));
        } else if (entryType == ConfigEntry.Type.LIST) {
            StringBuffer value = new StringBuffer();
            List<String> list = config.getStringList(entry, new ArrayList<String>());
            for (String item : list) {
                value.append("\n");
                value.append(item);
            }
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_GET_SUCCESS.parse(node, value.toString()));
        } else if (entryType == ConfigEntry.Type.BOOLEAN) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_GET_SUCCESS.parse(node, String.valueOf(config.getBoolean(entry))));
        } else if (entryType == ConfigEntry.Type.STRING) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_GET_SUCCESS.parse(node, config.getString(entry)));
        } else if (entryType == ConfigEntry.Type.INT) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_GET_SUCCESS.parse(node, String.valueOf(config.getInt(entry))));
        } else if (entryType == ConfigEntry.Type.DOUBLE) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_GET_SUCCESS.parse(node, String.format("%.2f", config.getDouble(entry))));
        } else {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_UNKNOWN_TYPE.parse(entryType.name()));
        }
    }

    private void info(CommandSender sender, String node) {
        MainConfig.CFG completedEntry = this.getFullNode(node);
        if (completedEntry != null) {
            this.info(sender, completedEntry.getNode());
            return;
        }
        MainConfig.CFG entry = MainConfig.CFG.getByNode(node);
        TreeAssist treeAssist = TreeAssist.instance;
        if (entry == null) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_UNKNOWN_NODE.parse(node));
            return;
        }
        if (entry.getComment() == null || entry.getComment().isEmpty()) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_INFO_EMPTY.parse(node));
        } else {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_INFO_SUCCESS.parse(node, "\n" + entry.getComment()));
        }
    }

    private void remove(CommandSender sender, String node, String value) {
        ArrayList<String> newList;
        MainConfig.CFG completedEntry = this.getFullNode(node);
        if (completedEntry != null) {
            this.remove(sender, completedEntry.getNode(), value);
            return;
        }
        MainConfig.CFG entry = MainConfig.CFG.getByNode(node);
        TreeAssist treeAssist = TreeAssist.instance;
        if (entry == null) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_UNKNOWN_NODE.parse(node));
            return;
        }
        ConfigEntry.Type entryType = entry.getType();
        MainConfig config = treeAssist.config();
        if (entryType == ConfigEntry.Type.COMMENT) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_SET_GROUP_IMPOSSIBLE.parse(node));
            return;
        }
        if (entryType == ConfigEntry.Type.LIST) {
            newList = new ArrayList<String>(config.getStringList(entry, new ArrayList<String>()));
            if (!newList.contains(value)) {
                treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_REMOVE_SKIPPED.parse(node, value));
                return;
            }
        } else {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_NO_LIST.parse(node));
            return;
        }
        newList.remove(value);
        config.setValue(entry, newList);
        treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_REMOVE_SUCCESS.parse(node, value));
        config.save();
        config.load();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void set(CommandSender sender, String node, String value) {
        MainConfig.CFG completedEntry = this.getFullNode(node);
        if (completedEntry != null) {
            this.set(sender, completedEntry.getNode(), value);
            return;
        }
        MainConfig.CFG entry = MainConfig.CFG.getByNode(node);
        TreeAssist treeAssist = TreeAssist.instance;
        if (entry == null) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_UNKNOWN_NODE.parse(node));
            return;
        }
        ConfigEntry.Type entryType = entry.getType();
        MainConfig config = treeAssist.config();
        if (entryType == ConfigEntry.Type.COMMENT) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_SET_GROUP_IMPOSSIBLE.parse(node));
            return;
        }
        if (entryType == ConfigEntry.Type.LIST) {
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_SET_LIST_IMPOSSIBLE.parse(node));
            return;
        }
        if (entryType == ConfigEntry.Type.BOOLEAN) {
            if ("true".equalsIgnoreCase(value)) {
                config.setValue(entry, Boolean.TRUE);
                treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_SET_SUCCESS.parse(node, "true"));
            } else {
                if (!"false".equalsIgnoreCase(value)) {
                    treeAssist.sendPrefixed(sender, Language.MSG.ERROR_INVALID_ARGUMENT_TYPE.parse(value, "boolean (true|false)"));
                    return;
                }
                config.setValue(entry, Boolean.FALSE);
                treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_SET_SUCCESS.parse(node, "false"));
            }
        } else if (entryType == ConfigEntry.Type.STRING) {
            config.setValue(entry, String.valueOf(value));
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_SET_SUCCESS.parse(node, value));
        } else if (entryType == ConfigEntry.Type.INT) {
            int iValue;
            try {
                iValue = Integer.parseInt(value);
            }
            catch (Exception e) {
                treeAssist.sendPrefixed(sender, Language.MSG.ERROR_INVALID_NUMBER.parse(value));
                return;
            }
            config.setValue(entry, iValue);
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_SET_SUCCESS.parse(node, String.valueOf(iValue)));
        } else {
            double dValue;
            if (entryType != ConfigEntry.Type.DOUBLE) {
                treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_UNKNOWN_TYPE.parse(entryType.name()));
                return;
            }
            try {
                dValue = Double.parseDouble(value);
            }
            catch (Exception e) {
                treeAssist.sendPrefixed(sender, Language.MSG.ERROR_INVALID_ARGUMENT_TYPE.parse(value, "double (e.g. 12.00)"));
                return;
            }
            config.setValue(entry, dValue);
            treeAssist.sendPrefixed(sender, Language.MSG.ERROR_CONFIG_SET_SUCCESS.parse(node, String.valueOf(dValue)));
        }
        config.save();
        config.load();
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            results.add("get");
            results.add("set");
            results.add("add");
            results.add("info");
            results.add("remove");
        } else if (args.length == 2) {
            this.addIfMatches(results, "get", args[1]);
            this.addIfMatches(results, "set", args[1]);
            this.addIfMatches(results, "add", args[1]);
            this.addIfMatches(results, "info", args[1]);
            this.addIfMatches(results, "remove", args[1]);
        } else {
            if (!(args[1].equalsIgnoreCase("get") || args[1].equalsIgnoreCase("set") || args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("info") || args[1].equalsIgnoreCase("remove"))) {
                return results;
            }
            if (args[2].equals("")) {
                for (MainConfig.CFG entry : MainConfig.CFG.values()) {
                    if (args[1].equalsIgnoreCase("info") ? entry.getComment() == null || entry.getComment().isEmpty() : (args[1].equalsIgnoreCase("get") ? entry.getType() == ConfigEntry.Type.COMMENT : (args[1].equalsIgnoreCase("set") ? entry.getType() == ConfigEntry.Type.COMMENT || entry.getType() == ConfigEntry.Type.LIST : entry.getType() == ConfigEntry.Type.COMMENT || !this.accessibleLists.contains(entry)))) continue;
                    results.add(entry.getNode().replaceAll("\\s+", ""));
                }
                return results;
            }
            if (args.length > 3) {
                return results;
            }
            for (MainConfig.CFG entry : MainConfig.CFG.values()) {
                if (args[1].equalsIgnoreCase("info") ? entry.getComment() == null || entry.getComment().isEmpty() : (args[1].equalsIgnoreCase("get") ? entry.getType() == ConfigEntry.Type.COMMENT : (args[1].equalsIgnoreCase("set") ? entry.getType() == ConfigEntry.Type.COMMENT || entry.getType() == ConfigEntry.Type.LIST : entry.getType() == ConfigEntry.Type.COMMENT || !this.accessibleLists.contains(entry)))) continue;
                this.addIfMatches(results, entry.getNode().replaceAll("\\s+", ""), args[2]);
            }
        }
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("config");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!c");
    }

    @Override
    public String getShortInfo() {
        return "/treeassist config get [node] - get a config value\n/treeassist config info [node] - get information about a config node\n/treeassist config set [node] [value] - set a config value\n/treeassist config add [node] [value] - add a value to a config list\n/treeassist config remove [node] [value] - remove a value from a config list";
    }
}

