/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.blocklists;

import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.QueryParams;
import java.sql.SQLException;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.blocklists.EmptyBlockList;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class LogBlockBlockList
extends EmptyBlockList {
    private final LogBlock logBlock = Bukkit.getPluginManager().isPluginEnabled("LogBlock") ? (LogBlock)Bukkit.getPluginManager().getPlugin("LogBlock") : null;
    private Consumer lbconsumer = null;

    @Override
    public void initiate() {
        if (this.logBlock == null) {
            TreeAssist.instance.getLogger().warning("LogBlock selected as BlockList, but not enabled!");
        }
    }

    @Override
    public boolean isPlayerPlaced(Block block) {
        if (this.logBlock == null || this.lookupTime <= 0) {
            return false;
        }
        QueryParams params = new QueryParams(this.logBlock);
        params.bct = QueryParams.BlockChangeType.ALL;
        params.limit = 1;
        params.loc = block.getLocation();
        params.needType = true;
        params.world = block.getWorld();
        params.since = this.lookupTime / 60;
        try {
            for (BlockChange bc : this.logBlock.getBlockChanges(params)) {
                if (bc.type != QueryParams.BlockChangeType.CREATED.ordinal()) continue;
                return true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void logBreak(Block block, Player player) {
        if (this.logBlock == null) {
            return;
        }
        if (this.lbconsumer == null) {
            this.lbconsumer = this.logBlock.getConsumer();
        }
        this.lbconsumer.queueBlockBreak(player == null ? "TreeAssist" : player.getName(), block.getState());
    }
}

