/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.yml;

import java.io.File;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.utils.StringUtils;
import net.slipcor.treeassist.yml.MainConfig;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;

public class MainConfigUpdater {
    public static boolean check(MainConfig instance, FileConfiguration config) {
        File configFile;
        File subTree;
        File trees;
        double version;
        instance.preLoad();
        int[] serverVersion = StringUtils.splitToVersionArray(Bukkit.getBukkitVersion());
        double newVersion = version = config.getDouble("Version", 7.0);
        boolean changed = false;
        for (Moving moving : Moving.values()) {
            if (!((double)moving.version > version)) continue;
            newVersion = Math.max(newVersion, (double)moving.version);
            config.set(moving.destination, config.get(moving.source));
            config.set(moving.source, null);
            TreeAssist.instance.getLogger().warning("Config node moved: " + moving.toString());
            changed = true;
        }
        for (Enum enum_ : Adding.values()) {
            if (!((double)((Adding)enum_).version > version)) continue;
            newVersion = Math.max(newVersion, (double)((Adding)enum_).version);
            config.set(((Adding)enum_).node.getNode(), ((Adding)enum_).value);
            TreeAssist.instance.getLogger().warning("Config node added: " + enum_.toString());
            changed = true;
        }
        for (Enum enum_ : TreeRemoval.values()) {
            if (!((double)((TreeRemoval)enum_).version > version)) continue;
            newVersion = Math.max(newVersion, (double)((TreeRemoval)enum_).version);
            trees = new File(TreeAssist.instance.getDataFolder(), "trees");
            subTree = new File(trees, ((TreeRemoval)enum_).path);
            configFile = new File(subTree, ((TreeRemoval)enum_).file);
            if (configFile.exists()) {
                configFile.delete();
                TreeAssist.instance.getLogger().info("Config deleted: " + enum_.toString());
            }
            changed = true;
        }
        for (Enum enum_ : TreeAddition.values()) {
            if (!((double)((TreeAddition)enum_).version > version) || !StringUtils.isSupportedVersion(serverVersion, ((TreeAddition)enum_).mcversion)) continue;
            newVersion = Math.max(newVersion, (double)((TreeAddition)enum_).version);
            trees = new File(TreeAssist.instance.getDataFolder(), "trees");
            subTree = new File(trees, ((TreeAddition)enum_).path);
            configFile = new File(subTree, ((TreeAddition)enum_).file);
            if (configFile.exists()) {
                configFile.delete();
            }
            TreeAssist.instance.saveResource("trees/" + ((TreeAddition)enum_).path + "/" + ((TreeAddition)enum_).file, false);
            TreeAssist.instance.getLogger().info("Config created: " + enum_.toString());
            changed = true;
        }
        config.set("Version", (Object)newVersion);
        return changed;
    }

    static enum Adding {
        DESTRUCTION_FALLING_BLOCKS_FANCY(7.0117f, MainConfig.CFG.DESTRUCTION_FALLING_BLOCKS_FANCY, false),
        BSTATS_ACTIVE(7.0147f, MainConfig.CFG.BSTATS_ACTIVE, true),
        BSTATS_FULL(7.0147f, MainConfig.CFG.BSTATS_FULL, true),
        UPDATE_MODE(7.101f, MainConfig.CFG.UPDATE_MODE, "both"),
        UPDATE_TYPE(7.101f, MainConfig.CFG.UPDATE_TYPE, "beta"),
        FULL_MCMMO_TREE(7.1011f, MainConfig.CFG.PLUGINS_USE_TREEMCMMO, true),
        FULL_JOBS_TREE(7.1011f, MainConfig.CFG.PLUGINS_USE_TREEJOBS, true),
        VERBOSE_CONFIG_LOADING(7.2013f, MainConfig.CFG.GENERAL_VERBOSE_CONFIG_LOADING, true),
        PREVENT_WITHOUT_TOOL(7.2014f, MainConfig.CFG.GENERAL_PREVENT_WITHOUT_TOOL, false),
        PLUGINS_USE_CUSTOM_EVENTS(7.2019f, MainConfig.CFG.PLUGINS_USE_CUSTOM_EVENTS, false),
        DESTRUCTION_MESSAGE(7.2021f, MainConfig.CFG.DESTRUCTION_MESSAGE, true),
        FAST_DECAY_REGULAR_DROPS(7.2042f, MainConfig.CFG.DESTRUCTION_FAST_LEAF_DECAY_REGULAR_DROPS, true),
        COMMANDS_REPLANT_COMMAND_TIME_COOLDOWN(7.2044f, MainConfig.CFG.COMMANDS_REPLANT_COMMAND_TIME_COOLDOWN, 30),
        GENERAL_PREVENT_WITH_BREAKING_TOOL(7.2045f, MainConfig.CFG.GENERAL_PREVENT_WITH_BREAKING_TOOL, false),
        GENERAL_TOGGLE_REMEMBER(7.3026f, MainConfig.CFG.GENERAL_TOGGLE_REMEMBER, false),
        PLUGINS_USE_AURELIUMSKILLS(7.331f, MainConfig.CFG.PLUGINS_USE_AURELIUMSKILLS, false),
        PLUGINS_USE_AURELIUMSKILLS_BLOCK(7.331f, MainConfig.CFG.PLUGINS_USE_AURELIUMSKILLS_BLOCK, 0),
        PLUGINS_USE_AURELIUMSKILLS_TREE(7.331f, MainConfig.CFG.PLUGINS_USE_AURELIUMSKILLS_TREE, 0),
        GENERAL_AUTODESTRUCT_IGNORES_UNEXPECTED_BLOCKS(7.332f, MainConfig.CFG.GENERAL_AUTODESTRUCT_IGNORES_UNEXPECTED_BLOCKS, false);

        private final float version;
        private final MainConfig.CFG node;
        private final Object value;

        private Adding(float version, MainConfig.CFG node, Object value) {
            this.version = version;
            this.node = node;
            this.value = value;
        }
    }

    static enum TreeRemoval {
        JUNGLE_BUSH(7.0142f, "overworld", "bush_jungle.yml");

        private final float version;
        private final String path;
        private final String file;

        private TreeRemoval(float v, String p, String f) {
            this.version = v;
            this.path = p;
            this.file = f;
        }
    }

    static enum TreeAddition {
        AZALEA(7.2012f, "overworld", "azalea.yml", new int[]{1, 17, 0}),
        MANGROVE(7.33f, "overworld", "mangrove.yml", new int[]{1, 19, 0}),
        CHERRY(7.341f, "overworld", "cherry.yml", new int[]{1, 20, 0}),
        PALE_OAK(7.358f, "overworld", "pale_oak.yml", new int[]{1, 21, 4});

        private final float version;
        private final String path;
        private final String file;
        private final int[] mcversion;

        private TreeAddition(float v, String p, String f, int[] mcv) {
            this.version = v;
            this.path = p;
            this.file = f;
            this.mcversion = mcv;
        }
    }

    static enum Moving {

        private final float version;
        private final String source;
        private final String destination;

        private Moving(float version, String source, String destination) {
            this.version = version;
            this.source = source;
            this.destination = destination;
        }
    }
}

