/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.discovery.TreeStructure;
import net.slipcor.treeassist.utils.MaterialUtils;
import net.slipcor.treeassist.yml.Language;
import net.slipcor.treeassist.yml.TreeConfig;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ToolUtils {
    private ToolUtils() {
    }

    public static int calculateCoolDown(ItemStack tool, List<Block> blockList) {
        float leafTime;
        float strippedLogTime;
        float logTime;
        Material element = tool != null ? tool.getType() : Material.AIR;
        switch (element) {
            case GOLDEN_AXE: {
                logTime = 0.25f;
                break;
            }
            case NETHERITE_AXE: {
                logTime = 0.35f;
                break;
            }
            case DIAMOND_AXE: {
                logTime = 0.4f;
                break;
            }
            case IRON_AXE: {
                logTime = 0.5f;
                break;
            }
            case STONE_AXE: {
                logTime = 0.75f;
                break;
            }
            case WOODEN_AXE: {
                logTime = 1.5f;
                break;
            }
            default: {
                logTime = 3.0f;
            }
        }
        switch (element) {
            case GOLDEN_AXE: {
                strippedLogTime = 0.15f;
                break;
            }
            case NETHERITE_AXE: 
            case DIAMOND_AXE: {
                strippedLogTime = 0.2f;
                break;
            }
            case IRON_AXE: {
                strippedLogTime = 0.25f;
                break;
            }
            case STONE_AXE: {
                strippedLogTime = 0.4f;
                break;
            }
            case WOODEN_AXE: {
                strippedLogTime = 0.75f;
                break;
            }
            default: {
                strippedLogTime = 1.5f;
            }
        }
        switch (element) {
            case WOODEN_SWORD: 
            case STONE_SWORD: 
            case IRON_SWORD: 
            case NETHERITE_SWORD: 
            case DIAMOND_SWORD: 
            case GOLDEN_SWORD: {
                leafTime = 0.2f;
                break;
            }
            case GOLDEN_HOE: 
            case NETHERITE_HOE: 
            case DIAMOND_HOE: 
            case IRON_HOE: 
            case SHEARS: {
                leafTime = 0.05f;
                break;
            }
            case STONE_HOE: {
                leafTime = 0.1f;
                break;
            }
            case WOODEN_HOE: {
                leafTime = 0.2f;
                break;
            }
            default: {
                leafTime = 0.35f;
            }
        }
        float efficiencyFactor = 1.0f;
        if (tool != null && tool.hasItemMeta()) {
            int efficiencyLevel = tool.getItemMeta().getEnchantLevel(Enchantment.DIG_SPEED);
            for (int i = 0; i < efficiencyLevel; ++i) {
                efficiencyFactor /= 1.3f;
            }
        }
        float times = 0.0f;
        for (Block b : blockList) {
            if (b.getType().name().contains("STRIPPED")) {
                times += strippedLogTime;
                continue;
            }
            if (b.getType().name().contains("LEAVES")) {
                times += leafTime;
                continue;
            }
            if (!MaterialUtils.isLog(b.getType())) continue;
            times += logTime;
        }
        return (int)(times * efficiencyFactor);
    }

    public static boolean isMatchingTool(ItemStack inHand, TreeConfig treeConfig) {
        TreeStructure.debug.i("in hand: " + inHand.getType());
        List<Material> fromConfigMat = treeConfig.getInheritedMaterials(TreeConfig.CFG.TOOL_LIST);
        if (fromConfigMat.contains(inHand.getType())) {
            return true;
        }
        TreeStructure.debug.i("valid: " + inHand.getType());
        for (Material mat : fromConfigMat) {
            TreeStructure.debug.i(mat.toString());
        }
        List<String> fromConfig = treeConfig.getInheritedStringList(TreeConfig.CFG.TOOL_LIST, null);
        for (String tool : fromConfig) {
            String[] values;
            if (!tool.toLowerCase().contains(inHand.getType().name().toLowerCase())) continue;
            if (tool.startsWith("minecraft:")) {
                tool = tool.substring(10);
            }
            if (tool.contains("minecraft~")) {
                tool = tool.replace("minecraft~", "");
            }
            if ((values = tool.split(":")).length < 2) {
                return true;
            }
            for (Enchantment ench : inHand.getEnchantments().keySet()) {
                int level;
                String enchantment = ench.getKey().getKey().replace(':', '~');
                if (!enchantment.equalsIgnoreCase(values[1])) continue;
                if (values.length < 3) {
                    return true;
                }
                try {
                    level = Integer.parseInt(values[2]);
                }
                catch (Exception e) {
                    return true;
                }
                if (level > (Integer)inHand.getEnchantments().get(ench)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isVanillaTool(ItemStack itemStack) {
        String type = itemStack.getType().name().toLowerCase();
        return type.endsWith("_axe") || type.endsWith("_hoe") || type.endsWith("_pickaxe") || type.endsWith("_sword") || type.endsWith("_shovel");
    }

    public static void toolAdd(Player player, TreeConfig treeConfig) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR) {
            item = player.getInventory().getItemInOffHand();
        }
        if (item.getType() == Material.AIR) {
            TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.ERROR_EMPTY_HAND.parse());
            return;
        }
        if (ToolUtils.isMatchingTool(item, treeConfig)) {
            TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.ERROR_ADDTOOL_ALREADY.parse());
            return;
        }
        StringBuilder entry = new StringBuilder();
        try {
            entry.append(item.getType().name());
        }
        catch (Exception e) {
            String msg = "Could not retrieve item type name: " + item.getType();
            TreeAssist.instance.getLogger().severe(msg);
            TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.ERROR_ADDTOOL_OTHER.parse(msg));
            return;
        }
        boolean found = false;
        for (Enchantment ench : item.getEnchantments().keySet()) {
            if (found) {
                TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.WARNING_ADDTOOL_ONLYONE.parse(ench.getKey().getKey()));
                break;
            }
            entry.append(':');
            entry.append(ench.getKey().toString().replace(':', '~'));
            entry.append(':');
            entry.append(item.getEnchantmentLevel(ench));
            found = true;
        }
        List<String> fromConfig = treeConfig.getStringList(TreeConfig.CFG.TOOL_LIST, new ArrayList<String>());
        ArrayList<String> result = new ArrayList<String>(fromConfig);
        result.add(entry.toString());
        treeConfig.getYamlConfiguration().set(TreeConfig.CFG.TOOL_LIST.getNode(), result);
        treeConfig.save();
        TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.SUCCESSFUL_ADDTOOL.parse(entry.toString()));
    }

    public static void toolRemove(Player player, TreeConfig treeConfig) {
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (inHand.getType() == Material.AIR) {
            inHand = player.getInventory().getItemInOffHand();
        }
        if (inHand.getType() == Material.AIR) {
            TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.ERROR_EMPTY_HAND.parse());
            return;
        }
        String definition = null;
        List<String> fromConfig = treeConfig.getStringList(TreeConfig.CFG.TOOL_LIST, new ArrayList<String>());
        if (fromConfig.contains(inHand.getType().name())) {
            fromConfig.remove(inHand.getType().name());
            definition = inHand.getType().name();
        } else if (fromConfig.contains(inHand.getType().getKey().toString())) {
            fromConfig.remove(inHand.getType().getKey().toString());
            definition = inHand.getType().getKey().toString();
        } else {
            for (String tool : fromConfig) {
                if (!tool.startsWith(inHand.getType().name()) && !tool.startsWith(inHand.getType().getKey().toString())) continue;
                String[] values = tool.split(":");
                if (values.length < 2) {
                    definition = tool;
                    continue;
                }
                for (Enchantment ench : inHand.getEnchantments().keySet()) {
                    if (!values[1].contains(ench.getKey().getKey().replace(':', '~'))) continue;
                    int level = 0;
                    if (values.length >= 3) {
                        try {
                            level = Integer.parseInt(values[2]);
                        }
                        catch (Exception e) {
                            definition = tool;
                        }
                        if (level > (Integer)inHand.getEnchantments().get(ench)) continue;
                    }
                    definition = tool;
                }
            }
            if (definition == null) {
                TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.ERROR_REMOVETOOL_NOTDONE.parse());
                return;
            }
            fromConfig.remove(definition);
        }
        treeConfig.getYamlConfiguration().set(TreeConfig.CFG.TOOL_LIST.getNode(), fromConfig);
        treeConfig.save();
        TreeAssist.instance.sendPrefixed((CommandSender)player, Language.MSG.SUCCESSFUL_REMOVETOOL.parse(definition));
    }

    public static boolean receivesDamage(TreeConfig config, ItemStack tool) {
        if (tool == null) {
            return false;
        }
        if (!config.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_APPLY_FULL_TOOL_DAMAGE)) {
            return false;
        }
        if (tool.hasItemMeta() && tool.getItemMeta() != null) {
            return !tool.getItemMeta().isUnbreakable();
        }
        return true;
    }

    public static String printTool(ItemStack tool) {
        if (tool == null) {
            return "null";
        }
        return tool.getType().name();
    }

    public static boolean willBreak(ItemStack tool, Player player) {
        if (tool != null && tool.getType().getMaxDurability() > 0 && tool.getDurability() == tool.getType().getMaxDurability()) {
            TreeStructure.debug.i("removing item: " + player.getInventory().getItemInMainHand().getType().name() + " (durability " + tool.getDurability() + "==" + tool.getType().getMaxDurability());
            player.getInventory().remove(tool);
            return true;
        }
        return false;
    }

    public static int calculateDamage(TreeConfig config, ItemStack tool) {
        if (tool == null) {
            return 0;
        }
        if (tool.containsEnchantment(Enchantment.DURABILITY)) {
            int damageChance = (int)(100.0 / ((double)tool.getEnchantmentLevel(Enchantment.DURABILITY) + 1.0));
            int random = new Random().nextInt(100);
            if (random >= damageChance) {
                return 0;
            }
        }
        int ench = 100;
        if (tool.getEnchantments().containsKey(Enchantment.DURABILITY)) {
            ench = 100 / (tool.getEnchantmentLevel(Enchantment.DURABILITY) + 1);
        }
        if (new Random().nextInt(100) > ench) {
            return 0;
        }
        if (config.getMaterials(TreeConfig.CFG.TOOL_LIST).contains(tool.getType())) {
            return 1;
        }
        if (ToolUtils.isVanillaTool(tool)) {
            return 2;
        }
        return 0;
    }

    public static void commitDamage(ItemStack tool, int damagePredicted) {
        if (tool == null) {
            return;
        }
        ItemMeta meta = tool.getItemMeta();
        if (meta != null) {
            ((Damageable)meta).setDamage(((Damageable)meta).getDamage() + damagePredicted);
            tool.setItemMeta(meta);
        }
    }

    public static int calculateDamage(TreeConfig config, ItemStack tool, TreeStructure tree) {
        if (tree == null || !tree.isValid()) {
            return 0;
        }
        int result = 0;
        for (int count = tree.trunk.size(); count > 0; --count) {
            result += ToolUtils.calculateDamage(config, tool);
        }
        return result;
    }

    public static boolean wouldBreak(ItemStack tool, int damage) {
        if (tool == null || tool.getItemMeta() == null) {
            return false;
        }
        if (TreeAssist.instance.getPlayerListener().isDebugTool(tool)) {
            return false;
        }
        return tool.getType().getMaxDurability() <= ((Damageable)tool.getItemMeta()).getDamage() + damage;
    }
}

