/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.runnables;

import java.util.Set;
import java.util.UUID;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.discovery.TreeStructure;
import net.slipcor.treeassist.runnables.TreeAssistProtect;
import net.slipcor.treeassist.utils.BlockUtils;
import net.slipcor.treeassist.yml.TreeConfig;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class TreeAssistReplantDelay {
    Runnable runnable;
    int delayTicks;
    TreeStructure tree;
    Block saplingBlock;
    UUID entityID;
    Entity entity;
    boolean expectsEntity;

    public TreeAssistReplantDelay(TreeStructure tree, Block saplingBlock, Runnable runnable, int delayTicks, Entity entity, boolean expectsEntity) {
        this.runnable = runnable;
        this.delayTicks = delayTicks;
        this.tree = tree;
        this.saplingBlock = saplingBlock;
        this.entity = entity;
        this.entityID = entity == null ? null : entity.getUniqueId();
        this.expectsEntity = expectsEntity;
    }

    public void commit() {
        if (this.entity == null && this.expectsEntity) {
            return;
        }
        int distance = this.tree.getConfig().getInt(TreeConfig.CFG.BLOCKS_MIDDLE_RADIUS) * 2;
        Set<TreeStructure> trees = TreeAssist.instance.treesThatQualify(this.tree.getConfig(), this.saplingBlock, distance * distance);
        for (TreeStructure tree : trees) {
            if (!tree.isValid() || tree.equals(this.tree)) continue;
            tree.addReplantDelay(this);
            TreeStructure.debug.i("moving sapling from " + this.tree + " to " + tree);
            return;
        }
        TreeStructure.debug.i("committing TreeAssistReplantDelay " + this.tree);
        TreeAssist.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)TreeAssist.instance, this.runnable, (long)(20 * this.delayTicks));
        int timeToProtect = this.tree.getConfig().getInt(TreeConfig.CFG.REPLANTING_PROTECT_FOR_SECONDS);
        if ((timeToProtect += this.delayTicks) > 0) {
            TreeAssistProtect X;
            TreeStructure.debug.i("Sapling at " + this.saplingBlock.getLocation().getBlock() + " will be protected for " + timeToProtect + " seconds");
            if (this.delayTicks > 0) {
                TreeStructure.debug.i("Sapling will be protected (after " + this.delayTicks + ") at " + BlockUtils.printBlock(this.saplingBlock));
                X = new TreeAssistProtect(this.saplingBlock.getLocation());
                TreeAssist.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)TreeAssist.instance, () -> TreeAssist.instance.saplingLocationList.add(this.saplingBlock.getLocation()), (long)(20 * this.delayTicks));
                TreeAssist.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)TreeAssist.instance, (Runnable)X, (long)(20 * timeToProtect));
            } else {
                TreeStructure.debug.i("Sapling will be protected at " + BlockUtils.printBlock(this.saplingBlock));
                TreeAssist.instance.saplingLocationList.add(this.saplingBlock.getLocation());
                X = new TreeAssistProtect(this.saplingBlock.getLocation());
                TreeAssist.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)TreeAssist.instance, (Runnable)X, (long)(20 * timeToProtect));
            }
        } else {
            TreeStructure.debug.i("Saplings do not need to be protected");
        }
    }

    public void setTree(TreeStructure tree) {
        this.tree = tree;
    }
}

