/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.runnables;

import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.discovery.TreeStructure;
import net.slipcor.treeassist.utils.BlockUtils;
import net.slipcor.treeassist.yml.TreeConfig;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class TreeAssistReplant
implements Runnable {
    private final TreeConfig config;
    public Block block;
    public Material mat;

    public TreeAssistReplant(Block block, Material material, TreeConfig config) {
        this.block = block;
        this.mat = material;
        this.config = config;
    }

    @Override
    public void run() {
        TreeStructure.debug.i("TreeAssistReplant!");
        Material below = this.block.getRelative(BlockFace.DOWN).getType();
        if (TreeAssist.instance.isEnabled() && this.config.getMaterials(TreeConfig.CFG.GROUND_BLOCKS).contains(below)) {
            TreeStructure.debug.i("Replanting block: " + BlockUtils.printBlock(this.block));
            if (this.block.getType().isSolid() && !this.config.getBoolean(TreeConfig.CFG.REPLANTING_ENFORCE)) {
                TreeStructure.debug.i("We are not enforcing!");
                return;
            }
            this.block.setType(this.mat);
            if (this.config.getInt(TreeConfig.CFG.REPLANTING_GROWTH_DELAY_SECONDS) > 0) {
                TreeAssist.instance.getBlockListener().getAntiGrow().add(this.block, this.config.getInt(TreeConfig.CFG.REPLANTING_GROWTH_DELAY_SECONDS));
            }
        } else {
            TreeStructure.debug.i("Not a ground block: " + below.name());
        }
    }
}

